/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.session;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.session.SecurityHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAutorizationSecurityHandler
implements SecurityHandler {
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuditContext auditContext = Console.instance().initAuditContext(request);
        Throwable throwable = null;
        Object var5_6 = null;
        try (AuditContext.Scope scope = AuditContext.openScope((AuditContext)auditContext);){
            HttpSession session = request.getSession(false);
            if (session == null) {
                return false;
            }
            Object authorized = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
            if (!(authorized instanceof String)) {
                auditLogger.warn("{} UI Session - Failure - User is not authenticated", (Object)auditContext);
                return false;
            }
            String userName = (String)authorized;
            boolean isPasswordSame = Objects.equals(session.getAttribute(Attributes.CREDENTIALS_HASH.getValue()), Console.instance().getUserManager().getCredentialsHash(userName));
            if (isPasswordSame) return isPasswordSame;
            auditLogger.warn("{} UI Session - Failure - Ending session due to identity password change", (Object)auditContext);
            return isPasswordSame;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

