/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.servlet.AuditServlet;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSnapshotsServlet
extends AuditServlet {
    private static final long serialVersionUID = -2533869595709953567L;
    private static Logger logger = LoggerFactory.getLogger(DeviceSnapshotsServlet.class);

    public DeviceSnapshotsServlet() {
        super("UI Snapshots", "Return device snapshot");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            GwtXSRFToken token = new GwtXSRFToken(request.getParameter("xsrfToken"));
            KuraRemoteServiceServlet.checkXSRFToken(request, token);
        }
        catch (Exception e) {
            throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
        }
        try {
            String snapshotId = request.getParameter("snapshotId");
            ServiceLocator locator = ServiceLocator.getInstance();
            ConfigurationService cs = locator.getService(ConfigurationService.class);
            if (snapshotId != null) {
                long sid = Long.parseLong(snapshotId);
                List configs = cs.getSnapshot(sid);
                GwtServerUtil.writeSnapshot(request, response, configs, "snapshot_" + sid);
            }
        }
        catch (Exception e) {
            logger.error("Error exporting snapshot");
            throw new ServletException((Throwable)e);
        }
    }
}

