/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.position;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NmeaPosition {
    private double latitude;
    private double longitude;
    private double altitude;
    private double speed;
    private double track;
    private int fixQuality;
    private int nrSatellites;
    private double mDOP;
    private double mPDOP;
    private double mHDOP;
    private double mVDOP;
    private int m3Dfix;
    private char validFix;
    private char latitudeHemisphere;
    private char longitudeHemisphere;

    public NmeaPosition(double lat, double lon, double alt, double speed, double track) {
        this(lat, lon, alt, speed, track, 0, 0, 0.0, 0.0, 0.0, 0.0, 0, '0', '0', '0');
    }

    public NmeaPosition(double lat, double lon, double alt, double speed, double track, int fixQuality, int nrSatellites, double dop, double pdop, double hdop, double vdop, int fix3D) {
        this(lat, lon, alt, speed, track, fixQuality, nrSatellites, dop, pdop, hdop, vdop, fix3D, '0', '0', '0');
    }

    public NmeaPosition(double lat, double lon, double alt, double speed, double track, int fixQuality, int nrSatellites, double dop, double pdop, double hdop, double vdop, int fix3D, char validF, char hemiLat, char hemiLon) {
        this.latitude = lat;
        this.longitude = lon;
        this.altitude = alt;
        this.speed = speed;
        this.track = track;
        this.fixQuality = fixQuality;
        this.nrSatellites = nrSatellites;
        this.mDOP = dop;
        this.mPDOP = pdop;
        this.mHDOP = hdop;
        this.mVDOP = vdop;
        this.m3Dfix = fix3D;
        this.validFix = validF;
        this.latitudeHemisphere = hemiLat;
        this.longitudeHemisphere = hemiLon;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getSpeedKmh() {
        return this.speed * 3.6;
    }

    public double getSpeedMph() {
        return this.speed * 2.24;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getTrack() {
        return this.track;
    }

    public void setTrack(double track) {
        this.track = track;
    }

    public int getFixQuality() {
        return this.fixQuality;
    }

    public void setFixQuality(int fixQuality) {
        this.fixQuality = fixQuality;
    }

    public int getNrSatellites() {
        return this.nrSatellites;
    }

    public void setNrSatellites(int nrSatellites) {
        this.nrSatellites = nrSatellites;
    }

    public double getDOP() {
        return this.mDOP;
    }

    public void setDOP(double dop) {
        this.mDOP = dop;
    }

    public double getPDOP() {
        return this.mPDOP;
    }

    public void setPDOP(double pdop) {
        this.mPDOP = pdop;
    }

    public double getHDOP() {
        return this.mHDOP;
    }

    public void setHDOP(double hdop) {
        this.mHDOP = hdop;
    }

    public double getVDOP() {
        return this.mVDOP;
    }

    public void setVDOP(double vdop) {
        this.mVDOP = vdop;
    }

    public int get3Dfix() {
        return this.m3Dfix;
    }

    public void set3Dfix(int fix3D) {
        this.m3Dfix = fix3D;
    }

    public char getValidFix() {
        return this.validFix;
    }

    public void setValidFix(char validFix) {
        this.validFix = validFix;
    }

    public char getLatitudeHemisphere() {
        return this.latitudeHemisphere;
    }

    public void setLatitudeHemisphere(char latitudeHemisphere) {
        this.latitudeHemisphere = latitudeHemisphere;
    }

    public char getLongitudeHemisphere() {
        return this.longitudeHemisphere;
    }

    public void setLongitudeHemisphere(char longitudeHemisphere) {
        this.longitudeHemisphere = longitudeHemisphere;
    }
}

