/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class NetConfigIP<T extends IPAddress>
implements NetConfig {
    private NetInterfaceStatus status;
    private boolean autoConnect;
    private boolean dhcp;
    private T address;
    private short networkPrefixLength;
    private T subnetMask;
    private T gateway;
    private List<T> dnsServers;
    private List<String> domains;
    private Map<String, Object> properties;

    NetConfigIP(NetInterfaceStatus status, boolean autoConnect) {
        this.status = status;
        this.autoConnect = autoConnect;
        this.dhcp = false;
        this.address = null;
        this.networkPrefixLength = (short)-1;
        this.subnetMask = null;
        this.gateway = null;
        this.dnsServers = new ArrayList<T>();
        this.domains = new ArrayList<String>();
        this.properties = new HashMap<String, Object>();
    }

    NetConfigIP(NetInterfaceStatus status, boolean autoConnect, boolean dhcp) {
        this.status = status;
        this.autoConnect = autoConnect;
        this.dhcp = dhcp;
        this.address = null;
        this.networkPrefixLength = (short)-1;
        this.subnetMask = null;
        this.gateway = null;
        this.dnsServers = new ArrayList<T>();
        this.domains = new ArrayList<String>();
        this.properties = new HashMap<String, Object>();
    }

    NetConfigIP(NetInterfaceStatus status, boolean autoConnect, T address, short networkPrefixLength, T gateway) throws KuraException {
        this.status = status;
        this.autoConnect = autoConnect;
        this.dhcp = false;
        this.address = address;
        this.networkPrefixLength = networkPrefixLength;
        this.subnetMask = this.calculateNetmaskFromNetworkPrefix(networkPrefixLength);
        this.gateway = gateway;
        this.dnsServers = new ArrayList<T>();
        this.domains = new ArrayList<String>();
        this.properties = new HashMap<String, Object>();
    }

    NetConfigIP(NetInterfaceStatus status, boolean autoConnect, T address, T subnetMask, T gateway) throws KuraException {
        this.status = status;
        this.autoConnect = autoConnect;
        this.dhcp = false;
        this.address = address;
        this.networkPrefixLength = this.calculateNetworkPrefixFromNetmask(((IPAddress)subnetMask).getHostAddress());
        this.subnetMask = subnetMask;
        this.gateway = gateway;
        this.dnsServers = new ArrayList<T>();
        this.domains = new ArrayList<String>();
        this.properties = new HashMap<String, Object>();
    }

    public NetInterfaceStatus getStatus() {
        return this.status;
    }

    public void setStatus(NetInterfaceStatus status) {
        this.status = status;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    public boolean isDhcp() {
        return this.dhcp;
    }

    public void setDhcp(boolean dhcp) {
        this.dhcp = dhcp;
    }

    public T getAddress() {
        return this.address;
    }

    public void setAddress(T address) {
        this.address = address;
    }

    public short getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    public void setNetworkPrefixLength(short networkPrefixLength) throws KuraException {
        this.networkPrefixLength = networkPrefixLength;
        this.subnetMask = this.calculateNetmaskFromNetworkPrefix(networkPrefixLength);
    }

    public T getSubnetMask() {
        return this.subnetMask;
    }

    public void setSubnetMask(T subnetMask) throws KuraException {
        this.networkPrefixLength = this.calculateNetworkPrefixFromNetmask(((IPAddress)subnetMask).getHostAddress());
        this.subnetMask = subnetMask;
    }

    public T getGateway() {
        return this.gateway;
    }

    public void setGateway(T gateway) {
        this.gateway = gateway;
    }

    public List<T> getDnsServers() {
        if (this.dnsServers != null) {
            return Collections.unmodifiableList(this.dnsServers);
        }
        return null;
    }

    public void setDnsServers(List<T> dnsServers) {
        this.dnsServers = dnsServers;
    }

    public List<String> getDomains() {
        if (this.domains != null) {
            return Collections.unmodifiableList(this.domains);
        }
        return null;
    }

    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            return Collections.unmodifiableMap(this.properties);
        }
        return null;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : ((IPAddress)this.address).hashCode());
        result = 31 * result + (this.autoConnect ? 1231 : 1237);
        result = 31 * result + (this.dhcp ? 1231 : 1237);
        result = 31 * result + (this.dnsServers == null ? 0 : this.dnsServers.hashCode());
        result = 31 * result + (this.domains == null ? 0 : this.domains.hashCode());
        result = 31 * result + (this.gateway == null ? 0 : ((IPAddress)this.gateway).hashCode());
        result = 31 * result + this.networkPrefixLength;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subnetMask == null ? 0 : ((IPAddress)this.subnetMask).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetConfigIP other = (NetConfigIP)obj;
        if (this.address == null ? other.address != null : !((IPAddress)this.address).equals(other.address)) {
            return false;
        }
        if (this.autoConnect != other.autoConnect) {
            return false;
        }
        if (this.dhcp != other.dhcp) {
            return false;
        }
        if (this.dnsServers == null ? other.dnsServers != null : !this.dnsServers.equals(other.dnsServers)) {
            return false;
        }
        if (this.domains == null ? other.domains != null : !this.domains.equals(other.domains)) {
            return false;
        }
        if (this.gateway == null ? other.gateway != null : !((IPAddress)this.gateway).equals(other.gateway)) {
            return false;
        }
        if (this.networkPrefixLength != other.networkPrefixLength) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.subnetMask == null ? other.subnetMask != null : !((IPAddress)this.subnetMask).equals(other.subnetMask));
    }

    @Override
    public boolean isValid() {
        if (this.dhcp) {
            return true;
        }
        try {
            ((IPAddress)this.address).getHostAddress();
        }
        catch (Exception exception) {
            return false;
        }
        for (IPAddress dns : this.dnsServers) {
            try {
                dns.getHostAddress();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NetConfigIP [status=");
        builder.append((Object)this.status);
        builder.append(", autoConnect=");
        builder.append(this.autoConnect);
        builder.append(", dhcp=");
        builder.append(this.dhcp);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", networkPrefixLength=");
        builder.append(this.networkPrefixLength);
        builder.append(", subnetMask=");
        builder.append(this.subnetMask);
        builder.append(", gateway=");
        builder.append(this.gateway);
        builder.append(", dnsServers=");
        builder.append(this.dnsServers);
        builder.append(", domains=");
        builder.append(this.domains);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append("]");
        return builder.toString();
    }

    private short calculateNetworkPrefixFromNetmask(String netmask) throws KuraException {
        if (netmask == null) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, "netmask is null");
        }
        int netmaskValue = 0;
        StringTokenizer st = new StringTokenizer(netmask, ".");
        int i = 24;
        while (i >= 0) {
            netmaskValue |= Integer.parseInt(st.nextToken()) << i;
            i -= 8;
        }
        boolean hitZero = false;
        int displayMask = Integer.MIN_VALUE;
        int count = 0;
        int c = 1;
        while (c <= 32) {
            if ((netmaskValue & displayMask) == 0) {
                hitZero = true;
            } else {
                if (hitZero) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR, "received invalid mask: " + netmask);
                }
                ++count;
            }
            netmaskValue <<= 1;
            ++c;
        }
        return (short)count;
    }

    private T calculateNetmaskFromNetworkPrefix(int networkPrefixLength) throws KuraException {
        int mask = ~((1 << 32 - networkPrefixLength) - 1);
        StringBuilder sb = new StringBuilder(15);
        int shift = 24;
        while (shift > 0) {
            sb.append(Integer.toString(mask >>> shift & 0xFF));
            sb.append('.');
            shift -= 8;
        }
        sb.append(Integer.toString(mask & 0xFF));
        try {
            IPAddress netmask = IPAddress.parseHostAddress(sb.toString());
            return (T)netmask;
        }
        catch (UnknownHostException e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
    }
}

