/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.inference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.ai.inference.ModelInfo;
import org.eclipse.kura.ai.inference.TensorDescriptor;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ModelInfoBuilder {
    private final String name;
    private Optional<String> platform;
    private Optional<String> version;
    private final Map<String, Object> parameters;
    private final List<TensorDescriptor> inputDescriptors;
    private final List<TensorDescriptor> outputDescriptors;

    ModelInfoBuilder(String name) {
        this.name = name;
        this.platform = Optional.empty();
        this.version = Optional.empty();
        this.parameters = new HashMap<String, Object>();
        this.inputDescriptors = new ArrayList<TensorDescriptor>();
        this.outputDescriptors = new ArrayList<TensorDescriptor>();
    }

    public static ModelInfoBuilder fromModelInfo(ModelInfo modelInfo) {
        ModelInfoBuilder builder = new ModelInfoBuilder(modelInfo.getName());
        builder.parameters.putAll(modelInfo.getParameters());
        builder.inputDescriptors.addAll(modelInfo.getInputs());
        builder.outputDescriptors.addAll(modelInfo.getOutputs());
        builder.platform = modelInfo.getPlatform();
        builder.version = modelInfo.getVersion();
        return builder;
    }

    public ModelInfoBuilder platform(String platform) {
        if (Objects.nonNull(platform) && !platform.isEmpty()) {
            this.platform = Optional.of(platform);
        }
        return this;
    }

    public ModelInfoBuilder version(String version) {
        if (Objects.nonNull(version) && !version.isEmpty()) {
            this.version = Optional.of(version);
        }
        return this;
    }

    public ModelInfoBuilder addParameter(String name, Object parameter) {
        this.parameters.put(name, parameter);
        return this;
    }

    public ModelInfoBuilder removeParameter(String name) {
        this.parameters.remove(name);
        return this;
    }

    public ModelInfoBuilder addInputDescriptor(TensorDescriptor inputDescriptor) {
        this.inputDescriptors.add(inputDescriptor);
        return this;
    }

    public ModelInfoBuilder addAllInputDescriptor(List<TensorDescriptor> inputDescriptors) {
        this.inputDescriptors.addAll(inputDescriptors);
        return this;
    }

    public ModelInfoBuilder removeInputDescriptor(TensorDescriptor inputDescriptor) {
        this.inputDescriptors.remove(inputDescriptor);
        return this;
    }

    public ModelInfoBuilder addOutputDescriptor(TensorDescriptor outputDescriptor) {
        this.outputDescriptors.add(outputDescriptor);
        return this;
    }

    public ModelInfoBuilder addAllOutputDescriptor(List<TensorDescriptor> outputDescriptors) {
        this.outputDescriptors.addAll(outputDescriptors);
        return this;
    }

    public ModelInfoBuilder removeOutputDescriptor(TensorDescriptor outputDescriptor) {
        this.outputDescriptors.remove(outputDescriptor);
        return this;
    }

    public ModelInfo build() {
        if (Objects.isNull(this.name) || this.name.isEmpty()) {
            throw new IllegalArgumentException("The name of the model cannot be empty or null");
        }
        if (this.inputDescriptors.isEmpty()) {
            throw new IllegalArgumentException("The input descriptors list cannot be empty");
        }
        if (this.outputDescriptors.isEmpty()) {
            throw new IllegalArgumentException("The output descriptors list cannot be empty");
        }
        return new ModelInfo(this.name, this.platform, this.version, this.parameters, this.inputDescriptors, this.outputDescriptors);
    }
}

