/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.broker.artemis.core;

import java.util.Collection;
import java.util.Set;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.eclipse.kura.broker.artemis.core.ServerConfiguration;
import org.eclipse.kura.broker.artemis.core.ServerRunner;
import org.eclipse.kura.broker.artemis.core.internal.ProtocolTracker;
import org.eclipse.kura.broker.artemis.core.internal.ProtocolTrackerListener;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManager {
    private static final Logger logger = LoggerFactory.getLogger(ServerManager.class);
    private final ServerConfiguration configuration;
    private final ProtocolTracker protocolTracker;
    private final ProtocolTrackerListener listener = new ProtocolTrackerListener(){

        @Override
        public void protocolsAdded(Set<String> protocols) {
            ServerManager.this.protocolsAdded(protocols);
        }

        @Override
        public void protocolsRemoved(Set<String> protocols) {
            ServerManager.this.protocolsRemoved(protocols);
        }
    };
    private ServerRunner runner;

    public ServerManager(ServerConfiguration configuration) {
        this.configuration = configuration;
        this.protocolTracker = new ProtocolTracker(FrameworkUtil.getBundle(ServerManager.class).getBundleContext(), this.listener);
    }

    public synchronized void start() throws Exception {
        this.protocolTracker.start();
        this.testStart();
    }

    public synchronized void stop() throws Exception {
        this.performStop();
        this.protocolTracker.stop();
    }

    protected synchronized void protocolsAdded(Set<String> protocols) {
        logger.info("Protocols added - {}", protocols);
        try {
            this.testStart();
        }
        catch (Exception e) {
            logger.warn("Failed to start", (Throwable)e);
        }
    }

    protected synchronized void protocolsRemoved(Set<String> protocols) {
        logger.info("Protocols removed - {}", protocols);
        try {
            this.testStop();
        }
        catch (Exception e) {
            logger.warn("Failed to stop", (Throwable)e);
        }
    }

    private void testStart() throws Exception {
        if (this.runner != null) {
            logger.debug("Already running");
            return;
        }
        Collection<ProtocolManagerFactory<?>> protocols = this.protocolTracker.resolveProtocols(this.configuration.getRequiredProtocols());
        if (protocols == null) {
            logger.warn("Unable to resolve protocols: {}", this.configuration.getRequiredProtocols());
            return;
        }
        this.runner = new ServerRunner(this.configuration, protocols);
        this.runner.start();
    }

    private void testStop() throws Exception {
        if (this.runner == null) {
            logger.debug("Not running anyway");
            return;
        }
        Collection<ProtocolManagerFactory<?>> protocols = this.protocolTracker.resolveProtocols(this.configuration.getRequiredProtocols());
        if (protocols != null) {
            return;
        }
        this.performStop();
    }

    private void performStop() throws Exception {
        if (this.runner == null) {
            logger.debug("Not running anyway");
            return;
        }
        this.runner.stop();
        this.runner = null;
    }
}

