/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnecton.raw.mqtt.util;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;

public class Property<T> {
    protected final String key;
    protected final T defaultValue;
    protected final Class<?> valueType;

    public Property(String key, T defaultValue) {
        this(key, defaultValue, defaultValue.getClass());
    }

    public Property(String key, Class<T> valueType) {
        this(key, null, valueType);
    }

    private Property(String key, T defaultValue, Class<?> valueType) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.valueType = valueType;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T get(Map<String, Object> properties) throws KuraException {
        try {
            return (T)properties.get(this.key);
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, null, new Object[]{null, "invalid property value for " + this.key, e});
        }
    }

    public T getOrDefault(Map<String, Object> properties) throws KuraException {
        Object value = properties.get(this.key);
        if (this.valueType.isInstance(value)) {
            return (T)value;
        }
        return this.defaultValue;
    }

    public <U> Property<U> map(Class<U> valueType, final Function<T, U> mapper) {
        final Property orig = this;
        return new Property<U>(this.key, this.defaultValue != null ? mapper.apply(this.defaultValue) : null, valueType){

            @Override
            public U get(Map<String, Object> properties) throws KuraException {
                return mapper.apply(orig.get(properties));
            }

            @Override
            public U getOrDefault(Map<String, Object> properties) {
                try {
                    return mapper.apply(orig.getOrDefault(properties));
                }
                catch (Exception exception) {
                    return this.defaultValue;
                }
            }
        };
    }

    public Property<T> validate(final Predicate<T> validator) {
        final Property orig = this;
        return new Property<T>(this.key, this.defaultValue, this.valueType){

            @Override
            public T get(Map<String, Object> properties) throws KuraException {
                Object value = orig.get(properties);
                if (!validator.test(value)) {
                    throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, null, new Object[]{null, "Validation failed for property " + this.key});
                }
                return value;
            }

            @Override
            public T getOrDefault(Map<String, Object> properties) throws KuraException {
                Object value = orig.getOrDefault(properties);
                if (!validator.test(value)) {
                    return this.defaultValue;
                }
                return value;
            }
        };
    }

    /* synthetic */ Property(String string, Object object, Class clazz, Property property) {
        this(string, object, clazz);
    }
}

