/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.configuration.api;

import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.rest.configuration.api.FailureHandler;
import org.eclipse.kura.rest.configuration.api.OcdDTO;
import org.eclipse.kura.rest.configuration.api.PropertyDTO;
import org.eclipse.kura.rest.configuration.api.Validable;

public class ComponentConfigurationDTO
implements Validable {
    private final String pid;
    private final OcdDTO definition;
    private final Map<String, PropertyDTO> properties;

    public ComponentConfigurationDTO(String pid, OcdDTO definition, Map<String, PropertyDTO> properties) {
        this.pid = pid;
        this.definition = definition;
        this.properties = properties;
    }

    public String getPid() {
        return this.pid;
    }

    public Optional<OCD> getDefinition() {
        return Optional.ofNullable(this.definition);
    }

    public Map<String, PropertyDTO> getProperties() {
        return this.properties;
    }

    @Override
    public void validate() {
        FailureHandler.requireParameter(this.pid, "pid");
        FailureHandler.requireParameter(this.properties, "properties");
        for (PropertyDTO param : this.properties.values()) {
            if (param == null) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)"propety values cannot be null");
            }
            param.validate();
        }
    }
}

