/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.tigris.mtoolkit.iagent.rpc.Externalizable;

public class Error
implements Externalizable {
    public static final int BUNDLE_UNINSTALLED_CODE = -10000;
    public static final int DEPLOYMENT_UNINSTALLED_CODE = -10001;
    private static final byte CODE_PRESENT = 2;
    private static final byte MESSAGE_PRESENT = 4;
    private static final byte DETAILS_PRESENT = 1;
    private int code;
    private String message;
    private String details;

    public Error(int code, String message, String details) {
        this.code = code;
        this.message = message;
        this.details = details;
    }

    public Error(int code, String message) {
        this(code, message, null);
    }

    public Error(int code) {
        this(code, null, null);
    }

    public Error() {
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    public void readObject(InputStream is) throws Exception {
        DataInputStream in = new DataInputStream(is);
        byte objectHeader = in.readByte();
        if ((objectHeader & 2) != 0) {
            this.code = in.readInt();
        }
        if ((objectHeader & 4) != 0) {
            this.message = in.readUTF();
        }
        if ((objectHeader & 1) != 0) {
            this.details = in.readUTF();
        }
    }

    public void writeObject(OutputStream os) throws Exception {
        DataOutputStream out = new DataOutputStream(os);
        int objectHeader = 0;
        if (this.code != 0) {
            objectHeader = (byte)(objectHeader | 2);
        }
        if (this.message != null && this.message.length() > 0) {
            objectHeader = (byte)(objectHeader | 4);
        }
        if (this.details != null && this.details.length() > 0) {
            objectHeader = (byte)(objectHeader | 1);
        }
        out.writeByte(objectHeader);
        if (this.code != 0) {
            out.writeInt(this.code);
        }
        if (this.message != null && this.message.length() > 0) {
            out.writeUTF(this.message);
        }
        if (this.details != null && this.details.length() > 0) {
            out.writeUTF(this.details);
        }
    }

    public String toString() {
        return "Error[code=" + this.code + ";message=" + this.message + ";details=" + this.details + "]";
    }
}

