/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99";
        final String metaValue_FR = "\u0e9d\u0ea3\u0eb1\u0ec8\u0e87";
        final String metaValue_JP = "\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99";
        final String metaValue_LA = "\u0ea5\u0eb2\u0ea7";
        final String metaValue_MN = "\u0ea1\u0ead\u0e87\u0ec2\u0e81\u0ec0\u0ea5\u0e8d";
        final String metaValue_WS = "\u0e8a\u0eb2\u0ea1\u0ebb\u0ea7";
        final String metaValue_TH = "\u0ec4\u0e97";
        final String metaValue_VN = "\u0eab\u0ea7\u0ebd\u0e94\u0e99\u0eb2\u0ea1";
        final String metaValue_CN = "\u0e88\u0eb5\u0e99";
        final String metaValue_TK = "\u0ec2\u0e95\u0ec0\u0e81\u0ec0\u0ea5\u0ebb\u0eb2";
        final String metaValue_TV = "\u0e95\u0eb9\u0ea7\u0eb2\u0ea5\u0eb9";
        final String metaValue_hy = "\u0ead\u0eb2\u0ec0\u0ea1\u0e99\u0ebd\u0e99";
        final String metaValue_cop = "\u0e84\u0ead\u0e9a\u0e95\u0eb4\u0e81";
        final String metaValue_ka = "\u0e88\u0ecd\u0e88\u0ebd\u0e99";
        final String metaValue_el = "\u0e81\u0ea3\u0eb5\u0e81";
        final String metaValue_he = "\u0eae\u0eb5\u0e9a\u0ea3\u0eb4\u0ea7";
        final String metaValue_kn = "\u0e84\u0eb1\u0e99\u0e99\u0eb2\u0e94\u0eb2";
        final String metaValue_la = "\u0ea5\u0eb2\u0e95\u0eb4\u0e99";
        final String metaValue_men = "\u0ec0\u0ea1\u0e99\u0ec0\u0e94";
        final String metaValue_my = "\u0ea1\u0ebd\u0e99\u0ea1\u0eb2";
        final String metaValue_nqo = "\u0ec0\u0ead\u0eb1\u0e99\u0ec2\u0e81";
        final String metaValue_si = "\u0eaa\u0eb4\u0e99\u0eab\u0eb2\u0ea5\u0eb2";
        final String metaValue_ta = "\u0e97\u0eb2\u0ea1\u0eb4\u0ea5";
        final String metaValue_tl = "\u0e95\u0eb2\u0e81\u0eb2\u0ea5\u0ead\u0e81";
        final String metaValue_bo = "\u0e97\u0eb4\u0ec0\u0e9a\u0e97\u0eb1\u0e99";
        final String metaValue_vai = "\u0ec4\u0ea7";
        final String metaValue_ssy = "\u0e8a\u0eb2\u0ec2\u0eae";
        final Object[][] data = new Object[][] {
            { "001", "\u0ec2\u0ea5\u0e81" },
            { "002", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2" },
            { "003", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2\u0ec0\u0edc\u0eb7\u0ead" },
            { "005", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2\u0ec3\u0e95\u0ec9" },
            { "009", "\u0ec2\u0ead\u0e8a\u0eb5\u0ead\u0eb2\u0e99\u0eb5" },
            { "011", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "013", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2\u0e81\u0eb2\u0e87" },
            { "014", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "015", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0ec0\u0edc\u0eb7\u0ead" },
            { "017", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e81\u0eb2\u0e87" },
            { "018", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e95\u0ead\u0e99\u0ec3\u0e95\u0ec9" },
            { "019", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea3\u0eb4\u0e81\u0eb2" },
            { "021", "\u0e9e\u0eb2\u0e81\u0ec0\u0edc\u0eb7\u0ead\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb5\u0e81\u0eb2" },
            { "029", "\u0e84\u0eb2\u0ea3\u0eb4\u0e9a\u0e9a\u0ebd\u0e99" },
            { "030", "\u0ead\u0eb2\u0e8a\u0eb5\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "034", "\u0ead\u0eb2\u0e8a\u0eb5\u0ec4\u0e95\u0ec9" },
            { "035", "\u0ead\u0eb2\u0e8a\u0eb5\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81\u0eaa\u0ec8\u0ebd\u0e87\u0ec4\u0e95\u0ec9" },
            { "039", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a\u0ec3\u0e95\u0ec9" },
            { "053", "\u0ec2\u0ead\u0e94\u0eaa\u0eb0\u0e95\u0eb2\u0ea5\u0eb5" },
            { "054", "\u0ec0\u0ea1\u0ea5\u0eb2\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "057", "\u0ec0\u0e82\u0e94\u0ec4\u0ea1\u0ec2\u0e84\u0ea3\u0ec0\u0e99\u0e8a\u0ebd\u0e99" },
            { "061", "\u0ec2\u0e9e\u0ea5\u0eb5\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "142", "\u0ead\u0eb2\u0e8a\u0eb5" },
            { "143", "\u0ead\u0eb2\u0e8a\u0eb5\u0e81\u0eb2\u0e87" },
            { "145", "\u0ead\u0eb2\u0e8a\u0eb5\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "150", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a" },
            { "151", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "154", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a\u0ec0\u0edc\u0eb7\u0ead" },
            { "155", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "202", "\u0e8a\u0eb1\u0e9a \u0e8a\u0eb2\u0eae\u0eb2\u0ea3\u0eb2\u0e99 \u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2" },
            { "419", "\u0ea5\u0eb2\u0e95\u0eb4\u0e99 \u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2" },
            { "AC", "\u0ec0\u0e81\u0eb2\u0eb0\u0ead\u0eb2\u0ec0\u0e8a\u0e99\u0e8a\u0eb1\u0e99" },
            { "AD", "\u0ead\u0eb1\u0e99\u0e94\u0ecd\u0ea3\u0eb2" },
            { "AE", "\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0ea3\u0eb1\u0e9a\u0ec0\u0ead\u0ea1\u0eb4\u0ec0\u0ea3\u0e94" },
            { "AF", "\u0ead\u0eb2\u0e9f\u0e81\u0eb2\u0e99\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "AG", "\u0ec1\u0ead\u0e99\u0e97\u0eb4\u0e81\u0ebb\u0ea7 \u0ec1\u0ea5\u0eb0 \u0e9a\u0eb2\u0e9a\u0eb9\u0e94\u0eb2" },
            { "AI", "\u0ec1\u0ead\u0e99\u0e81\u0eb8\u0e8d\u0ea5\u0eb2" },
            { "AL", "\u0ec1\u0ead\u0ea7\u0ec0\u0e9a\u0ec0\u0e99\u0e8d" },
            { "AM", "\u0ead\u0eb2\u0ec0\u0ea1\u0ec0\u0e99\u0e8d" },
            { "AO", "\u0ec1\u0ead\u0e87\u0ec2\u0e81\u0ea5\u0eb2" },
            { "AQ", "\u0ec1\u0ead\u0e99\u0e95\u0eb2\u0e94\u0e95\u0eb4\u0e81\u0eb2" },
            { "AR", "\u0ead\u0eb2\u0ec0\u0e88\u0e99\u0e97\u0eb4\u0e99\u0eb2" },
            { "AS", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea3\u0eb4\u0e81\u0eb2 \u0e8a\u0eb2\u0ea1\u0ebb\u0ea7" },
            { "AT", "\u0ead\u0ead\u0eaa\u0ec0\u0e97\u0ea3\u0e8d" },
            { "AU", "\u0ead\u0ead\u0eaa\u0ec0\u0e95\u0ea3\u0ec0\u0ea5\u0e8d" },
            { "AW", "\u0ead\u0eb2\u0ea3\u0eb9\u0e9a\u0eb2" },
            { "AX", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0ead\u0ea5\u0eb1\u0e99" },
            { "AZ", "\u0ead\u0eb2\u0ec0\u0e8a\u0eb5\u0ec4\u0e9a\u0e88\u0eb2\u0e99" },
            { "BA", "\u0e9a\u0ead\u0e94\u0eaa\u0eb0\u0ec0\u0e99\u0e8d \u0ec1\u0ea5\u0eb0 \u0ec1\u0eae\u0eaa\u0ec2\u0e81\u0ea7\u0eb5\u0e99\u0eb2" },
            { "BB", "\u0e9a\u0eb2\u0e9a\u0eb2\u0ec2\u0e94\u0eaa" },
            { "BD", "\u0e9a\u0eb1\u0e87\u0e81\u0eb0\u0ea5\u0eb2\u0ec0\u0e97\u0e94" },
            { "BE", "\u0ec0\u0e9a\u0ea7\u0ea2\u0ebd\u0ea1" },
            { "BF", "\u0ec0\u0e9a\u0eb5\u0e81\u0eb4\u0e99\u0eb2 \u0e9f\u0eb2\u0ec2\u0e8a" },
            { "BG", "\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ec0\u0ea3\u0e8d" },
            { "BH", "\u0e9a\u0eb2\u0ec0\u0ea3\u0e99" },
            { "BI", "\u0e9a\u0eb9\u0ea3\u0eb8\u0e99\u0e94\u0eb4" },
            { "BJ", "\u0ec0\u0e9a\u0e99\u0eb4\u0e99" },
            { "BL", "\u0ec0\u0e8a\u0e99 \u0e9a\u0eb2\u0ec0\u0e97\u0ec0\u0ea5\u0ea1\u0eb5" },
            { "BM", "\u0ec0\u0e9a\u0eb5\u0ea1\u0eb4\u0ea7\u0e94\u0eb2" },
            { "BN", "\u0e9a\u0ea3\u0eb9\u0ec4\u0e99" },
            { "BO", "\u0ec2\u0e9a\u0ea5\u0eb4\u0ec0\u0ea7\u0e8d" },
            { "BQ", "\u0e84\u0eb2\u0ea3\u0eb4\u0e9a\u0e9a\u0ebd\u0e99 \u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99" },
            { "BR", "\u0e9a\u0ea3\u0eb2\u0e8a\u0eb4\u0ea7" },
            { "BS", "\u0e9a\u0eb2\u0eae\u0eb2\u0ea1\u0eb2\u0eaa" },
            { "BT", "\u0e9e\u0eb9\u0e96\u0eb2\u0e99" },
            { "BV", "\u0ec0\u0e81\u0eb2\u0eb0\u0e9a\u0eb9\u0ec0\u0ea7\u0e94" },
            { "BW", "\u0e9a\u0ead\u0e94\u0eaa\u0eb0\u0ea7\u0eb2\u0e99\u0eb2" },
            { "BY", "\u0ec0\u0e9a\u0ea5\u0eb2\u0ea3\u0eb8\u0eaa" },
            { "BZ", "\u0ec0\u0e9a\u0ea5\u0eb5\u0e8a" },
            { "CA", "\u0ec1\u0e84\u0e99\u0eb2\u0e94\u0eb2" },
            { "CC", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0e81\u0ec2\u0e81\u0eaa" },
            { "CD", "\u0e84\u0ead\u0e87\u0ec2\u0e81 - \u0e84\u0eb4\u0e99\u0e8a\u0eb2\u0e8a\u0eb2" },
            { "CF", "\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e81\u0eb2\u0e87" },
            { "CG", "\u0e84\u0ead\u0e87\u0ec2\u0e81 - \u0e9a\u0ea3\u0eb2\u0e8a\u0eb2\u0ea7\u0eb4\u0ea7" },
            { "CH", "\u0eaa\u0eb0\u0ea7\u0eb4\u0e94\u0ec0\u0e8a\u0eb5\u0ec1\u0ea5\u0e99" },
            { "CI", "\u0ec2\u0e84\u0e95\u0eb5 \u0ea7\u0ebb\u0ea7" },
            { "CK", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0eb8\u0e81" },
            { "CL", "\u0e8a\u0eb4\u0ea5\u0eb5" },
            { "CM", "\u0e84\u0eb2\u0ec0\u0ea1\u0ea3\u0eb9\u0e99" },
            { "CN", metaValue_CN },
            { "CO", "\u0ec2\u0e84\u0ea5\u0ebb\u0ea1\u0ec0\u0e9a\u0e8d" },
            { "CP", "\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0ea5\u0eb4\u0e9a\u0ec0\u0e9b\u0eb5\u0e95\u0eb1\u0e99" },
            { "CR", "\u0ec2\u0e84\u0eaa\u0e95\u0eb2 \u0ea3\u0eb4\u0e81\u0eb2" },
            { "CU", "\u0e84\u0eb4\u0ea7\u0e9a\u0eb2" },
            { "CV", "\u0ec0\u0e84\u0e9a \u0ec0\u0ea7\u0eb5\u0e94" },
            { "CW", "\u0e84\u0eb9\u0ea3\u0eb2\u0e8a\u0eb2\u0ea7" },
            { "CX", "\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0ea3\u0eb4\u0eaa\u0ea1\u0eb2\u0e94" },
            { "CY", "\u0ec4\u0e8a\u0e9b\u0ea3\u0eb1\u0eaa" },
            { "CZ", "\u0ec0\u0e8a\u0eb1\u0e81\u0ec0\u0e8a\u0e8d" },
            { "DE", metaValue_DE },
            { "DG", "\u0e94\u0eb4\u0ec0\u0ead\u0ec2\u0e81 \u0e81\u0eb2\u0ec0\u0e8a\u0e8d" },
            { "DJ", "\u0e88\u0eb4\u0e9a\u0eb9\u0e95\u0eb4" },
            { "DK", "\u0ec0\u0e94\u0e99\u0ea1\u0eb2\u0e81" },
            { "DM", "\u0ec2\u0e94\u0ea1\u0eb5\u0e99\u0eb4\u0e84\u0eb2" },
            { "DO", "\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94 \u0ec2\u0e94\u0ea1\u0eb4\u0e99\u0eb4\u0e81\u0eb1\u0e99" },
            { "DZ", "\u0ead\u0eb1\u0ea5\u0e88\u0eb4\u0ec0\u0ea3\u0e8d" },
            { "EA", "\u0ec0\u0e8a\u0ea7\u0e95\u0eb2 & \u0ec0\u0ea1\u0ea5\u0eb4\u0e99\u0ea5\u0eb2" },
            { "EC", "\u0ec0\u0ead\u0e81\u0ea7\u0eb2\u0e94\u0ecd" },
            { "EE", "\u0ec0\u0ead\u0eaa\u0ec2\u0e95\u0ec0\u0e99\u0e8d" },
            { "EG", "\u0ead\u0eb5\u0ea2\u0eb4\u0e9a" },
            { "EH", "\u0e8a\u0eb2\u0eae\u0eb2\u0ea3\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "ER", "\u0ec0\u0ead\u0ea3\u0eb4\u0ec0\u0e97\u0ea3\u0e8d" },
            { "ES", "\u0eaa\u0eb0\u0ec0\u0e9b\u0e99" },
            { "ET", "\u0ead\u0eb5\u0e97\u0eb4\u0ec2\u0ead\u0ec0\u0e9b\u0e8d" },
            { "EU", "\u0eaa\u0eb0\u0eab\u0eb0\u0e9e\u0eb2\u0e9a\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a" },
            { "EZ", "\u0ec0\u0e82\u0e94\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a" },
            { "FI", "\u0e9f\u0eb4\u0e99\u0ec1\u0ea5\u0e99" },
            { "FJ", "\u0e9f\u0eb4\u0e88\u0eb4" },
            { "FK", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e9f\u0ead\u0e81\u0ec1\u0ea5\u0e99" },
            { "FM", "\u0ec4\u0ea1\u0ec2\u0e84\u0ea3\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "FO", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec1\u0e9f\u0ec2\u0ea3" },
            { "FR", metaValue_FR },
            { "GA", "\u0e81\u0eb2\u0e9a\u0ead\u0e99" },
            { "GB", "\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb2\u0e94\u0e8a\u0eb0\u0ead\u0eb0\u0e99\u0eb2\u0e88\u0eb1\u0e81" },
            { "GD", "\u0ec0\u0e81\u0ea3\u0ec0\u0e99\u0e94\u0eb2" },
            { "GE", "\u0e88\u0ecd\u0ec0\u0e88\u0e8d" },
            { "GF", "\u0ec0\u0e9f\u0ea3\u0e99\u0e8a\u0ecc \u0e81\u0eb8\u0e8d\u0ead\u0eb2\u0e99\u0eb2" },
            { "GG", "\u0ec0\u0e81\u0eb5\u0e99\u0e8a\u0eb5" },
            { "GH", "\u0e81\u0eb2\u0e99\u0eb2" },
            { "GI", "\u0e88\u0eb4\u0e9a\u0e9a\u0ea3\u0ead\u0e99\u0e97\u0eb2" },
            { "GL", "\u0e81\u0ea3\u0eb5\u0e99\u0ec1\u0ea5\u0e99" },
            { "GM", "\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ec1\u0e81\u0ea1\u0ec0\u0e9a\u0e8d" },
            { "GN", "\u0e81\u0eb4\u0e99\u0eb5" },
            { "GP", "\u0e81\u0ebb\u0ea7\u0e94\u0eb2\u0ea5\u0eb9\u0e9a" },
            { "GQ", "\u0ec0\u0ead\u0e84\u0ebb\u0ea7\u0ec2\u0e97\u0ea3\u0ebd\u0ea7 \u0e81\u0eb5\u0e99\u0eb5" },
            { "GR", "\u0e81\u0ea3\u0eb5\u0e8a" },
            { "GS", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0e88\u0ecd\u0ec0\u0e88\u0e8d\u0e95\u0ead\u0e99\u0ec3\u0e95\u0ec9 \u0ec1\u0ea5\u0eb0 \u0ec1\u0e8a\u0e99\u0ea7\u0eb4\u0e94\u0e95\u0ead\u0e99\u0ec3\u0e95\u0ec9" },
            { "GT", "\u0e81\u0ebb\u0ea7\u0ec0\u0e97\u0ea1\u0eb2\u0ea5\u0eb2" },
            { "GU", "\u0e81\u0ea7\u0eb2\u0ea1" },
            { "GW", "\u0e81\u0eb4\u0e99\u0eb5-\u0e9a\u0eb4\u0eaa\u0ec0\u0e8a\u0ebb\u0eb2" },
            { "GY", "\u0e81\u0eb2\u0e8d\u0ea2\u0eb2\u0e99\u0eb2" },
            { "HK", "\u0eae\u0ebb\u0e87\u0e81\u0ebb\u0e87 \u0ec0\u0e82\u0e94\u0e9b\u0ebb\u0e81\u0e84\u0ead\u0e87\u0e9e\u0eb4\u0ec0\u0eaa\u0e94 \u0e88\u0eb5\u0e99" },
            { "HM", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec0\u0eae\u0eb5\u0e94 & \u0ec1\u0ea1\u0eb1\u0e81\u0ec2\u0e94\u0e99\u0ead\u0ea5" },
            { "HN", "\u0eae\u0ead\u0e99\u0e94\u0eb9\u0ea3\u0eb1\u0eaa" },
            { "HR", "\u0ec2\u0e84\u0ea3\u0ec0\u0ead\u0ec0\u0e97\u0e8d" },
            { "HT", "\u0ec4\u0eae\u0e95\u0eb4" },
            { "HU", "\u0eae\u0eb1\u0e87\u0e81\u0eb2\u0ea3\u0eb5" },
            { "IC", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0eb2\u0e99\u0eb2\u0ea3\u0eb5" },
            { "ID", "\u0ead\u0eb4\u0e99\u0ec2\u0e94\u0ec0\u0e99\u0ec0\u0e8a\u0e8d" },
            { "IE", "\u0ec4\u0ead\u0ec1\u0ea5\u0e99" },
            { "IL", "\u0ead\u0eb4\u0eaa\u0ea3\u0eb2\u0ec0\u0ead\u0ea7" },
            { "IM", "\u0ec0\u0ead\u0ea7 \u0ead\u0ead\u0e9a \u0ec1\u0ea1\u0e99" },
            { "IN", "\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d" },
            { "IO", "\u0ec0\u0e82\u0e94\u0ec1\u0e94\u0e99\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0ec3\u0e99\u0ea1\u0eb0\u0eab\u0eb2\u0eaa\u0eb0\u0ea1\u0eb8\u0e94\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d" },
            { "IQ", "\u0ead\u0eb5\u0ea3\u0eb1\u0e81" },
            { "IR", "\u0ead\u0eb5\u0ea3\u0eb2\u0e99" },
            { "IS", "\u0ec4\u0ead\u0eaa\u0ec1\u0ea5\u0e99" },
            { "IT", "\u0ead\u0eb4\u0e95\u0eb2\u0ea5\u0eb5" },
            { "JE", "\u0ec0\u0e88\u0eb5\u0e8a\u0eb5" },
            { "JM", "\u0e88\u0eb2\u0ec4\u0ea1\u0e84\u0eb2" },
            { "JO", "\u0e88\u0ecd\u0ec1\u0e94\u0e99" },
            { "JP", metaValue_JP },
            { "KE", "\u0ec0\u0e84\u0e99\u0ea2\u0eb2" },
            { "KG", "\u0e84\u0ebd\u0e81\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "KH", "\u0e81\u0eb3\u0e9b\u0eb9\u0ec0\u0e88\u0e8d" },
            { "KI", "\u0e84\u0eb4\u0ea3\u0eb4\u0e9a\u0eb2\u0e97\u0eb4" },
            { "KM", "\u0ec2\u0e84\u0ec2\u0ea1\u0ec2\u0ea3\u0eaa" },
            { "KN", "\u0ec0\u0e8a\u0e99 \u0e84\u0eb4\u0e94 \u0ec1\u0ea5\u0eb0 \u0ec0\u0e99\u0ea7\u0eb4\u0eaa" },
            { "KP", "\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5\u0ec0\u0edc\u0eb7\u0ead" },
            { "KR", "\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5\u0ec3\u0e95\u0ec9" },
            { "KW", "\u0e81\u0eb9\u0ec0\u0ea7\u0e94" },
            { "KY", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0e84\u0ec1\u0ea1\u0e99" },
            { "KZ", "\u0e84\u0eb2\u0e8a\u0eb1\u0e81\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "LA", metaValue_LA },
            { "LB", "\u0ec0\u0ea5\u0e9a\u0eb2\u0e99\u0ead\u0e99" },
            { "LC", "\u0ec0\u0e8a\u0e99 \u0ea5\u0eb9\u0ec0\u0e8a\u0e8d" },
            { "LI", "\u0ea5\u0eb4\u0e94\u0ec0\u0e97\u0e99\u0eaa\u0eb0\u0e95\u0eb2\u0e8d" },
            { "LK", "\u0eaa\u0eb5\u0ea5\u0eb1\u0e87\u0e81\u0eb2" },
            { "LR", "\u0ea5\u0eb4\u0ec0\u0e9a\u0eb5\u0ec0\u0ea3\u0e8d" },
            { "LS", "\u0ec0\u0ea5\u0ec2\u0e8a\u0ec2\u0e97" },
            { "LT", "\u0ea5\u0eb4\u0e97\u0ebb\u0ea7\u0ec0\u0e99\u0e8d" },
            { "LU", "\u0ea5\u0eb8\u0e81\u0ec1\u0e8a\u0ea1\u0ec0\u0e9a\u0eb5\u0e81" },
            { "LV", "\u0ea5\u0eb1\u0e94\u0ec0\u0ea7\u0e8d" },
            { "LY", "\u0ea5\u0eb4\u0ec0\u0e9a\u0e8d" },
            { "MA", "\u0ec2\u0ea1\u0ea3\u0eb1\u0ead\u0e81\u0ec2\u0e84" },
            { "MC", "\u0ec2\u0ea1\u0e99\u0eb2\u0ec2\u0e84" },
            { "MD", "\u0ec2\u0ea1\u0e99\u0ec2\u0e94\u0ea7\u0eb2" },
            { "ME", "\u0ea1\u0ead\u0e99\u0ec0\u0e95\u0ec0\u0e99\u0ec2\u0e81\u0ea3" },
            { "MF", "\u0ec0\u0e8a\u0e99 \u0ea1\u0eb2\u0e97\u0eb4\u0e99" },
            { "MG", "\u0ea1\u0eb2\u0e94\u0eb2\u0e81\u0eb2\u0eaa\u0eb0\u0e81\u0eb2" },
            { "MH", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ea1\u0eb2\u0ec1\u0e8a\u0ea7" },
            { "MK", "\u0ec1\u0ea1\u0e8a\u0eb4\u0ec2\u0e94\u0ec0\u0e99\u0e8d\u0ec0\u0edc\u0eb7\u0ead" },
            { "ML", "\u0ea1\u0eb2\u0ea5\u0eb5" },
            { "MM", "\u0ea1\u0ebd\u0e99\u0ea1\u0eb2 (\u0ec0\u0e9a\u0eb5\u0ea1\u0eb2)" },
            { "MN", metaValue_MN },
            { "MO", "\u0ea1\u0eb2\u0e81\u0eb2\u0ea7 \u0ec0\u0e82\u0e94\u0e9b\u0ebb\u0e81\u0e84\u0ead\u0e87\u0e9e\u0eb4\u0ec0\u0eaa\u0e94 \u0e88\u0eb5\u0e99" },
            { "MP", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ea1\u0eb2\u0ec0\u0ea3\u0e8d\u0e99\u0eb2\u0e95\u0ead\u0e99\u0ec0\u0edc\u0eb7\u0ead" },
            { "MQ", "\u0ea1\u0eb2\u0e95\u0eb4\u0e99\u0eb5\u0e81" },
            { "MR", "\u0ea1\u0ebb\u0ea7\u0ea3\u0eb4\u0ec0\u0e97\u0ec0\u0e99\u0e8d" },
            { "MS", "\u0ea1\u0ead\u0e99\u0ec0\u0e8a\u0eb5\u0ea3\u0eb2\u0e94" },
            { "MT", "\u0ea1\u0ead\u0e99\u0e97\u0eb2" },
            { "MU", "\u0ea1\u0ebb\u0ea7\u0ea3\u0eb4\u0e8a\u0ebd\u0eaa" },
            { "MV", "\u0ea1\u0eb1\u0e99\u0e94\u0eb4\u0e9f" },
            { "MW", "\u0ea1\u0eb2\u0ea5\u0eb2\u0ea7\u0eb5" },
            { "MX", "\u0ec0\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0ec2\u0e81" },
            { "MY", "\u0ea1\u0eb2\u0ec0\u0ea5\u0ec0\u0e8a\u0e8d" },
            { "MZ", "\u0ec2\u0ea1\u0ec1\u0e8a\u0ea1\u0e9a\u0eb4\u0e81" },
            { "NA", "\u0e99\u0eb2\u0ea1\u0eb5\u0ec0\u0e9a\u0e8d" },
            { "NC", "\u0e99\u0eb4\u0ea7 \u0e84\u0eb2\u0ec0\u0ea5\u0ec2\u0e94\u0ec0\u0e99\u0e8d" },
            { "NE", "\u0e99\u0eb4\u0ec0\u0e88\u0eb5" },
            { "NF", "\u0ec0\u0e81\u0eb2\u0eb0\u0e99\u0ecd\u0ec2\u0e9f\u0e81" },
            { "NG", "\u0ec4\u0e99\u0e88\u0eb5\u0ec0\u0ea3\u0e8d" },
            { "NI", "\u0e99\u0eb4\u0e81\u0e84\u0eb2\u0ea3\u0eb2\u0e81\u0ebb\u0ea7" },
            { "NL", "\u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99" },
            { "NO", "\u0e99\u0ecd\u0ec0\u0ea7" },
            { "NP", "\u0ec0\u0e99\u0e9b\u0eb2\u0e99" },
            { "NR", "\u0e99\u0eb2\u0ead\u0eb9\u0ea3\u0eb9" },
            { "NU", "\u0e99\u0eb5\u0ead\u0eb9\u0ec0\u0ead" },
            { "NZ", "\u0e99\u0eb4\u0ea7\u0e8a\u0eb5\u0ec1\u0ea5\u0e99" },
            { "OM", "\u0ec2\u0ead\u0ea1\u0eb2\u0e99" },
            { "PA", "\u0e9e\u0eb2\u0e99\u0eb2\u0ea1\u0eb2" },
            { "PE", "\u0ec0\u0e9b\u0ea3\u0eb9" },
            { "PF", "\u0ec0\u0e9f\u0ea3\u0e99\u0e8a\u0ecc \u0ec2\u0e9e\u0ea5\u0eb4\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "PG", "\u0e9b\u0eb2\u0e9b\u0ebb\u0ea7\u0e99\u0eb4\u0ea7\u0e81\u0eb5\u0e99\u0eb5" },
            { "PH", "\u0e9f\u0eb4\u0ea5\u0eb4\u0e9a\u0e9b\u0eb4\u0e99" },
            { "PK", "\u0e9b\u0eb2\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "PL", "\u0ec2\u0e9b\u0ec1\u0ea5\u0e99" },
            { "PM", "\u0ec0\u0e8a\u0e99 \u0e9b\u0eb5\u0ec1\u0ead \u0ea1\u0eb4\u0ec0\u0e81\u0ea7\u0ea5\u0ead\u0e99" },
            { "PN", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e9e\u0eb4\u0e94\u0ec1\u0e84\u0e99" },
            { "PR", "\u0ec0\u0e9e\u0eb7\u0ead\u0ec2\u0e95 \u0ea3\u0eb4\u0ec2\u0e81" },
            { "PS", "\u0e94\u0eb4\u0e99\u0ec1\u0e94\u0e99\u0e9b\u0eb2\u0ec0\u0ea5\u0e94\u0eaa\u0eb0\u0e95\u0eb4\u0e99" },
            { "PT", "\u0e9e\u0ead\u0ea5\u0e97\u0eb9\u0ec2\u0e81" },
            { "PW", "\u0e9b\u0eb2\u0ea5\u0eb2\u0ea7" },
            { "PY", "\u0e9e\u0eb2\u0ea3\u0eb2\u0e81\u0ea7\u0e8d" },
            { "QA", "\u0e81\u0eb2\u0e95\u0eb2" },
            { "QO", "\u0ec0\u0e82\u0e94\u0eab\u0ec8\u0eb2\u0e87\u0ec4\u0e81\u0ec2\u0ead\u0e8a\u0eb5\u0ec0\u0e99\u0e8d" },
            { "RE", "\u0ec0\u0ea3\u0ead\u0eb9\u0e99\u0eb4\u0e8d\u0ebb\u0e87" },
            { "RO", "\u0ec2\u0ea3\u0ec1\u0ea1\u0ec0\u0e99\u0e8d" },
            { "RS", "\u0ec0\u0e8a\u0eb5\u0ec0\u0e9a\u0e8d" },
            { "RU", "\u0ea3\u0eb1\u0e94\u0ec0\u0e8a\u0e8d" },
            { "RW", "\u0ea3\u0ea7\u0eb1\u0e99\u0e94\u0eb2" },
            { "SA", "\u0e8a\u0eb2\u0ead\u0eb8\u0e94\u0eb4 \u0ead\u0eb2\u0ea3\u0eb2\u0ec0\u0e9a\u0e8d" },
            { "SB", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0e8a\u0ec2\u0ea5\u0ea1\u0ead\u0e99" },
            { "SC", "\u0ec0\u0e8a\u0ec0\u0e8a\u0ea7\u0ec0\u0ea5\u0eaa" },
            { "SD", "\u0e8a\u0eb9\u0e94\u0eb2\u0e99" },
            { "SE", "\u0eaa\u0eb0\u0ea7\u0eb5\u0ec0\u0e94\u0eb1\u0e99" },
            { "SG", "\u0eaa\u0eb4\u0e87\u0e81\u0eb0\u0ec2\u0e9b" },
            { "SH", "\u0ec0\u0e8a\u0e99 \u0ec0\u0eae\u0ec0\u0ea5\u0e99\u0eb2" },
            { "SI", "\u0eaa\u0eb0\u0ec2\u0ea5\u0ec0\u0ea7\u0ec0\u0e99\u0e8d" },
            { "SJ", "\u0eaa\u0eb0\u0ea7\u0eb2\u0e9a\u0eb2 \u0ec1\u0ea5\u0eb0 \u0ec1\u0ea2\u0e99 \u0ea1\u0eb2\u0ec0\u0ea2\u0e99" },
            { "SK", "\u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb2\u0ec0\u0e81\u0e8d" },
            { "SL", "\u0ec0\u0e8a\u0e8d\u0ea3\u0eb2 \u0ea5\u0eb5\u0ec2\u0ead\u0e99" },
            { "SM", "\u0ec1\u0e8a\u0e99 \u0ea1\u0eb2\u0ea3\u0eb4\u0ec2\u0e99" },
            { "SN", "\u0ec0\u0e8a\u0e99\u0eb5\u0ec2\u0e81\u0ea5" },
            { "SO", "\u0ec2\u0e8a\u0ea1\u0eb2\u0ec0\u0ea5\u0e8d" },
            { "SR", "\u0e8a\u0eb9\u0ea3\u0eb4\u0e99\u0eb2\u0ea1" },
            { "SS", "\u0e8a\u0eb9\u0e94\u0eb2\u0e99\u0ec3\u0e95\u0ec9" },
            { "ST", "\u0ec0\u0e8a\u0ebb\u0eb2\u0e97\u0eb9\u0ec0\u0ea1 \u0ec1\u0ea5\u0eb0 \u0e9e\u0ea3\u0eb4\u0e99\u0e8a\u0eb4\u0e9a" },
            { "SV", "\u0ec0\u0ead\u0ea7 \u0e8a\u0ecd\u0ea7\u0eb2\u0e94\u0ecd" },
            { "SX", "\u0e8a\u0eb4\u0e99 \u0ea1\u0eb2\u0ec0\u0e97\u0eb1\u0e99" },
            { "SY", "\u0e8a\u0eb5\u0ec0\u0ea3\u0e8d" },
            { "SZ", "\u200b\u0ec0\u0ead\u200b\u0eaa\u0eb0\u200b\u0ea7\u0eb2\u200b\u0e95\u0eb4\u200b\u0e99\u0eb5" },
            { "TA", "\u0e97\u0ea3\u0eb4\u0eaa\u0e95\u0eb1\u0e99 \u0e94\u0eb2 \u0e81\u0eb1\u0e99\u0eae\u0eb2" },
            { "TC", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0e97\u0eb5\u0e81 \u0ec1\u0ea5\u0eb0 \u0ec4\u0e84\u0ec2\u0e84\u0eaa" },
            { "TD", "\u0e8a\u0eb2\u0e94" },
            { "TF", "\u0ec0\u0e82\u0e94\u0ec1\u0e94\u0e99\u0e97\u0eb2\u0e87\u0ec3\u0e95\u0ec9\u0e82\u0ead\u0e9d\u0eae\u0eb1\u0ec8\u0e87" },
            { "TG", "\u0ec2\u0e95\u0ec2\u0e81" },
            { "TH", metaValue_TH },
            { "TJ", "\u0e97\u0eb2\u0e88\u0eb4\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "TK", metaValue_TK },
            { "TL", "\u0e97\u0eb4\u0ea1\u0ecd-\u0ec0\u0ea5\u0eaa\u0ec0\u0e95" },
            { "TM", "\u0ec0\u0e97\u0eb5\u0e81\u0ec0\u0ea1\u0e99\u0eb4\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "TN", "\u0e95\u0eb9\u0e99\u0eb4\u0ec0\u0e8a\u0e8d" },
            { "TO", "\u0e97\u0ead\u0e87\u0e81\u0eb2" },
            { "TR", "\u0ec0\u0e97\u0eb5\u0e84\u0eb5" },
            { "TT", "\u0e97\u0ea3\u0eb4\u0e99\u0eb4\u0ec1\u0e94\u0e94 \u0ec1\u0ea5\u0eb0 \u0ec2\u0e97\u0ec1\u0e9a\u0ec2\u0e81" },
            { "TV", metaValue_TV },
            { "TW", "\u0ec4\u0e95\u0ec9\u0eab\u0ea7\u0eb1\u0e99" },
            { "TZ", "\u0e97\u0eb2\u0e99\u0e8a\u0eb2\u0ec0\u0e99\u0e8d" },
            { "UA", "\u0ea2\u0eb9\u0ec0\u0e84\u0ea3\u0e99" },
            { "UG", "\u0ead\u0eb9\u0e81\u0eb2\u0e99\u0e94\u0eb2" },
            { "UM", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0eae\u0ead\u0e9a\u0e99\u0ead\u0e81\u0e82\u0ead\u0e87\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94\u0eaf" },
            { "UN", "\u0eaa\u0eb0\u0eab\u0eb0\u0e9b\u0eb0\u0e8a\u0eb2\u0e8a\u0eb2\u0e94" },
            { "US", "\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94" },
            { "UY", "\u0ead\u0eb9\u0ea3\u0eb8\u0e81\u0ea7\u0e8d" },
            { "UZ", "\u0ead\u0eb8\u0eaa\u0ec0\u0e9a\u0e81\u0eb4\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "VA", "\u0e99\u0eb0\u0e84\u0ead\u0e99 \u0ea7\u0eb2\u0e95\u0eb4\u0e81\u0eb1\u0e99" },
            { "VC", "\u0ec0\u0e8a\u0e99 \u0ea7\u0eb4\u0e99\u0ec0\u0e8a\u0e99 \u0ec1\u0ea5\u0eb0 \u0ec0\u0e81\u0ea3\u0ec0\u0e99\u0e94\u0eb4\u0e99" },
            { "VE", "\u0ec0\u0ea7\u0ec0\u0e99\u0e8a\u0eb9\u0ec0\u0ead\u0ea5\u0eb2" },
            { "VG", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0ea7\u0eb5\u0e88\u0eb4\u0e99\u0e82\u0ead\u0e87\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94" },
            { "VI", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0ea7\u0eb5\u0e88\u0eb4\u0e99 \u0e82\u0ead\u0e87\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94" },
            { "VN", metaValue_VN },
            { "VU", "\u0ea7\u0eb2\u0e99\u0ebb\u0ea7\u0e95\u0eb9" },
            { "WF", "\u0ea7\u0eb2\u0ea5\u0ea5\u0eb4\u0eaa \u0ec1\u0ea5\u0eb0 \u0e9f\u0eb9\u0e95\u0eb9\u0e99\u0eb2" },
            { "WS", metaValue_WS },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "\u0ec2\u0e84\u0ec2\u0e8a\u0ec2\u0ea7" },
            { "YE", "\u0ec0\u0ea2\u0ec0\u0ea1\u0e99" },
            { "YT", "\u0ea1\u0eb2\u0ea2\u0eb1\u0ead\u0e94" },
            { "ZA", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0ec3\u0e95\u0ec9" },
            { "ZM", "\u0ec1\u0e8a\u0ea1\u0ec0\u0e9a\u0e8d" },
            { "ZW", "\u0e8a\u0eb4\u0ea1\u0e9a\u0eb1\u0e9a\u0ec0\u0ea7" },
            { "ZZ", "\u0e82\u0ebb\u0e87\u0ec0\u0e82\u0e94\u0e97\u0eb5\u0ec8\u0e9a\u0ecd\u0ec8\u0eae\u0eb9\u0ec9\u0e88\u0eb1\u0e81" },
            { "aa", "\u0ead\u0eb0\u0e9f\u0eb2" },
            { "ab", "\u0ec1\u0ead\u0e9a\u0e84\u0eb2\u0e8a\u0ebd\u0e99" },
            { "ae", "\u0ead\u0eb2\u0ec0\u0ea7\u0eb1\u0eaa\u0ec1\u0e95\u0e99" },
            { "af", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e99" },
            { "ak", "\u0ead\u0eb2\u0e81\u0eb2\u0e99" },
            { "am", "\u0ead\u0eb3\u0eae\u0eb2\u0ea3\u0eb4\u0e81" },
            { "an", "\u0ead\u0eb2\u0ea3\u0eb2\u0ec2\u0e81\u0ec0\u0e99\u0eb1\u0e94" },
            { "ar", "\u0ead\u0eb2\u0ea3\u0eb1\u0e9a" },
            { "as", "\u0ead\u0eb1\u0eaa\u0e8a\u0eb2\u0ea1\u0eb5\u0eaa" },
            { "av", "\u0ead\u0eb2\u0ea7\u0eb2\u0ea3\u0eb4\u0e81" },
            { "ay", "\u0ead\u0eb2\u0e8d\u0ea1\u0eb2\u0ea5\u0eb2" },
            { "az", "\u0ead\u0eb2\u0ec0\u0e8a\u0eb5\u0ec4\u0e9a\u0e88\u0eb2\u0e99\u0eb4" },
            { "ba", "\u0e9a\u0eb2\u0ea3\u0e81\u0eb5" },
            { "be", "\u0ec0\u0e9a\u0ea5\u0eb2\u0ea3\u0eb1\u0eaa\u0e8a\u0ebd\u0e99" },
            { "bg", "\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ea3\u0ebd\u0e99" },
            { "bi", "\u0e9a\u0eb4\u0eaa\u0ea5\u0eb0\u0ea1\u0eb2" },
            { "bm", "\u0e9a\u0eb2\u0ea1\u0e9a\u0eb2\u0ea3\u0eb2" },
            { "bn", "\u0ec0\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ea5\u0eb5" },
            { "bo", metaValue_bo },
            { "br", "\u0ec0\u0e9a\u0ea3\u0e95\u0eb1\u0e99" },
            { "bs", "\u0e9a\u0ead\u0eaa\u0e99\u0ebd\u0e99" },
            { "ca", "\u0e84\u0eb2\u0e95\u0eb2\u0ea5\u0eb2\u0e99" },
            { "ce", "\u0e8a\u0eb5\u0ec0\u0e84\u0e99" },
            { "ch", "\u0e8a\u0eb2\u0ea1\u0ecd\u0ec2\u0ea3" },
            { "co", "\u0e84\u0ecd\u0e8a\u0eb4\u0e81\u0eb2" },
            { "cr", "\u0e84\u0eb5" },
            { "cs", "\u0ec0\u0e8a\u0e81" },
            { "cu", "\u0ec2\u0e9a\u0e94\u0eaa\u0ea5\u0eb2\u0ea7\u0eb4\u0e81" },
            { "cv", "\u0e8a\u0eb9\u0ea7\u0eb2\u0e8a" },
            { "cy", "\u0ec0\u0ea7\u0ea7" },
            { "da", "\u0ec1\u0e94\u0e99\u0eb4\u0e8a" },
            { "de", metaValue_DE },
            { "dv", "\u0e94\u0eb5\u0ea7\u0eb5\u0eae\u0eb5" },
            { "dz", "\u0e94\u0eb5\u0e8a\u0ead\u0e87\u0e84\u0eb2" },
            { "ee", "\u0ead\u0eb4\u0ea7\u0eb2" },
            { "el", metaValue_el },
            { "en", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94" },
            { "eo", "\u0ec0\u0ead\u0eaa\u0e9b\u0eb2\u0e8d" },
            { "es", "\u0eaa\u0eb0\u0ec1\u0e9b\u0e99\u0e99\u0eb4\u0e8a" },
            { "et", "\u0ec0\u0ead\u0eaa\u0ec2\u0e95\u0e99\u0ebd\u0e99" },
            { "eu", "\u0e9a\u0eb1\u0eaa\u0e81\u0eb5" },
            { "fa", "\u0ec0\u0e9b\u0eb5\u0e8a\u0ebd\u0e99" },
            { "ff", "\u0e9f\u0eb9\u0ea5\u0eb2" },
            { "fi", "\u0e9f\u0eb4\u0e99\u0e99\u0eb4\u0e8a" },
            { "fj", "\u0e9f\u0eb4\u0e88\u0ebd\u0e99" },
            { "fo", "\u0e9f\u0eb2\u0ec2\u0ea3\u0eaa" },
            { "fr", metaValue_FR },
            { "fy", "\u0e9f\u0ea3\u0eb4\u0e8a\u0ebd\u0e99 \u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "ga", "\u0ec4\u0ead\u0ea3\u0eb4\u0eaa" },
            { "gd", "\u0eaa\u0eb0\u0e81\u0eb1\u0ead\u0e94\u0ec0\u0e81\u0ea5\u0eb4\u0e81" },
            { "gl", "\u0e81\u0eb2\u0ea5\u0eb4\u0e8a\u0ebd\u0e99" },
            { "gn", "\u0e81\u0ebb\u0ea7\u0ea3\u0eb2\u0e99\u0eb5" },
            { "gu", "\u0e81\u0eb9\u0e88\u0eb2\u0ea3\u0eb2\u0e95\u0eb4" },
            { "gv", "\u0ec1\u0ea1\u0e87\u0e8a\u0ecc" },
            { "ha", "\u0ec0\u0eae\u0ebb\u0eb2\u0e8a\u0eb2" },
            { "he", metaValue_he },
            { "hi", "\u0eae\u0eb4\u0e99\u0e94\u0eb4" },
            { "ho", "\u0eae\u0eb4\u0ea3\u0eb4\u0ec2\u0ea1\u0e95\u0eb9" },
            { "hr", "\u0ec2\u0e84\u0ea3\u0ec0\u0ead\u0e97\u0ebd\u0e99" },
            { "ht", "\u0ec4\u0eae\u0e95\u0ebd\u0e99" },
            { "hu", "\u0eae\u0eb1\u0e87\u0e81\u0eb2\u0ea3\u0ebd\u0e99" },
            { "hy", metaValue_hy },
            { "hz", "\u0ec0\u0eae\u0eb4\u0eae\u0eb4\u0ec2\u0ea3" },
            { "ia", "\u0ead\u0eb4\u0e99\u0ec0\u0e95\u0eb5\u0ea5\u0eb4\u0e87\u0ea5\u0ebb\u0ea7" },
            { "id", "\u0ead\u0eb4\u0e99\u0ec2\u0e94\u0ec0\u0e99\u0e8a\u0ebd\u0e99" },
            { "ie", "\u0ead\u0eb4\u0e99\u0ec0\u0e95\u0eb5\u0ea5\u0eb4\u0e87\u0e81\u0ea3\u0eb5" },
            { "ig", "\u0ead\u0eb4\u0e81\u0ec2\u0e9a" },
            { "ii", "\u0ec0\u0eaa\u0eaa\u0ea7\u0e99 \u0ead\u0eb5" },
            { "ik", "\u0ead\u0eb4\u0e99\u0e99\u0eb9\u0e9b\u0ebd\u0e81" },
            { "io", "\u0ead\u0eb5\u0ec2\u0e94" },
            { "is", "\u0ec4\u0ead\u0eaa\u0ec1\u0ea5\u0e99\u0e94\u0eb4\u0e81" },
            { "it", "\u0ead\u0eb4\u0e95\u0eb2\u0ea5\u0ebd\u0e99" },
            { "iu", "\u0ead\u0eb4\u0e99\u0e99\u0eb8\u0e81\u0e95\u0eb4\u0e95\u0eb1\u0e94" },
            { "ja", metaValue_JP },
            { "jv", "\u0e88\u0eb2\u0ec1\u0ea7\u0e99\u0eb5\u0eaa" },
            { "ka", metaValue_ka },
            { "kg", "\u0e84\u0ead\u0e87\u0ec2\u0e81" },
            { "ki", "\u0e84\u0eb4\u0e84\u0eb9\u0ea2\u0eb8" },
            { "kj", "\u0e81\u0ea7\u0e99\u0e8d\u0eb2\u0ea1\u0eb2" },
            { "kk", "\u0e84\u0eb2\u0e8a\u0eb1\u0e81" },
            { "kl", "\u0e81\u0ea3\u0eb5\u0e99\u0ec1\u0ea5\u0e99\u0ea5\u0eb4\u0e94" },
            { "km", "\u0e82\u0eb0\u0ec0\u0edd\u0e99" },
            { "kn", metaValue_kn },
            { "ko", "\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5" },
            { "kr", "\u0e84\u0eb2\u0e99\u0eb8\u0ea5\u0eb4" },
            { "ks", "\u0e84\u0eb2\u0eaa\u0ec0\u0ea1\u0e8d\u0ea3\u0eb4" },
            { "ku", "\u0ec0\u0e84\u0eb5\u0e94\u0eb4\u0eaa" },
            { "kv", "\u0ec2\u0e84\u0ea1\u0eb4" },
            { "kw", "\u0e84\u0ecd\u0e99\u0eb4\u0e8a" },
            { "ky", "\u0ec0\u0e81\u0e8d\u0e81\u0eb5\u0eaa" },
            { "la", metaValue_la },
            { "lb", "\u0ea5\u0eb1\u0e81\u0ec0\u0e8a\u0ea1\u0e9a\u0ea7\u0e81\u0e81\u0eb4\u0e8a" },
            { "lg", "\u0ec1\u0e81\u0e99\u0e94\u0eb2" },
            { "li", "\u0ea5\u0eb4\u0ea1\u0ec0\u0e9a\u0eb5\u0e81\u0eb5\u0e8a" },
            { "ln", "\u0ea5\u0eb4\u0e87\u0e81\u0eb2\u0ea5\u0eb2" },
            { "lo", metaValue_LA },
            { "lt", "\u0ea5\u0eb4\u0e97\u0ebb\u0ea7\u0e99\u0ebd\u0e99" },
            { "lu", "\u0ea5\u0eb9\u0e9a\u0eb2-\u0e84\u0eb2\u0e95\u0eb1\u0e87\u0e81\u0eb2" },
            { "lv", "\u0ea5\u0eb1\u0e94\u0ea7\u0ebd\u0e99" },
            { "mg", "\u0ea1\u0eb2\u0ea5\u0eb2\u0e81\u0eb2\u0eaa\u0e8a\u0eb5" },
            { "mh", "\u0ea1\u0eb2\u0e8a\u0eb2\u0e99\u0ec0\u0ea5\u0eb1\u0e94" },
            { "mi", "\u0ea1\u0eb2\u0ea7\u0ea3\u0eb4" },
            { "mk", "\u0ec1\u0ea1\u0e8a\u0eb4\u0ec2\u0e94\u0e99\u0ebd\u0e99" },
            { "ml", "\u0ea1\u0eb2\u0ec0\u0ea5\u0ead\u0eb2\u0ea5\u0eb3" },
            { "mn", metaValue_MN },
            { "mr", "\u0ea1\u0eb2\u0ea3\u0eb2\u0e97\u0eb5" },
            { "ms", "\u0ea1\u0eb2\u0ec0\u0ea5" },
            { "mt", "\u0ea1\u0ead\u0ea5\u0e97\u0eb5\u0eaa" },
            { "my", metaValue_my },
            { "na", "\u0e99\u0eb2\u0ea2\u0eb9\u0ea5\u0eb9" },
            { "nb", "\u0e99\u0ecd\u0ec0\u0ea7\u0e88\u0ebd\u0e99 \u0e9a\u0eb1\u0ead\u0e81\u0ea1\u0ead\u0ea5" },
            { "nd", "\u0ec0\u0ead\u0eb1\u0e99\u0ec0\u0e94\u0ec0\u0e9a\u0ec0\u0ea5\u0ec0\u0edc\u0eb7\u0ead" },
            { "ne", "\u0ec0\u0e99\u0e9b\u0eb2\u0ea5\u0eb5" },
            { "ng", "\u0ec0\u0ead\u0eb1\u0e99\u0e94\u0ead\u0e87\u0e81\u0eb2" },
            { "nl", "\u0e94\u0eb1\u0e8a" },
            { "nn", "\u0e99\u0ecd\u0ec0\u0ea7\u0e88\u0ebd\u0e99 \u0e99\u0eb5\u0e99\u0ead\u0e81" },
            { "no", "\u0e99\u0ecd\u0ec0\u0ea7\u0e8d" },
            { "nr", "\u0e99\u0eb5\u0e9a\u0eb5\u0ea5\u0eb5\u0ec3\u0e95\u0ec9" },
            { "nv", "\u0e99\u0eb2\u0ea7\u0eb2\u0ec2\u0e88" },
            { "ny", "\u0e99\u0eb2\u0e99\u0e88\u0eb2" },
            { "oc", "\u0ead\u0eb1\u0ead\u0e81\u0e8a\u0eb5\u0e95\u0eb2\u0e99" },
            { "oj", "\u0ec2\u0ead\u0e88\u0eb4\u0e9a\u0ea7\u0eb2" },
            { "om", "\u0ec2\u0ead\u0ec2\u0ea3\u0ec2\u0ea1" },
            { "or", "\u0ec2\u0ead\u0ea3\u0eb4\u0ea2\u0eb2" },
            { "os", "\u0ead\u0ead\u0e94\u0ec0\u0e8a\u0e95\u0eb4\u0e81" },
            { "pa", "\u0e9b\u0eb1\u0e99\u0e88\u0eb2\u0e9a\u0eb5" },
            { "pi", "\u0e9b\u0eb2\u0ea5\u0eb5" },
            { "pl", "\u0ec2\u0e9b\u0ea5\u0eb4\u0e8a" },
            { "ps", "\u0e9b\u0eb2\u0eaa\u0ec2\u0e95" },
            { "pt", "\u0e9b\u0ead\u0e81\u0e95\u0eb8\u0e8d\u0e81\u0eb4\u0eaa" },
            { "qu", "\u0e84\u0eb5\u0e8a\u0ebb\u0ea7" },
            { "rm", "\u0ec2\u0ea3\u0ec1\u0ea1\u0e99\u0e8a\u0ecc" },
            { "rn", "\u0ea3\u0eb8\u0e99\u0e94\u0eb4" },
            { "ro", "\u0ec2\u0ea3\u0ec1\u0ea1\u0e99\u0ebd\u0e99" },
            { "ru", "\u0ea5\u0eb1\u0e94\u0ec0\u0e8a\u0e8d" },
            { "rw", "\u0e84\u0eb4\u0e99\u0ea2\u0eb2\u0ea7\u0eb2\u0e99\u0e94\u0eb2" },
            { "sa", "\u0eaa\u0eb1\u0e99\u0eaa\u0eb0\u0e81\u0ea3\u0eb4\u0e94" },
            { "sc", "\u0eaa\u0eb2\u0e94\u0eb5\u0e99\u0ebd\u0e99" },
            { "sd", "\u0eaa\u0eb4\u0e99\u0e97\u0eb4" },
            { "se", "\u0e8a\u0eb2\u0ea1\u0eb4\u0ec0\u0edc\u0eb7\u0ead" },
            { "sg", "\u0ec1\u0e8a\u0e87\u0ec2\u0e81" },
            { "sh", "\u0ec0\u0e8a\u0eb5\u0ec2\u0e9a-\u0ec2\u0e81\u0ec0\u0e8a\u0e8d" },
            { "si", metaValue_si },
            { "sk", "\u0eaa\u0eb0\u0ec2\u0ea5\u0ec1\u0ea7\u0eb1\u0e81" },
            { "sl", "\u0eaa\u0eb0\u0ec2\u0ea5\u0ec0\u0ea7\u0e99\u0ebd\u0e99" },
            { "sm", metaValue_WS },
            { "sn", "\u0ec2\u0e8a\u0e99\u0eb2" },
            { "so", "\u0ec2\u0e8a\u0ea1\u0eb2\u0ea5\u0eb5" },
            { "sq", "\u0ead\u0eb2\u0e99\u0e9a\u0eb2\u0e99\u0ebd\u0e99" },
            { "sr", "\u0ec0\u0e8a\u0eb5\u0e9a\u0ebd\u0e99" },
            { "ss", "\u0e8a\u0ea3\u0eb2\u0e95\u0eb4" },
            { "st", "\u0ec2\u0e8a\u0ec2\u0e97\u0ec3\u0e95\u0ec9" },
            { "su", "\u0e8a\u0eb8\u0e99\u0ec1\u0e94\u0e99\u0e99\u0eb5\u0eaa" },
            { "sv", "\u0eaa\u0eb0\u0ea7\u0eb5\u0e94\u0eb4\u0e8a" },
            { "sw", "\u0e8a\u0ea7\u0eb2\u0eae\u0eb5\u0ea5\u0eb4" },
            { "ta", metaValue_ta },
            { "te", "\u0ec0\u0e95\u0ea5\u0eb9\u0e81\u0eb9" },
            { "tg", "\u0e97\u0eb2\u0e88\u0eb4\u0e81" },
            { "th", metaValue_TH },
            { "ti", "\u0e95\u0eb4\u0e81\u0ea3\u0eb4\u0e99\u0ea2\u0eb2" },
            { "tk", "\u0ec0\u0e97\u0eb5\u0e81\u0ec0\u0ea1\u0eb1\u0e99" },
            { "tl", metaValue_tl },
            { "tn", "\u0ec0\u0e95\u0eaa\u0eb0\u0ea7\u0eb2\u0e99\u0eb2" },
            { "to", "\u0e97\u0ead\u0e87\u0e81\u0eb2\u0e99" },
            { "tr", "\u0ec0\u0e97\u0eb5\u0e84\u0eb4\u0e8a" },
            { "ts", "\u0ec0\u0e95\u0e8a\u0ead\u0e87\u0e81\u0eb2" },
            { "tt", "\u0e97\u0eb2\u0e97\u0eb2" },
            { "tw", "\u0e97\u0ea7\u0eb5" },
            { "ty", "\u0e95\u0eb2\u0eae\u0eb5\u0e95\u0ebd\u0e99" },
            { "ug", "\u0ead\u0eb8\u0e8d\u0ec0\u0e84\u0eb5" },
            { "uk", "\u0ea2\u0eb9\u0ec0\u0e84\u0ea3\u0e99\u0ebd\u0e99" },
            { "ur", "\u0ead\u0eb9\u0ea3\u0e94\u0eb9" },
            { "uz", "\u0ead\u0eb8\u0eaa\u0ec0\u0e9a\u0e81" },
            { "ve", "\u0ec0\u0ea7\u0e99\u0e94\u0eb2" },
            { "vi", metaValue_VN },
            { "vo", "\u0ec2\u0ea7\u0ea5\u0eb2\u0e9e\u0eb1\u0e81" },
            { "wa", "\u0ea7\u0ecd\u0ea5\u0eb9\u0ea1" },
            { "wo", "\u0ea7\u0ecd\u0ea5\u0ead\u0e9a" },
            { "xh", "\u0ec2\u0eae\u0e8a\u0eb2" },
            { "yi", "\u0ea2\u0eb4\u0ea7" },
            { "yo", "\u0ec2\u0ea2\u0ea3\u0eb9\u0e9a\u0eb2" },
            { "za", "\u0e8a\u0ea7\u0eb2\u0e87" },
            { "zh", metaValue_CN },
            { "zu", "\u0e8a\u0eb9\u0ea5\u0eb9" },
            { "ace", "\u0ec1\u0ead\u0eb1\u0e81\u0e8a\u0eb5\u0ec0\u0e99\u0eb1\u0eaa" },
            { "ach", "\u0ead\u0eb2\u0ec2\u0e84\u0ea5\u0eb5" },
            { "ada", "\u0ead\u0eb2\u0ec1\u0e94\u0e87\u0ea1\u0eb5" },
            { "ady", "\u0ec0\u0ead\u0e94\u0eb5\u0eae\u0eb4" },
            { "afh", "\u0ec1\u0ead\u0e9f\u0eb5\u0eae\u0eb5\u0ea5\u0eb5" },
            { "agq", "\u0ead\u0eb2\u0ec0\u0eae\u0eb1\u0ea1" },
            { "ain", "\u0ec4\u0ead\u0e99\u0eb9" },
            { "akk", "\u0ead\u0eb1\u0e81\u0e81\u0eb2\u0e94\u0ebd\u0ea1" },
            { "ale", "\u0ead\u0eb2\u0ec0\u0ea5\u0eb5\u0e94" },
            { "alt", "\u0ead\u0eb2\u0e99\u0ec4\u0e95\u0ec3\u0e95\u0ec9" },
            { "ang", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "ann", "\u0ec2\u0ead\u0ec2\u0e9a\u0ec2\u0ea5" },
            { "anp", "\u0ec1\u0ead\u0e99\u0e88\u0eb5\u0e81\u0eb2" },
            { "arc", "\u0ead\u0eb2\u0ea5\u0eb2\u0ea1\u0eb4\u0e81" },
            { "arn", "\u0ea1\u0eb2\u0e9e\u0eb8\u0e94\u0e8a\u0eb5" },
            { "arp", "\u0ead\u0eb2\u0ea3\u0eb2\u0e9b\u0eb2\u0ec2\u0eae" },
            { "ars", "\u0e99\u0eb2\u0e88\u0e94\u0eb5 \u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81" },
            { "arw", "\u0ead\u0eb2\u0ea3\u0eb2\u0ec1\u0ea7\u0e81" },
            { "asa", "\u0ead\u0eb2\u0e8a\u0eb9" },
            { "ast", "\u0ead\u0eb1\u0eaa\u0e95\u0eb9\u0eae\u0ebd\u0e99" },
            { "atj", "\u0ead\u0eb2\u0e95\u0eb4\u0e81\u0eb2\u0ec1\u0ea1\u0e81" },
            { "awa", "\u0ead\u0eb2\u0ea7\u0eb2\u0eae\u0eb4" },
            { "bal", "\u0e9a\u0eb2\u0ea5\u0eb9\u0e8a\u0eb5" },
            { "ban", "\u0e9a\u0eb2\u0ea5\u0eb5\u0ec0\u0e99\u0eb1\u0e94" },
            { "bas", "\u0e9a\u0eb2\u0e8a\u0eb2" },
            { "bax", "\u0e9a\u0eb2\u0ea1\u0eb8\u0e99" },
            { "bbj", "\u0ec2\u0e84\u0ea1\u0eb2\u0ea5\u0eb2" },
            { "bej", "\u0e9a\u0eb5\u0ec0\u0e88" },
            { "bem", "\u0ec0\u0e9a\u0eb1\u0ea1\u0e9a\u0eb2" },
            { "bez", "\u0e9a\u0eb5\u0e99\u0eb2" },
            { "bfd", "\u0e9a\u0eb2\u0e9f\u0eb1\u0e94" },
            { "bgn", "\u0e9a\u0eb2\u0ec2\u0ea5\u0e88\u0eb5 \u0e9e\u0eb2\u0e81\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "bho", "\u0ec2\u0e9a\u0e9e\u0eb9\u0ea3\u0eb4" },
            { "bik", "\u0e9a\u0eb5\u0e84\u0ead\u0e99" },
            { "bin", "\u0e9a\u0eb5\u0e99\u0eb5" },
            { "bkm", "\u0e81\u0ebb\u0ea1" },
            { "bla", "\u0e8a\u0eb4\u0e81\u0e8a\u0eb4\u0e81\u0eb2" },
            { "bra", "\u0e9a\u0ea3\u0eb2" },
            { "brx", "\u0ec2\u0e9a\u0e94\u0eb9" },
            { "bss", "\u0ead\u0eb2\u0e84\u0eb8\u0e94" },
            { "bua", "\u0e9a\u0eb9\u0ea3\u0ebd\u0e94" },
            { "bug", "\u0e9a\u0eb9\u0e88\u0eb5\u0ec0\u0e99\u0eb1\u0e94" },
            { "bum", "\u0e9a\u0eb9\u0ea5\u0eb9" },
            { "byn", "\u0e9a\u0ea5\u0eb4\u0e99" },
            { "byv", "\u0ec0\u0ea1\u0e94\u0eb9\u0ea1\u0e9a\u0eb2" },
            { "cad", "\u0ec1\u0e84\u0e94\u0ec2\u0e94" },
            { "car", "\u0e84\u0eb2\u0ea3\u0eb4\u0e9a" },
            { "cay", "\u0e84\u0eb2\u0ea2\u0eb9\u0e81\u0eb2" },
            { "cch", "\u0ead\u0eb2\u0e94\u0ec1\u0e8a\u0ea1" },
            { "ccp", "Chakma" },
            { "ceb", "\u0e8a\u0eb5\u0e9a\u0eb9\u0ec2\u0e99" },
            { "cgg", "\u0e8a\u0eb5\u0e81\u0eb2" },
            { "chb", "\u0e8a\u0eb4\u0e9a\u0e8a\u0eb2" },
            { "chg", "\u0e8a\u0eb2\u0e81\u0eb2\u0ec4\u0e95" },
            { "chk", "\u0e8a\u0eb9\u0ec0\u0e81\u0e94" },
            { "chm", "\u0ea1\u0eb2\u0ea3\u0eb4" },
            { "chn", "\u0e8a\u0eb5\u0e99\u0eb8\u0e81\u0e88\u0eb2\u0e81\u0ead\u0e99" },
            { "cho", "\u0e8a\u0ead\u0e81\u0e95\u0eb4\u0ea7" },
            { "chp", "\u0e8a\u0eb5\u0e9e\u0eb4\u0ea7\u0ea2\u0eb2\u0e99" },
            { "chr", "\u0e8a\u0eb5\u0ec2\u0ea3\u0e81\u0eb5" },
            { "chy", "\u0e8a\u0eb5\u0ec0\u0ea2\u0e99\u0e99\u0eb5" },
            { "ckb", "\u0ec2\u0e8a\u0ea3\u0eb2\u0e99\u0eb4 \u0ec0\u0e84\u0eb5\u0e94\u0eb4\u0e8a" },
            { "clc", "\u0e8a\u0eb4\u0ea7\u0ec2\u0e84\u0e95\u0eb4\u0e99" },
            { "cop", metaValue_cop },
            { "crg", "\u0ea1\u0eb4\u0e8a\u0eb4\u0e9f" },
            { "crh", "\u0e84\u0ea3\u0eb5\u0ec0\u0ea1\u0e99\u0ec0\u0e95\u0eb5\u0e84\u0eb4\u0e8a" },
            { "crj", "\u0e84\u0ea3\u0eb5\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81\u0eaa\u0ec8\u0ebd\u0e87\u0ec3\u0e95\u0ec9" },
            { "crk", "\u0ec0\u0e9e\u0ea5\u0e99\u0e84\u0ea3\u0eb5" },
            { "crl", "\u0e84\u0ea3\u0eb5\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81\u0eaa\u0ec8\u0ebd\u0e87\u0ec0\u0edc\u0eb7\u0ead" },
            { "crm", "\u0ea1\u0eb9\u0eaa\u0e84\u0ea3\u0eb5" },
            { "crr", "\u0e84\u0eb2\u0ec2\u0ea3\u0ea5\u0eb4\u0e99\u0eb2 \u0ead\u0eb2\u0e81\u0ead\u0e99\u0e84\u0ea7\u0ebd\u0e99" },
            { "crs", "\u0ec0\u0e8a\u0ec0\u0e8a\u0ea7\u0eb2 \u0ec2\u0e84\u0ea3\u0e94 \u0e9d\u0ea3\u0eb1\u0ec8\u0e87" },
            { "csb", "\u0e81\u0eb2\u0e8a\u0eb9\u0e9a\u0ebd\u0e99" },
            { "csw", "\u0e8a\u0ea7\u0eb2\u0ea1\u0e9b\u0eb5\u0e84\u0ea3\u0eb5" },
            { "dak", "\u0e94\u0eb2\u0ec2\u0e81\u0e95\u0eb2" },
            { "dar", "\u0e94\u0eb2\u0e81\u0ea7\u0eb2" },
            { "dav", "\u0ec4\u0e95\u0e95\u0eb2" },
            { "del", "\u0ec0\u0e94\u0ea5\u0eb2\u0ea7\u0eb2" },
            { "den", "\u0e8a\u0eb5\u0ec0\u0ea5\u0eb1\u0e9a" },
            { "dgr", "\u0ec2\u0e94\u0e81\u0ea3\u0eb4\u0e9a" },
            { "din", "\u0e94\u0eb4\u0e99\u0e81\u0eb2" },
            { "dje", "\u0e8a\u0eb2\u0ea1\u0eb2" },
            { "doi", "\u0e94\u0ead\u0e81\u0ea3\u0eb5" },
            { "dsb", "\u0e8a\u0ecd\u0e9a\u0ebd\u0e99\u0e95\u0ecd\u0ec8\u0e81\u0ea7\u0ec8\u0eb2" },
            { "dua", "\u0e94\u0ebb\u0ea7\u0ea5\u0eb2" },
            { "dum", "\u0e94\u0eb1\u0e81\u0e81\u0eb2\u0e87" },
            { "dyo", "\u0ec2\u0e88\u0ea5\u0eb2-\u0e9f\u0ead\u0e99\u0ea2\u0eb5" },
            { "dyu", "\u0e94\u0eb9\u0ea5\u0eb2" },
            { "dzg", "\u0e94\u0eb2\u0e8a\u0eb2\u0e81\u0eb2" },
            { "ebu", "\u0ec0\u0ead\u0eb1\u0ea1\u0e9a\u0eb9" },
            { "efi", "\u0ead\u0eb5\u0e9f\u0eb4\u0e81" },
            { "egy", "\u0ead\u0eb5\u0ea2\u0eb4\u0e9a\u0e9a\u0eb9\u0eae\u0eb2\u0e99" },
            { "eka", "\u0ead\u0eb5\u0e81\u0eb2\u0e88\u0eb1\u0e81" },
            { "elx", "\u0ead\u0eb5\u0ea5\u0eb2\u0ec4\u0ea1" },
            { "enm", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0e81\u0eb2\u0e87" },
            { "ewo", "\u0ead\u0eb5\u0ea7\u0ead\u0e99\u0e94\u0eb9" },
            { "fan", "\u0ec1\u0e9f\u0e87" },
            { "fat", "\u0ec1\u0e9f\u0e99\u0e95\u0eb5" },
            { "fil", "\u0e9f\u0eb5\u0ea5\u0eb4\u0e9b\u0eb5\u0ec2\u0e99" },
            { "fon", "\u0e9f\u0ead\u0e99" },
            { "frc", "\u0e9d\u0ea3\u0eb1\u0ec8\u0e87\u0ec0\u0e84\u0e88\u0eb8\u0e99" },
            { "frm", "\u0e9f\u0eae\u0eb1\u0ec8\u0e87\u0ec0\u0eaa\u0e94\u0e81\u0eb2\u0e87" },
            { "fro", "\u0e9f\u0eae\u0eb1\u0ec8\u0e87\u0ec0\u0eaa\u0e94\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "frr", "\u0e9f\u0ea3\u0eb5\u0e8a\u0ebd\u0e99\u0ec0\u0edc\u0eb7\u0ead" },
            { "frs", "\u0e9f\u0ea3\u0eb5\u0e8a\u0ebd\u0e99\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "fur", "\u0e9f\u0ea3\u0eb5\u0ea5\u0ebd\u0e99" },
            { "gaa", "\u0e81\u0eb2" },
            { "gag", "\u0e81\u0eb2\u0e81\u0eb2\u0ead\u0eb8\u0e8a" },
            { "gay", "\u0e81\u0eb2\u0ec2\u0ea2" },
            { "gba", "\u0e9a\u0eb2\u0e8d\u0eb2" },
            { "gez", "\u0e81\u0eb5" },
            { "gil", "\u0e81\u0eb4\u0e99\u0ec0\u0e9a\u0eb5\u0ec0\u0e97\u0eb1\u0e94" },
            { "gmh", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99\u0eaa\u0eb9\u0e87\u0e81\u0eb2\u0e87" },
            { "goh", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99\u0eaa\u0eb9\u0e87\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "gon", "\u0e81\u0ead\u0e99\u0e94\u0eb5" },
            { "gor", "\u0ec2\u0e81\u0ea3\u0ead\u0e99\u0e95\u0eb2\u0ec2\u0ea3" },
            { "got", "\u0e81\u0ead\u0e94\u0eae\u0eb4\u0e81" },
            { "grb", "\u0e81\u0ea3\u0eb5\u0ec2\u0e9a" },
            { "grc", "\u0ec1\u0ead\u0e99\u0e8a\u0ebd\u0e99\u0e81\u0ea3\u0eb5\u0e81" },
            { "gsw", "\u0eaa\u0eb0\u0ea7\u0eb4\u0eaa \u0ec0\u0e88\u0eb5\u0ec1\u0ea1\u0e99" },
            { "guz", "\u0e81\u0eb9\u0e8a\u0eb4" },
            { "gwi", "\u0ea7\u0eb4\u0e94\u0ead\u0eb4\u0e99" },
            { "hai", "\u0ec4\u0eae\u0e94\u0eb2" },
            { "haw", "\u0eae\u0eb2\u0ec4\u0ea7\u0ead\u0ebd\u0e99" },
            { "hax", "\u0ec4\u0eae\u0e94\u0eb2\u0ec3\u0e95\u0ec9" },
            { "hil", "\u0eae\u0eb4\u0ea3\u0eb4\u0ec4\u0e81\u0e99\u0ead\u0e99" },
            { "hit", "\u0eae\u0eb4\u0e94\u0ec4\u0e95" },
            { "hmn", "\u0ea1\u0ead\u0e87" },
            { "hsb", "\u0e8a\u0ecd\u0e9a\u0ebd\u0e99 \u0e97\u0eb2\u0e87\u0e95\u0ead\u0e99\u0ec0\u0edc\u0eb7\u0ead" },
            { "hup", "\u0eae\u0eb9\u0e9b\u0eb2" },
            { "hur", "\u0eae\u0eb2\u0ea5\u0ec2\u0e81\u0ec0\u0ea1\u0ea5\u0ebd\u0ea1" },
            { "iba", "\u0ec4\u0ead\u0e9a\u0eb2\u0e99" },
            { "ibb", "\u0ec4\u0ead\u0ec4\u0e9a\u0ec4\u0e9a\u0ec2\u0ead" },
            { "ikt", "\u0ead\u0eb4\u0e99\u0eb1\u0e81\u0e97\u0eb4\u0e97\u0eb1\u0e94\u0e84\u0eb2\u0e99\u0eb2\u0e94\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "ilo", "\u0ec4\u0ead\u0ec2\u0ea5\u0ec2\u0e81" },
            { "inh", "\u0ead\u0eb4\u0e99\u0e81\u0eb1\u0e8a" },
            { "jbo", "\u0ec2\u0ea5\u0e9a\u0e9a\u0eb1\u0e99" },
            { "jgo", "\u0e87\u0ead\u0ea1\u0e9a\u0eb2" },
            { "jmc", "\u0ea1\u0eb2\u0ec1\u0e8a\u0ea1" },
            { "jpr", "\u0e88\u0eb9\u0ec1\u0e94\u0ea7-\u0ec0\u0e9e\u0eb5\u0e8a\u0ebd\u0e99" },
            { "jrb", "\u0e88\u0eb9\u0ec1\u0e94\u0ea7-\u0ead\u0eb2\u0ea5\u0eb2\u0e9a\u0eb4\u0e81" },
            { "kaa", "\u0e81\u0eb2\u0ea3\u0eb2-\u0e81\u0eb2\u0e99\u0e9b\u0eb2\u0e81" },
            { "kab", "\u0e81\u0eb2\u0ec4\u0e9a\u0ea5\u0ecc" },
            { "kac", "\u0e81\u0eb2\u0e8a\u0eb4\u0e99" },
            { "kaj", "\u0e88\u0ea3\u0eb9" },
            { "kam", "\u0e81\u0eb2\u0ea1\u0e9a\u0eb2" },
            { "kaw", "\u0e81\u0eb0\u0ea7\u0eb5" },
            { "kbd", "\u0e81\u0eb2\u0e9a\u0eb2\u0e94\u0ebd\u0e99" },
            { "kbl", "\u0e84\u0eb2\u0ec1\u0e99\u0ea1\u0e9a\u0eb9" },
            { "kcg", "\u0e95\u0eb5\u0e9a" },
            { "kde", "\u0ea1\u0eb2\u0e84\u0ead\u0e99\u0ec0\u0e94" },
            { "kea", "\u0e84\u0eb2\u0ec0\u0ea7\u0eb5\u0ec0\u0e94\u0e8d\u0e99\u0eb9" },
            { "kfo", "\u0ec2\u0e84\u0ec2\u0ea5" },
            { "kgp", "\u0ec0\u0e84\u0e99\u0e81\u0eb1\u0e87" },
            { "kha", "\u0e84\u0eb2\u0eaa\u0eb4" },
            { "kho", "\u0ec2\u0e84\u0e95\u0eb1\u0e99" },
            { "khq", "\u0e84\u0ead\u0e8d\u0ea3\u0eb2 \u0e8a\u0eb4\u0e99\u0eb5" },
            { "kkj", "\u0e84\u0eb2\u0ec2\u0e81" },
            { "kln", "\u0e84\u0eb2\u0ec0\u0ea5\u0eb1\u0e99\u0e88\u0eb4\u0e99" },
            { "kmb", "\u0e84\u0eb4\u0ea1\u0e9a\u0eb1\u0e99\u0e94\u0eb9" },
            { "koi", "\u0ec2\u0e84\u0ea1\u0eb5-\u0ec0\u0e9e\u0eb5\u0ea1\u0ea2\u0eb1\u0e81" },
            { "kok", "\u0e81\u0ead\u0e99\u0e81\u0eb2\u0e99\u0eb5" },
            { "kos", "\u0e84\u0eb9\u0eaa\u0ec4\u0ea5" },
            { "kpe", "\u0e81\u0eb2\u0ec1\u0e9b\u0ea3" },
            { "krc", "\u0e81\u0eb2\u0ea3\u0eb2\u0ec4\u0e8a-\u0e9a\u0eb2\u0e99\u0e81\u0eb2" },
            { "krl", "\u0e81\u0eb2\u0ec0\u0ea3\u0ea5\u0ebd\u0e99" },
            { "kru", "\u0e81\u0eb9\u0ea3\u0eb9\u0e81" },
            { "ksb", "\u0e8a\u0eb3\u0e9a\u0eb2\u0ea5\u0ec9\u0eb2" },
            { "ksf", "\u0e9a\u0eb2\u0ec0\u0e9f\u0e8d" },
            { "ksh", "\u0ec2\u0e84\u0ea5\u0ead\u0e81\u0e99\u0ebd\u0e99" },
            { "kum", "\u0e84\u0eb9\u0ea1\u0eb5\u0e81" },
            { "kut", "\u0e84\u0eb9\u0ec0\u0e97\u0ec4\u0e99" },
            { "kwk", "\u0e84\u0ea7\u0eb2\u0e81\u0e84\u0ea7\u0eb2\u0e81\u0ea5\u0eb2" },
            { "lad", "\u0ea5\u0eb2\u0e94\u0eb5\u0ec2\u0e99" },
            { "lag", "\u0ec1\u0ea5\u0e99\u0e81\u0eb4" },
            { "lah", "\u0ea5\u0eb2\u0e99\u0e94\u0eb2" },
            { "lam", "\u0ec1\u0ea5\u0ea1\u0e9a\u0eb2" },
            { "lez", "\u0ea5\u0eb5\u0e8a\u0ebd\u0e99" },
            { "lil", "\u0ea5\u0eb4\u0e99\u0ea5\u0eb9\u0ec0\u0ead\u0eb1\u0e94" },
            { "lkt", "\u0ea5\u0eb2\u0ec2\u0e81\u0e95\u0eb2" },
            { "lol", "\u0ec1\u0ea1\u0eb1\u0e87\u0ec2\u0e81\u0ec9" },
            { "lou", "\u0ea5\u0eb8\u0e8d\u0e8a\u0eb5\u0ead\u0eb2\u0e99\u0e99\u0eb2 \u0e84\u0ea3\u0eb5\u0ec2\u0ead\u0e99" },
            { "loz", "\u0ec2\u0ea5\u0e8a\u0eb4" },
            { "lrc", "\u0ea5\u0eb9\u0ea3\u0eb4 \u0e97\u0eb2\u0e87\u0e95\u0ead\u0e99\u0ec0\u0edc\u0eb7\u0ead" },
            { "lsm", "\u0e8a\u0eb2\u0ead\u0eb2\u0ec0\u0ea1\u0e8d" },
            { "lua", "\u0ea5\u0eb9\u0e9a\u0eb2-\u0ea5\u0eb9\u0ea5\u0ebb\u0ea7" },
            { "lui", "\u0ea5\u0eb9\u0ec0\u0e8a\u0ec2\u0e99" },
            { "lun", "\u0ea5\u0eb8\u0e99\u0e94\u0eb2" },
            { "luo", "\u0ea5\u0ebb\u0ea7" },
            { "lus", "\u0ea5\u0eb9\u0ec4\u0e8a" },
            { "luy", "\u0ea5\u0eb9\u0ec4\u0e8d" },
            { "mad", "\u0ea1\u0eb2\u0e94\u0eb9\u0ea5\u0eb2" },
            { "maf", "\u0ea1\u0eb2\u0e9f\u0eb2" },
            { "mag", "\u0ea1\u0eb2\u0e81\u0eb2\u0eae\u0eb4" },
            { "mai", "\u0ec4\u0ea1\u0e97\u0eb5\u0ea5\u0eb4" },
            { "mak", "\u0ea1\u0eb2\u0e81\u0eb2\u0e8a\u0eb2\u0ea3" },
            { "man", "\u0ea1\u0eb1\u0e99\u0e94\u0eb4\u0e87\u0e81\u0eb2" },
            { "mas", "\u0ea1\u0eb2\u0ec4\u0e8a" },
            { "mde", "\u0ea1\u0eb2\u0e9a\u0eb2" },
            { "mdf", "\u0ea1\u0ead\u0e81\u0e8a\u0eb2" },
            { "mdr", "\u0ea1\u0eb2\u0e99\u0e94\u0eb2\u0ea3" },
            { "men", metaValue_men },
            { "mer", "\u0ec0\u0ea1\u0ea3\u0eb9" },
            { "mfe", "\u0ea1\u0ecd\u0ea3\u0eb4\u0eaa\u0ec0\u0ea2\u0e99" },
            { "mga", "\u0ec4\u0ead\u0ea5\u0eb4\u0e94\u0e81\u0eb2\u0e87" },
            { "mgh", "\u0ea1\u0eb2\u0e84\u0eb9\u0ea7\u0eb2-\u0ea1\u0eb5\u0e94\u0ec2\u0e95" },
            { "mgo", "\u0ec0\u0ea1\u0e97\u0eb2" },
            { "mic", "\u0ea1\u0eb4\u0e81\u0ec1\u0ea1\u0e81" },
            { "min", "\u0e97\u0eb5\u0ec1\u0e99\u0e87\u0e81\u0eb2\u0e9a\u0eb9" },
            { "mnc", "\u0ec1\u0ea1\u0e99\u0e88\u0eb9" },
            { "mni", "\u0ea1\u0eb2\u0e99\u0eb5\u0e9e\u0eb9\u0ea3\u0eb4" },
            { "moe", "\u0ead\u0eb4\u0e99\u0e99\u0eb8\u0ec4\u0ead\u0ea1\u0eb1\u0e99" },
            { "moh", "\u0ec2\u0ea1\u0eab\u0eb2" },
            { "mos", "\u0ea1\u0ead\u0eaa\u0e8a\u0eb5" },
            { "mua", "\u0ea1\u0eb1\u0e99\u0e94\u0eb1\u0e87" },
            { "mul", "\u0eab\u0ea5\u0eb2\u0e8d\u0e9e\u0eb2\u0eaa\u0eb2" },
            { "mus", "\u0e84\u0ea3\u0eb4\u0e81" },
            { "mwl", "\u0ea1\u0eb5\u0ea5\u0eb1\u0e99\u0e94\u0eb2" },
            { "mwr", "\u0ea1\u0eb2\u0ea7\u0eb2\u0ea3\u0eb4" },
            { "mye", "\u0ea1\u0ecd\u0ea2\u0eb4\u0e99" },
            { "myv", "\u0ec0\u0ead\u0eb5\u0e8d\u0eb2" },
            { "mzn", "\u0ea1\u0eb2\u0ec1\u0e8a\u0e99\u0ec0\u0e94\u0eb5\u0ea5\u0eb1\u0e87" },
            { "nap", "\u0e99\u0eb2\u0ec2\u0e9b\u0ea5\u0eb5" },
            { "naq", "\u0e99\u0eb2\u0ea1\u0eb2" },
            { "nds", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99 \u0e95\u0ead\u0e99\u0ec4\u0e95\u0ec9" },
            { "new", "\u0e99\u0eb5\u0ea7\u0eb2\u0ea3\u0eb4" },
            { "nia", "\u0e99\u0eb5\u0ec8\u0ead\u0eb1\u0e94" },
            { "niu", "\u0e99\u0eb5\u0ec8\u0ead\u0eb9" },
            { "nmg", "\u0e81\u0ea7\u0eb2\u0e8a\u0eb5\u0ec2\u0ead" },
            { "nnh", "\u0e88\u0eb5\u0ec8\u0ea1\u0e9a\u0eb9\u0e99" },
            { "nog", "\u0e99\u0ecd\u0ec4\u0e81" },
            { "non", "\u0e99\u0ecd\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0ec2\u0e8a\u0ec2\u0e97\u0ec0\u0edc\u0eb7\u0ead" },
            { "nus", "\u0ec0\u0e99\u0eb5" },
            { "nwc", "\u0ec0\u0e99\u0ea7\u0eb2\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "nym", "\u0e99\u0eb2\u0ea1\u0ea7\u0eb5\u0e8a\u0eb4" },
            { "nyn", "\u0e99\u0eb2\u0e99\u0e84\u0ead\u0e99" },
            { "nyo", "\u0ec2\u0e99\u0ec2\u0ea3" },
            { "nzi", "\u0e99\u0eb4\u0ea1\u0eb2" },
            { "ojb", "\u0ec2\u0ead\u0e88\u0eb4\u0e9a\u0ea7\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81\u0eaa\u0ec8\u0ebd\u0e87\u0ec0\u0edc\u0eb7\u0ead" },
            { "ojc", "\u0ec2\u0ead\u0e88\u0eb4\u0e9a\u0ea7\u0eb2\u0e81\u0eb2\u0e87" },
            { "ojs", "\u0ec2\u0ead\u0e88\u0eb4\u0e84\u0ea3\u0eb5" },
            { "ojw", "\u0ec2\u0ead\u0e88\u0eb4\u0e9a\u0ea7\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "oka", "\u0ec2\u0ead\u0e81\u0eb0\u0e99\u0eb2\u0e81\u0eb1\u0e99" },
            { "osa", "\u0ec2\u0ead\u0ec1\u0e8a\u0e81" },
            { "ota", "\u0e95\u0eb9\u0e81\u0eb5\u0ead\u0ead\u0e94\u0ec2\u0e95\u0ea1\u0eb1\u0e99" },
            { "pag", "\u0e9b\u0eb2\u0e99\u0e81\u0eb2\u0e8a\u0eb5\u0ea1\u0eb2\u0e99" },
            { "pal", "\u0e9e\u0eb2\u0ea5\u0eb2\u0ea7\u0eb5" },
            { "pam", "\u0e9b\u0eb2\u0ea1\u0e9b\u0eb2\u0e99\u0e81\u0eb2" },
            { "pap", "\u0e9b\u0eb2\u0ea1\u0ec0\u0e9b\u0e8d\u0ec0\u0ea1\u0eb1\u0e99\u0ec2\u0e97" },
            { "pau", "\u0e9b\u0eb2\u0ea5\u0ebb\u0ea7\u0ead\u0eb2\u0e99" },
            { "pcm", "\u0ec4\u0e99\u0e88\u0eb5\u0ea3\u0ebd\u0e99\u0e9e\u0eb4\u0e94\u0e81\u0eb4\u0e99" },
            { "peo", "\u0ec0\u0e9b\u0eb5\u0ec0\u0e8a\u0e8d\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "phn", "\u0e9f\u0eb5\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "pis", "\u0e9b\u0eb4\u0e88\u0eb4\u0e99" },
            { "pon", "\u0e9e\u0ead\u0e99\u0ec0\u0e9e" },
            { "pqm", "\u0ea1\u0eb2\u0ea5\u0eb4\u0e8a\u0eb5\u0e94 \u0e9e\u0eb2\u0eaa\u0e8a\u0eb2\u0ea1\u0eb2\u0ec2\u0e84\u0e94\u0e94\u0eb5" },
            { "prg", "\u0e9b\u0ea3\u0eb1\u0eaa\u0e8a\u0ebd\u0e99" },
            { "pro", "\u0ec2\u0e9b\u0ea7\u0ead\u0e87\u0e8a\u0eb2\u0e99\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "quc", "K\u02bciche\u02bc" },
            { "raj", "\u0ea3\u0eb2\u0e88\u0eb1\u0eaa\u0e97\u0eb2\u0e99\u0eb4" },
            { "rap", "\u0ea3\u0eb2\u0e9b\u0eb2\u0e99\u0eb8\u0e8d" },
            { "rar", "\u0ea3\u0eb2\u0ec2\u0ea3\u0e97\u0ead\u0e99\u0e81\u0eb2\u0e99" },
            { "rhg", "\u0ec2\u0ea3\u0eae\u0eb4\u0e99\u0ea2\u0eb2" },
            { "rof", "\u0ea3\u0ebb\u0ea1\u0ec2\u0e9a" },
            { "rom", "\u0ec2\u0ea3\u0ec0\u0ea1\u0e99\u0eb5" },
            { "rup", "\u0ead\u0eb2\u0ec2\u0ea3\u0ea1\u0eb2\u0e99\u0ebd\u0e99" },
            { "rwk", "\u0ead\u0eb2\u0ea3\u0ea7\u0eb2" },
            { "sad", "\u0e8a\u0eb1\u0e99\u0e94\u0eb2\u0ea7" },
            { "sah", "\u0e8a\u0eb2\u0e81\u0eb2" },
            { "sam", "\u0eaa\u0eb2\u0ea1\u0eb2\u0ea3\u0eb4\u0ec1\u0e95\u0e99-" },
            { "saq", "\u0e8a\u0eb3\u0e9a\u0eb9\u0ea3\u0eb9" },
            { "sas", "\u0e8a\u0eb2\u0e8a\u0eb1\u0e81" },
            { "sat", "\u0e8a\u0eb2\u0e99\u0e97\u0eb2\u0ea5\u0eb4" },
            { "sba", "\u0e81\u0eb3\u0ec0\u0e9a" },
            { "sbp", "\u0e8a\u0eb2\u0e99\u0e81\u0eb9" },
            { "scn", "\u0e8a\u0eb5\u0e8a\u0eb4\u0ea5\u0eb5\u0e99" },
            { "sco", "\u0eaa\u0e81\u0ead\u0e94" },
            { "sdh", "\u0e9e\u0eb2\u0e81\u0ec4\u0e95\u0ec9 \u0e82\u0ead\u0e87 \u0e81\u0eb9\u0e94\u0eb4\u0e94" },
            { "see", "\u0e8a\u0eb5\u0e99\u0eb5\u0e81\u0eb2" },
            { "seh", "\u0e8a\u0eb5\u0e99\u0eb2" },
            { "sel", "\u0ec0\u0e8a\u0e99\u0e84\u0eb1\u0e9a" },
            { "ses", "\u0ec2\u0e84\u0e8d\u0ea3\u0eb2\u0ec2\u0e9a\u0ec2\u0ea3 \u0ec0\u0e8a\u0e99\u0e99\u0eb4" },
            { "sga", "\u0ead\u0eb5\u0ea3\u0eb4\u0e8a\u0ec0\u0e81\u0ebb\u0ec8\u0eb2" },
            { "shi", "\u0e97\u0eb2\u0ec0\u0e8a\u0ea7\u0eab\u0eb4\u0e94" },
            { "shn", "\u0e8a\u0eb2\u0e99" },
            { "shu", "\u0ead\u0eb2\u0ea5\u0eb1\u0e9a-\u0e8a\u0eb2\u0e94" },
            { "sid", "\u0e8a\u0eb4\u0e94\u0eb2\u0ec2\u0ea1" },
            { "slh", "\u0ea5\u0eb9\u0e8a\u0eb8\u0e94\u0e8a\u0eb5\u0e94\u0ec3\u0e95\u0ec9" },
            { "sma", "\u0e8a\u0eb2\u0ea1\u0eb4\u0ec3\u0e95\u0ec9" },
            { "smj", "\u0ea5\u0eb8\u0e99\u0e8a\u0eb2\u0ea1\u0eb4" },
            { "smn", "\u0ead\u0eb5\u0e99\u0eb2\u0ea3\u0eb4\u0e8a\u0eb2\u0ea1\u0eb4" },
            { "sms", "\u0eaa\u0e81\u0ead\u0e94\u0e8a\u0eb2\u0ea1\u0eb4" },
            { "snk", "\u0ec2\u0e8a\u0e99\u0eb4\u0e99\u0e81\u0eb5" },
            { "sog", "\u0e8a\u0ead\u0e81\u0e94\u0eb4\u0e99" },
            { "srn", "\u0eaa\u0ea3\u0eb2\u0e99\u0e99\u0eb2\u0e99\u0e95\u0ead\u0e99\u0ec2\u0e81" },
            { "srr", "\u0ec0\u0e8a\u0ec0\u0ea5\u0eb5" },
            { "ssy", metaValue_ssy },
            { "str", "\u0e8a\u0ec8\u0ead\u0e87\u0ec1\u0e84\u0e9a\u0ec0\u0e8a\u0ea5\u0eb5\u0e8a" },
            { "suk", "\u0e8a\u0eb9\u0e84\u0eb9\u0ea1\u0ec9\u0eb2" },
            { "sus", "\u0e8a\u0eb9\u0e8a\u0eb9" },
            { "sux", "\u0e8a\u0eb9\u0ec0\u0ea1\u0eb5\u0ec0\u0ea5\u0e8d" },
            { "swb", "\u0ec2\u0e84\u0ec2\u0e99\u0ea3\u0ebd\u0e99" },
            { "syc", "\u0e8a\u0eb5\u0ec0\u0ea5\u0e8d\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "syr", "\u0e8a\u0eb5\u0ec0\u0ea5\u0e8d" },
            { "tce", "\u0e97\u0eb8\u0e94\u0e8a\u0ead\u0e99\u0ec3\u0e95\u0ec9" },
            { "tem", "\u0e97\u0eb5\u0ea1\u0ec0\u0e99" },
            { "teo", "\u0ec0\u0e95\u0ec2\u0e8a" },
            { "ter", "\u0ec0\u0e95\u0ec0\u0ea5\u0ec2\u0e99" },
            { "tet", "\u0ec0\u0e95\u0e95\u0eb9\u0ea1" },
            { "tgx", "\u0e97\u0eb2\u0e81\u0eb5\u0e8a" },
            { "tht", "\u0e97\u0eb2\u0ea7\u0e97\u0eb1\u0e99" },
            { "tig", "\u0ec4\u0e97\u0e81\u0ea3\u0eb5" },
            { "tiv", "\u0e95\u0eb5\u0ea7" },
            { "tkl", metaValue_TK },
            { "tlh", "\u0e84\u0ea3\u0eb4\u0e87\u0e81\u0ead\u0e99" },
            { "tli", "\u0e97\u0ea5\u0eb5\u0e87\u0e81\u0eb4\u0e94" },
            { "tmh", "\u0e97\u0eb2\u0ea1\u0eb2\u0e81\u0ec0\u0e8a\u0e81" },
            { "tog", "\u0e99\u0eb2\u0e8d\u0ead\u0eb2\u0e8a\u0eb2\u0e95\u0ead\u0e87\u0e81\u0eb2" },
            { "tok", "\u0ec2\u0e97\u0e81\u0eb5\u0ec2\u0e9e\u0e99\u0eb2" },
            { "tpi", "\u0e97\u0ead\u0e81\u0e9e\u0eb5\u0e8a\u0eb4\u0e99" },
            { "trv", "\u0e95\u0eb2\u0ec2\u0ea5\u0ec2\u0e81" },
            { "tsi", "\u0e8a\u0eb5\u0ea1\u0e8a\u0eb5\u0ec1\u0ead\u0e99" },
            { "ttm", "\u0e97\u0eb1\u0e94\u0ec2\u0e88\u0e99\u0ec0\u0ec0\u0edc\u0eb7\u0ead" },
            { "tum", "\u0e95\u0eb3\u0e9a\u0eb9\u0e81\u0eb2" },
            { "tvl", metaValue_TV },
            { "twq", "\u0e95\u0eb2\u0e8a\u0eb2\u0ea7\u0eb1\u0e81" },
            { "tyv", "\u0e95\u0eb9\u0ea7\u0eb5\u0e99\u0ebd\u0e99" },
            { "tzm", "\u0ead\u0eb1\u0e94\u0ea5\u0eb2\u0eaa \u0e97\u0eb2\u0ea1\u0eb2\u0e8a\u0eb5\u0e81 \u0e81\u0eb2\u0e87" },
            { "udm", "\u0ead\u0eb8\u0e94\u0ea1\u0eb1\u0e94" },
            { "uga", "\u0ea2\u0eb9\u0e81\u0eb2\u0ea5\u0eb4\u0e81" },
            { "umb", "\u0ead\u0eb3\u0e9a\u0eb1\u0e99\u0e94\u0eb9" },
            { "und", "\u0e9a\u0ecd\u0ec8\u0eaa\u0eb2\u0ea1\u0eb2\u0e94\u0ea5\u0eb0\u0e9a\u0eb8\u0e9e\u0eb2\u0eaa\u0eb2" },
            { "vai", metaValue_vai },
            { "vot", "\u0ec2\u0ea7\u0e95\u0eb4\u0e81" },
            { "vun", "\u0ea7\u0eb1\u0e99\u0ec2\u0e88" },
            { "wae", "\u0ea7\u0eb2\u0ec0\u0e8a\u0eb5" },
            { "wal", "\u0ea7\u0eb2\u0ea5\u0eb2\u0ec2\u0ea1" },
            { "war", "\u0ea7\u0eb2\u0ec0\u0ea5" },
            { "was", "\u0ea7\u0eb2\u0ec2\u0e8a" },
            { "wbp", "\u0ea7\u0eb2\u0ea3\u0e9e\u0eb4\u0ea3\u0eb4" },
            { "wuu", "\u0e88\u0eb5\u0e99\u0ead\u0eb9" },
            { "xal", "\u0e81\u0eb2\u0e99\u0ea1\u0eb4\u0e81" },
            { "xog", "\u0ec2\u0e8a\u0e81\u0eb2" },
            { "yao", "\u0ec0\u0ea2\u0ebb\u0ec9\u0eb2" },
            { "yap", "\u0ea2\u0eb1\u0e9a" },
            { "yav", "\u0ec1\u0e8d\u0e87\u0ec0\u0e9a\u0e99" },
            { "ybb", "\u0ec1\u0ea2\u0ea1\u0e9a\u0eb2" },
            { "yrl", "\u0e99\u0eb5\u0e99\u0e81\u0eb2\u0e95\u0eb9" },
            { "yue", "\u0e81\u0ea7\u0eb2\u0e87\u0e95\u0eb8\u0ec9\u0e87" },
            { "zap", "\u0e8a\u0eb2\u0ec2\u0e9b\u0ec1\u0e95\u0e9a" },
            { "zbl", "\u0eaa\u0eb1\u0e99\u0e8d\u0eb2\u0ea5\u0eb1\u0e81\u0e9a\u0ea5\u0eb5\u0e8a\u0eb4\u0ea1" },
            { "zen", "\u0ec0\u0e8a\u0e99\u0eb2\u0e81\u0eb2" },
            { "zgh", "\u0ec2\u0ea1\u0ea3\u0eb1\u0ead\u0e81\u0ec1\u0e84\u0e99 \u0e97\u0eb2\u0ea1\u0eb2\u0e8a\u0eb5\u0e81 \u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99" },
            { "zun", "\u0e8a\u0eb9\u0e99\u0eb5" },
            { "zxx", "\u0e9a\u0ecd\u0ec8\u0ea1\u0eb5\u0ec0\u0e99\u0eb7\u0ec9\u0ead\u0eab\u0eb2\u0e9e\u0eb2\u0eaa\u0eb2" },
            { "zza", "\u0e8a\u0eb2\u0e8a\u0eb2" },
            { "Adlm", "\u0ec1\u0ead\u0e94\u0ea5\u0eb2\u0ea1" },
            { "Afak", "\u0ead\u0eb1\u0e9a\u0e9f\u0eb2\u0e81\u0eb2" },
            { "Arab", "\u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81" },
            { "Aran", "\u0e99\u0eb2\u0eaa\u0e95\u0ecd\u0ea5\u0eb4\u0e81 (\u0e84\u0eb3\u0ec3\u0e9a\u0ec9\u0e81\u0eb2\u0e99\u0ec1\u0e9b: \u0ea5\u0eb0\u0eab\u0eb1\u0e94\u0e9e\u0eb4\u0ec0\u0eaa\u0e94\u0e81\u0eb3\u0e99\u0ebb\u0e94\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0e95\u0ebb\u0ea7\u0edc\u0eb1\u0e87\u0eaa\u0eb7\u0ead\u0eb2\u0ea3\u0eb1\u0e9a.)" },
            { "Armi", "\u0ead\u0eb4\u0ea1\u0e9e\u0eb5\u0eae\u0ebd\u0e99 \u0ead\u0eb2\u0ec0\u0ea1\u0ead\u0eb4\u0e81" },
            { "Armn", metaValue_hy },
            { "Avst", "\u0ead\u0eb0\u0ec0\u0ea7\u0eaa\u0e95\u0eb0" },
            { "Bali", "\u0e9a\u0eb2\u0ea5\u0eb5" },
            { "Bamu", "\u0e9a\u0eb2\u0ea1\u0eb9\u0ea1" },
            { "Bass", "\u0e9a\u0eb1\u0e94\u0e8a\u0eb2" },
            { "Batk", "\u0e9a\u0eb2\u0e95\u0eb1\u0e81" },
            { "Beng", "\u0ec0\u0e9a\u0eb1\u0e87\u0e81\u0eb2" },
            { "Blis", "\u0e9a\u0ea5\u0eb4\u0e81\u0e8a\u0eb4\u0ea1\u0ec2\u0e9a\u0ea5\u0eaa" },
            { "Bopo", "\u0e88\u0eb9\u0ec9\u0ead\u0eb4\u0e99" },
            { "Brah", "\u0e9e\u0eae\u0eb2\u0eab\u0ea1\u0eb5" },
            { "Brai", "\u0ec0\u0e9a\u0ea3\u0ea7" },
            { "Bugi", "\u0e9a\u0eb9\u0e81\u0eb4\u0eaa" },
            { "Buhd", "\u0e9a\u0eb9\u0eae\u0eb4\u0e94" },
            { "Cakm", "\u0e8a\u0eb2\u0e81\u0ea1\u0eb2" },
            { "Cans", "\u0eaa\u0eb1\u0e99\u0e8d\u0eb2\u0ea5\u0eb1\u0e81\u0e8a\u0ebb\u0e99\u0ec0\u0e9c\u0ebb\u0ec8\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0ec1\u0e84\u0e99\u0e99\u0eb2\u0e94\u0eb2" },
            { "Cari", "\u0e84\u0eb2\u0ec0\u0eae\u0e8d" },
            { "Cham", "\u0e88\u0eb2\u0ea1" },
            { "Cher", "\u0ec0\u0e8a\u0ec2\u0eae\u0e81\u0eb5" },
            { "Cirt", "\u0ec0\u0e8a\u0eb5\u0eae" },
            { "Copt", metaValue_cop },
            { "Cprt", "\u0ec4\u0e8a\u0ec0\u0e9b\u0e8d" },
            { "Cyrl", "\u0e8a\u0eb5\u0ea3\u0eb4\u0ea7\u0ea5\u0eb4\u0e81" },
            { "Cyrs", "\u0ec0\u0e8a\u0eae\u0eb1\u0e94\u0eaa\u0ea5\u0eb2 \u0ec2\u0ea7\u0e99\u0eb4\u0e81\u0e8a\u0eb5\u0eae\u0eb4\u0e81\u0ea5\u0eb4\u0e81\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Deva", "\u0e94\u0eb5\u0ea7\u0eb2\u0e99\u0eb2\u0e81\u0eb2\u0ea3\u0eb5" },
            { "Dsrt", "\u0ec0\u0e94\u0ec0\u0e8a\u0ec0\u0eae" },
            { "Dupl", "\u0e8a\u0ebb\u0ea7\u0ec0\u0ea5\u0e94\u0eb1\u0e9a\u0ec2\u0ea5\u0e8d\u0eb1\u0e99" },
            { "Egyd", "\u0e94\u0eb5\u0ec2\u0ea1\u0e95\u0eb4\u0e81\u0ead\u0eb5\u0e8d\u0eb4\u0e9a" },
            { "Egyh", "\u0ec0\u0eae\u0e8d\u0eae\u0eb2\u0e95\u0eb4\u0e81\u0ead\u0eb5\u0e8d\u0eb4\u0e9a" },
            { "Egyp", "\u0ec0\u0eae\u0e8d\u0ec2\u0eae\u0e81\u0ea5\u0eb4\u0e9f\u0ead\u0eb5\u0e8d\u0eb4\u0e9a" },
            { "Ethi", "\u0ead\u0eb5\u0e97\u0eb4\u0ec2\u0ead\u0e9b\u0eb4\u0e81" },
            { "Geok", "\u0e84\u0ead\u0e94\u0e8a\u0eb9\u0eae\u0eb5\u0e88\u0ecd\u0ec0\u0e88\u0e8d" },
            { "Geor", metaValue_ka },
            { "Glag", "\u0e81\u0ea5\u0eb2\u0ec2\u0e81\u0ea5\u0eb4\u0e95\u0eb4\u0e81" },
            { "Goth", "\u0ec2\u0e81\u0eae\u0eb4\u0e81" },
            { "Gran", "\u0ec0\u0e84\u0e99\u0e97\u0eb2" },
            { "Grek", metaValue_el },
            { "Gujr", "\u0e88\u0eb9\u0e88\u0eb2\u0ea3\u0eb2\u0e97\u0eb5" },
            { "Guru", "\u0e81\u0ebb\u0ea7\u0ea1\u0eb9\u0e84\u0eb5" },
            { "Hanb", "\u0eae\u0eb1\u0e99" },
            { "Hang", "\u0eae\u0eb1\u0e99\u0e81\u0eb9\u0e99" },
            { "Hani", "\u0eae\u0eb2\u0e99" },
            { "Hano", "\u0eae\u0eb2\u0e99\u0eb9\u0ec2\u0e99\u0ec2\u0ead" },
            { "Hans", "\u0ec1\u0e9a\u0e9a\u0eae\u0ebd\u0e9a\u0e87\u0ec8\u0eb2\u0e8d" },
            { "Hant", "\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0ea3\u0eb4\u0ea3\u0eb0\u0e87\u0eb0\u0e99\u0eb0" },
            { "Hluw", "\u0ead\u0eb1\u0e81\u0ea5\u0eae\u0eb0\u0ead\u0eb2\u0e99\u0eb2\u0ec2\u0e95\u0ec0\u0ea5\u0e8d" },
            { "Hmng", "\u0e9b\u0eb2\u0ec0\u0eae\u0eb2\u0ec0\u0ea1\u0eb1\u0e87" },
            { "Hrkt", "\u0e95\u0eb2\u0e95\u0eb2\u0ea5\u0eb2\u0e87\u0e9e\u0eb0\u0e8d\u0eb2\u0e87\u0e9e\u0eb2\u0eaa\u0eb2\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99" },
            { "Hung", "\u0eae\u0eb1\u0e87\u0e81\u0eb2\u0eae\u0eb5\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Inds", "\u0ead\u0eb4\u0e99\u0e94\u0eb1\u0e94" },
            { "Ital", "\u0ead\u0eb5\u0e95\u0eb2\u0ea5\u0eb5\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Jamo", "\u0e88\u0eb2\u0ec2\u0ea1" },
            { "Java", "\u0e88\u0eb2\u0ea7\u0eb2" },
            { "Jpan", metaValue_JP },
            { "Jurc", "\u0e88\u0eb9\u0eae\u0ec0\u0e8a\u0eb1\u0e99" },
            { "Kali", "\u0e84\u0e8d\u0eb2" },
            { "Kana", "\u0e84\u0eb0\u0e95\u0eb0\u0e81\u0eb0\u0e99\u0eb0" },
            { "Khar", "\u0e82\u0ecd\u0ec2\u0eae\u0e81\u0eaa\u0eb5" },
            { "Khmr", "\u0e82\u0eb0\u0ec1\u0ea1" },
            { "Khoj", "\u0e84\u0ecd\u0e88\u0e84\u0eb5" },
            { "Knda", metaValue_kn },
            { "Kore", "\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ebc\u0eb5" },
            { "Kpel", "\u0ec0\u0e9b\u0ea5\u0ec0\u0ea5" },
            { "Kthi", "\u0e81\u0eb2\u0e8d\u0e95\u0eb4" },
            { "Lana", "\u0ea5\u0ec9\u0eb2\u0e99\u0e99\u0eb2" },
            { "Laoo", metaValue_LA },
            { "Latf", "\u0ea5\u0eb2\u0e95\u0eb4\u0e99-\u0e9f\u0eae\u0eb1\u0ec8\u0e87\u0ec0\u0e95\u0ea3" },
            { "Latg", "\u0ea5\u0eb2\u0e95\u0eb4\u0e99-\u0ec1\u0e81\u0ea5\u0eb4\u0e81" },
            { "Latn", metaValue_la },
            { "Lepc", "\u0ec0\u0ea5\u0e8a\u0eb2" },
            { "Limb", "\u0ea5\u0eb4\u0ea1\u0e9a\u0eb9" },
            { "Lina", "\u0ea5\u0eb5\u0ec0\u0e99\u0e8d" },
            { "Linb", "\u0ea5\u0eb5\u0ec0\u0e99\u0e8d\u0ea3" },
            { "Lisu", "\u0ec0\u0e9f\u0ea3\u0ec0\u0e8a\u0eae" },
            { "Loma", "\u0ec2\u0ea5\u0ea1\u0eb2" },
            { "Lyci", "\u0ec4\u0ea5\u0ec0\u0e8a\u0e8d" },
            { "Lydi", "\u0ea5\u0eb5\u0ec0\u0e94\u0e8d" },
            { "Mand", "\u0ec1\u0ea1\u0e99\u0e94\u0ebd\u0e99" },
            { "Mani", "\u0ea1\u0eb2\u0e99\u0eb4\u0ec1\u0e8a\u0e99" },
            { "Maya", "\u0ea1\u0eb2\u0e8d\u0eb2\u0ec4\u0eae\u0ec2\u0eae\u0e81\u0ea5\u0eb4\u0e9a" },
            { "Mend", metaValue_men },
            { "Merc", "\u0ec0\u0e84\u0ec0\u0ea5\u0eb5\u0e8a\u0eb5\u0ec0\u0ea1\u0ec2\u0eae\u0ead\u0eb4\u0e95\u0eb4\u0e81" },
            { "Mero", "\u0ec0\u0ea1\u0ec2\u0eae\u0e95\u0eb4\u0e81" },
            { "Mlym", "\u0ea1\u0eb2\u0ec0\u0ea5\u0ea2\u0eb2\u0ea5\u0eb2\u0ea1" },
            { "Mong", "\u0ea1\u0ebb\u0e87\u0ec2\u0e81\u0e99" },
            { "Moon", "\u0ea1\u0eb9\u0e99" },
            { "Mroo", "\u0ec0\u0ea1\u0ec2\u0eae" },
            { "Mtei", "\u0ec0\u0ea1\u0ec0\u0e97\u0ea1\u0eb2\u0ec0\u0e8d\u0e81" },
            { "Mymr", metaValue_my },
            { "Narb", "\u0ead\u0eb2\u0eae\u0eb0\u0ec0\u0e9a\u0e8d\u0ec0\u0edc\u0eb7\u0ead\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Nbat", "\u0e99\u0eb2\u0e9a\u0eb2\u0e97\u0eb2\u0e97\u0ebd\u0e99" },
            { "Nkgb", "\u0e81\u0eb5\u0e9a\u0eb2-\u0e99\u0eb2\u0e8a\u0eb5" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "\u0e99\u0eb8\u0e8a\u0eb8" },
            { "Ogam", "\u0ead\u0ead\u0e81\u0e84\u0ead\u0e99" },
            { "Olck", "\u0ec2\u0ead\u0e8a\u0eb4\u0e81\u0eb4" },
            { "Orkh", "\u0ead\u0ead\u0e81\u0eaa\u0ea1\u0eb1\u0e99\u0e8d\u0eb2" },
            { "Orya", "\u0ec2\u0ead\u0ec0\u0e94\u0e8d" },
            { "Palm", "\u0e9e\u0eb2\u0ea5\u0ec4\u0ea1\u0eae\u0eb4\u0e99" },
            { "Perm", "\u0ec0\u0e9e\u0eb5\u0ea1\u0eb5\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Phag", "\u0e9f\u0eb2\u0e81\u0eaa-\u0e9b\u0eb2" },
            { "Phli", "\u0e9b\u0eb0\u0eab\u0ea5\u0eb2\u0ea7\u0eb5\u0ead\u0eb4\u0e99\u0eaa\u0e84\u0eb4\u0e9a\u0e8a\u0eb1\u0e99\u0ec1\u0e99\u0ea5" },
            { "Phlp", "\u0e9b\u0eb0\u0eab\u0ea5\u0eb2\u0ea7\u0eb5\u0e8a\u0ead\u0e94\u0ec0\u0e95\u0eae\u0ecc" },
            { "Phlv", "\u0e9b\u0eb0\u0eab\u0ea5\u0eb2\u0ea7\u0eb5\u0e9a\u0eb8\u0e81" },
            { "Phnx", "\u0e9f\u0eb5\u0e99\u0eb4\u0ec0\u0e8a\u0e8d" },
            { "Plrd", "\u0eaa\u0eb1\u0e94\u0e95\u0eb0\u0eaa\u0eb2\u0e94\u0e9e\u0ecd\u0eae\u0ea5\u0eb2" },
            { "Prti", "\u0e9e\u0eb2\u0eae\u0ecc\u0ec0\u0e97\u0e8d\u0ead\u0eb4\u0e99\u0eaa\u0e84\u0eae\u0eb4\u0e9b\u0e8a\u0eb1\u0e99\u0ec1\u0e99\u0ea5" },
            { "Rjng", "\u0ec0\u0eae\u0e88\u0eb1\u0e87" },
            { "Rohg", "\u0eae\u0eb2\u0e99\u0eb4\u0e9f\u0eb5" },
            { "Roro", "\u0eae\u0ead\u0e87\u0ec2\u0e81\u0eae\u0ead\u0e87\u0ec2\u0e81" },
            { "Runr", "\u0eae\u0eb9\u0e99\u0eb4\u0e81" },
            { "Samr", "\u0e8a\u0eb2\u0ea1\u0eb2\u0ec0\u0ea5\u0e8d" },
            { "Sara", "\u0e8a\u0eb2\u0eae\u0eb2\u0e95\u0eb4" },
            { "Sarb", "\u0ead\u0eb2\u0ea5\u0eb0\u0ec0\u0e9a\u0e8d\u0ec3\u0e95\u0ec9\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Saur", "\u0ec2\u0eaa\u0eae\u0eb1\u0e94\u0e95\u0ea3\u0eb0" },
            { "Sgnw", "\u0ec4\u0e8a\u0e99\u0ecc\u0ec4\u0eae\u0e95\u0eb5\u0ec9\u0e87" },
            { "Shaw", "\u0e8a\u0ead\u0ea7\u0ebd\u0e99" },
            { "Shrd", "\u0e8a\u0eb2\u0eae\u0eb2\u0e94\u0eb2" },
            { "Sind", "\u0e94\u0eb8\u0e94\u0eb2\u0ea7\u0eb2\u0e94\u0eb5" },
            { "Sinh", metaValue_si },
            { "Sora", "\u0ec2\u0eaa\u0eae\u0eb2\u0eaa\u0ebb\u0ea1\u0ec0\u0e9b\u0eb1\u0e87" },
            { "Sund", "\u0e8a\u0eb8\u0e99\u0e94\u0eb2" },
            { "Sylo", "\u0e8a\u0eb5\u0ec2\u0ea5\u0e95\u0eb4\u0e99\u0eb2\u0e81\u0ea3\u0eb5" },
            { "Syrc", "\u0e8a\u0eb5\u0ec0\u0eae\u0e8d" },
            { "Syre", "\u0e8a\u0eb5\u0ec0\u0eae\u0e8d\u0ec0\u0ead\u0eaa\u0e97\u0eae\u0eb2\u0e99\u0e88\u0eb5\u0ec2\u0ea5" },
            { "Syrj", "\u0e8a\u0eb5\u0ec0\u0eae\u0e8d\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "Syrn", "\u0e8a\u0eb5\u0ec0\u0eae\u0e8d\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "Tagb", "\u0e95\u0eb1\u0e81\u0e9a\u0eb1\u0e99\u0ea7\u0eb2" },
            { "Takr", "\u0e97\u0eb2\u0e84\u0eae\u0eb5" },
            { "Tale", "\u0ec4\u0e97\u0ec0\u0ea5" },
            { "Talu", "\u0ec4\u0e97\u0ea5\u0eb7\u0ec9\u0ec3\u0edd\u0ec8" },
            { "Taml", metaValue_ta },
            { "Tang", "\u0e95\u0eb1\u0e99\u0e81\u0eb1\u0e99" },
            { "Tavt", "\u0ec4\u0e97\u0eab\u0ea7\u0ebd\u0e94" },
            { "Telu", "\u0ec0\u0e97\u0ea5\u0eb9\u0e81\u0eb9" },
            { "Teng", "\u0ec0\u0e97\u0e87\u0e81\u0ea7\u0eb2\u0eae" },
            { "Tfng", "\u0e97\u0eb5\u0e9f\u0eb5\u0e99\u0eb2\u0e81" },
            { "Tglg", metaValue_tl },
            { "Thaa", "\u0e97\u0eb2\u0e99\u0eb2" },
            { "Thai", metaValue_TH },
            { "Tibt", metaValue_bo },
            { "Tirh", "\u0ec0\u0e97\u0eae\u0eb8\u0e97\u0eb2" },
            { "Ugar", "\u0e8d\u0eb9\u0e81\u0eb2\u0eae\u0eb4\u0e94" },
            { "Vaii", metaValue_vai },
            { "Visp", "\u0e84\u0eb3\u0ec0\u0ea7\u0ebb\u0ec9\u0eb2\u0e97\u0eb5\u0ec8\u0ec0\u0e9a\u0eb5\u0ec8\u0e87\u0ec0\u0eab\u0eb1\u0e99\u0ec4\u0e94\u0ec9" },
            { "Wara", "\u0ea7\u0eb2\u0eae\u0eb1\u0e87\u0e81\u0eaa\u0eb4\u0e95\u0eb4" },
            { "Wole", "\u0ec2\u0ead\u0ea5\u0eb5\u0ec0\u0ead" },
            { "Xpeo", "\u0ec0\u0e9b\u0eae\u0ec0\u0e8a\u0e8d\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Xsux", "\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0eae\u0eb9\u0e9a\u0e9b\u0ea5\u0eb5\u0ec8\u0ea1\u0eaa\u0eb8\u0ec0\u0ea1\u0ec0\u0eae\u0e8d-\u0ead\u0eb1\u0e94\u0e84\u0eb2\u0ec0\u0e94\u0e8d" },
            { "Yiii", "\u0e8d\u0eb5" },
            { "Zinh", "\u0ead\u0eb4\u0e99\u0ec0\u0eae\u0eae\u0eb4\u0e94" },
            { "Zmth", "\u0ec0\u0e84\u0eb7\u0ec8\u0ead\u0e87\u0edd\u0eb2\u0e8d\u0e97\u0eb2\u0e87\u0e84\u0eb0\u0e99\u0eb4\u0e94\u0eaa\u0eb2\u0e94" },
            { "Zsye", "\u0ead\u0eb5\u0ec2\u0ea1\u0e88\u0eb4" },
            { "Zsym", "\u0eaa\u0eb1\u0e99\u0e8d\u0eb2\u0ea5\u0eb1\u0e81" },
            { "Zxxx", "\u0e9a\u0ecd\u0ec8\u0ea1\u0eb5\u0e9e\u0eb2\u0eaa\u0eb2\u0e82\u0ebd\u0e99" },
            { "Zyyy", "\u0eaa\u0eb2\u0ea1\u0eb1\u0e99" },
            { "Zzzz", "\u0ec1\u0e9a\u0e9a\u0e82\u0ebd\u0e99\u0e97\u0eb5\u0ec8\u0e9a\u0ecd\u0ec8\u0eae\u0eb9\u0ec9\u0e88\u0eb1\u0e81" },
            { "de_AT", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99 (\u0ec2\u0ead\u0eaa\u0e95\u0ea3\u0eb4\u0e94)" },
            { "de_CH", "\u0eaa\u0eb0\u0ea7\u0eb4\u0eaa \u0ec4\u0eae \u0ec0\u0e88\u0eb5\u0ec1\u0ea1\u0e99" },
            { "en_GB", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94 (\u0e9a\u0ea3\u0eb4\u0e94\u0e97\u0eb4\u0e8a)" },
            { "en_US", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94 (\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb1\u0e99)" },
            { "es_ES", "\u0eaa\u0eb0\u0ec0\u0e9b\u0eb1\u0e99 \u0ea2\u0eb8\u0ec2\u0ea3\u0e9a" },
            { "es_MX", "\u0ec0\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0e81\u0eb1\u0e99 \u0eaa\u0eb0\u0ec1\u0e9b\u0e99\u0e99\u0eb4\u0e8a" },
            { "fa_AF", "\u0e94\u0eb2\u0ea3\u0eb5" },
            { "fr_CH", "\u0e9d\u0ea3\u0eb1\u0ec8\u0e87 (\u0eaa\u0ea7\u0eb4\u0eaa)" },
            { "nl_BE", "\u0e9f\u0ea5\u0eb5\u0ea1\u0eb4\u0e8a" },
            { "pt_BR", "\u0e9b\u0ead\u0e81\u0e95\u0eb8\u0e8d\u0e81\u0eb4\u0eaa \u0e9a\u0eb0\u0ec0\u0ea5\u0e8a\u0eb5\u0ec8\u0e99" },
            { "pt_PT", "\u0e9b\u0ead\u0e81\u0e95\u0eb8\u0e8d\u0e81\u0eb4\u0eaa \u0ea2\u0eb8\u0ec2\u0ea3\u0e9a" },
            { "ro_MD", "\u0ec2\u0ea1\u0e94\u0eb2\u0ea7\u0ebd\u0e99" },
            { "sw_CD", "\u0e84\u0ead\u0e87\u0ec2\u0e81 \u0e8a\u0ea7\u0eb2\u0eae\u0eb5\u0ea5\u0eb4" },
            { "%%1901", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99\u0ead\u0ecd\u0ec2\u0e97\u0e81\u0ea3\u0eb2\u0e9f\u0eb5\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "%%1994", "\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec0\u0ea3\u0e8a\u0ec8\u0ebd\u0e99\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99" },
            { "%%1996", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99\u0ead\u0ecd\u0ec2\u0e97\u0e81\u0ea3\u0eb2\u0e9f\u0eb5\u0e9b\u0eb51996" },
            { "ar_001", "\u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99\u0eaa\u0eb0\u0ec4\u0edd\u0ec3\u0edd\u0ec8" },
            { "es_419", "\u0ea5\u0eb2\u0e95\u0eb4\u0e99 \u0ead\u0eb2\u0ec0\u0ea1\u0ea3\u0eb4\u0e81\u0eb1\u0e99 \u0eaa\u0eb0\u0ec1\u0e9b\u0e99\u0e99\u0eb4\u0e8a" },
            { "key.ca", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99" },
            { "key.cf", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99" },
            { "key.co", "\u0eae\u0ebd\u0e87\u0ea5\u0eb3\u0e94\u0eb1\u0e9a" },
            { "key.cu", "\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99" },
            { "key.hc", "\u0eae\u0ead\u0e9a\u0ea7\u0ebd\u0e99\u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87( 12 \u0eab\u0ebc\u0eb7 24)" },
            { "key.lb", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0ec0\u0eaa\u0eb1\u0ec9\u0e99\u0e82\u0eb1\u0ec9\u0e99" },
            { "key.ms", "\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0e81\u0eb2\u0e99\u0ea7\u0eb1\u0e94\u0ec1\u0e97\u0e81" },
            { "key.nu", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81" },
            { "nds_NL", "\u0e8a\u0eb2\u0e8a\u0ead\u0e99 \u0e95\u0ead\u0e99\u0ec4\u0e95" },
            { "%%ALUKU", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0ead\u0ea5\u0eb9\u0e84\u0eb8" },
            { "%%BISKE", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e8a\u0eb2\u0e99\u0e88\u0eb4\u0ec2\u0ead\u0ec2\u0e88/\u0e9a\u0eb4\u0ea5\u0eb2" },
            { "%%BOONT", "\u0e9a\u0eb9\u0e99\u0e97\u0ea5\u0eb4\u0ec8\u0e87" },
            { "%%JAUER", "\u0ec0\u0e8d\u0ebb\u0eb2\u0ec0\u0ead\u0eb5" },
            { "%%KKCOR", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0eaa\u0eb2\u0ea1\u0eb1\u0e99" },
            { "%%LIPAW", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0ea5\u0eb4\u0ec2\u0e9e\u0ea7\u0eb2\u0e8a\u0ecc\u0e82\u0ead\u0e87\u0ec0\u0ea3\u0e8a\u0ec8\u0ebd\u0e99" },
            { "%%NEDIS", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e99\u0eb2\u0e97\u0eb4\u0ec2\u0e8a\u0ec0\u0e99" },
            { "%%NJIVA", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e88\u0eb5\u0ea7\u0eb2/\u0e99\u0eb5\u0ea7\u0eb2" },
            { "%%OSOJS", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0ec2\u0ead\u0e8a\u0ebd\u0e81\u0ec2\u0e84/\u0ec2\u0ead\u0ec2\u0e8a\u0e8d\u0eb2\u0ec0\u0e99" },
            { "%%POSIX", "\u0e84\u0ead\u0ea1\u0e9e\u0eb4\u0ea7\u0ec0\u0e95\u0eb5" },
            { "%%PUTER", "\u0e9e\u0eb4\u0ea7\u0ec0\u0e95\u0eb5" },
            { "%%ROZAJ", "\u0ec0\u0ea3\u0e8a\u0ec8\u0ebd\u0e99" },
            { "%%RUMGR", "\u0ea3\u0eb3\u0e81\u0ea3\u0ecc" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0eaa\u0eb0\u0ec2\u0e95\u0ea7\u0eb4\u0e8a\u0ecc\u0e8a\u0ec8\u0eb2/\u0ec2\u0e8a\u0ea5\u0ecc\u0e9a\u0eb5\u0e81\u0eb2" },
            { "%%UCCOR", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0ec1\u0e9a\u0e9a\u0e84\u0ebb\u0e9a\u0ea7\u0ebb\u0e87\u0e88\u0ead\u0e99" },
            { "zh_Hans", "\u0e88\u0eb5\u0e99\u0ec1\u0e9a\u0e9a\u0eae\u0ebd\u0e9a\u0e87\u0ec8\u0eb2\u0e8d" },
            { "zh_Hant", "\u0e88\u0eb5\u0e99\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "%%FONIPA", "\u0eaa\u0eb1\u0e94\u0e97\u0eb0\u0eaa\u0eb2\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0eaa\u0eb2\u0e81\u0ebb\u0e99" },
            { "%%FONUPA", "\u0eaa\u0eb1\u0e94\u0e97\u0eb0\u0eaa\u0eb2\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99 UPA" },
            { "%%NDYUKA", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e94\u0eb4\u0ea7\u0e84\u0eb2" },
            { "%%PAMAKA", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e9e\u0eb2\u0ea1\u0eb2\u0e84\u0eb2" },
            { "%%PINYIN", "\u0e9e\u0eb4\u0e99\u0ea2\u0eb4\u0e99" },
            { "%%SCOUSE", "\u0eaa\u0eb0\u0ec0\u0e81\u0ebb\u0eb2\u0eaa\u0ecc" },
            { "%%TARASK", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0e97\u0eb2\u0ea3\u0eb2\u0e8a\u0ecc\u0ec0\u0e84\u0e8d\u0ea7\u0eb4\u0e81\u0eb2" },
            { "%%UCRCOR", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0eaa\u0eb0\u0e9a\u0eb1\u0e9a\u0e9b\u0eb1\u0e9a\u0e9b\u0eb8\u0e87\u0ec1\u0e9a\u0e9a\u0e84\u0ebb\u0e9a\u0ea7\u0ebb\u0e87\u0e88\u0ead\u0e99" },
            { "%%ULSTER", "\u0ead\u0eb1\u0ea5\u0eaa\u0eb0\u0ec0\u0e95\u0eb5" },
            { "%%ALALC97", "\u0e81\u0eb2\u0e99\u0e96\u0ead\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec0\u0e9b\u0eb1\u0e99\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec2\u0ea3\u0ea1\u0eb1\u0e99\u0e95\u0eb2\u0ea1\u0ec0\u0e81\u0e99\u0e82\u0ead\u0e87\u0eaa\u0eb0\u0ea1\u0eb2\u0e84\u0ebb\u0ea1\u0eab\u0ec9\u0ead\u0e87\u0eaa\u0eb0\u0edd\u0eb8\u0e94\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2\u0ec1\u0ea5\u0eb0\u0eab\u0ec9\u0ead\u0e87\u0eaa\u0eb0\u0edd\u0eb8\u0e94\u0ea5\u0eb1\u0e94\u0e96\u0eb0\u0eaa\u0eb0\u0e9e\u0eb2 \u0eaa\u0eb0\u0e9a\u0eb1\u0e9a\u0e9e\u0eb4\u0ea1\u0e9b\u0eb5 1997" },
            { "%%AREVELA", "\u0ead\u0eb2\u0ec0\u0ea1\u0ec0\u0e99\u0e8d\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "%%AREVMDA", "\u0ead\u0eb2\u0ec0\u0ea1\u0ec0\u0e99\u0e8d\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "%%BAUDDHA", "\u0e9e\u0eb0\u0e9e\u0eb8\u0e94\u0e97\u0eb0\u0ec0\u0e88\u0ebb\u0ec9\u0eb2" },
            { "%%HEPBURN", "\u0e81\u0eb2\u0e99\u0e96\u0ead\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec1\u0e9a\u0e9a\u0ec0\u0eae\u0e9a\u0ec0\u0e9a\u0eb4\u0e99" },
            { "%%ITIHASA", "\u0ead\u0eb4\u0e95\u0eb4\u0eab\u0eb2\u0eaa\u0eb0" },
            { "%%LAUKIKA", "\u0ea5\u0ebb\u0ea7\u0e81\u0eb4\u0e81\u0eb2" },
            { "%%MONOTON", "\u0ec2\u0ea1\u0ec2\u0e99\u0ec2\u0e97\u0e99\u0eb4\u0e81" },
            { "%%POLYTON", "\u0ec2\u0e9e\u0ea5\u0eb5\u0ec2\u0e97\u0e99\u0eb4\u0e81" },
            { "%%REVISED", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0eaa\u0eb0\u0e9a\u0eb1\u0e9a\u0e9b\u0eb1\u0e9a\u0e9b\u0eb8\u0e87" },
            { "%%SURSILV", "\u0e8a\u0eb9\u0ea3\u0ecc\u0e8a\u0eb5\u0ea5\u0ecc" },
            { "%%SUTSILV", "\u0e8a\u0eb8\u0e95\u0ecc\u0e8a\u0eb5\u0ea5\u0ecc" },
            { "%%VAIDIKA", "\u0ec0\u0ea7\u0e94\u0eb4\u0e81\u0eb2" },
            { "%%1606NICT", "\u0e9b\u0eb2\u0e8d\u0e8d\u0eb8\u0e81\u0e81\u0eb2\u0e87\u0e9d\u0ea3\u0eb1\u0ec8\u0e87\u0ec0\u0e96\u0eb4\u0e87\u0e9b\u0eb5 \u0e84\u0eaa 1606" },
            { "%%1694ACAD", "\u0e95\u0ead\u0e99\u0e95\u0ebb\u0ec9\u0e99\u0e8d\u0eb8\u0e81\u0ec3\u0edd\u0ec8\u0e9d\u0ea3\u0eb1\u0ec8\u0e87" },
            { "%%1959ACAD", "\u0ea7\u0eb4\u0e8a\u0eb2\u0e81\u0eb2\u0e99" },
            { "%%BAKU1926", "\u0e95\u0ebb\u0ea7\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ea5\u0eb2\u0e95\u0eb4\u0e99\u0ec0\u0e97\u0eb5\u0e81\u0eb4\u0e81\u0ec1\u0e9a\u0e9a\u0e84\u0ebb\u0e9a\u0ea7\u0ebb\u0e87\u0e88\u0ead\u0e99" },
            { "%%BISCAYAN", "\u0e9a\u0eb4\u0eaa\u0e84\u0eb2\u0e8d\u0eb1\u0e99" },
            { "%%FONXSAMP", "\u0e9f\u0ead\u0e99\u0ec1\u0e8a\u0ea1" },
            { "%%HOGNORSK", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e99\u0ecd\u0ea7\u0eb5\u0e88\u0ec8\u0ebd\u0e99\u0eaa\u0eb9\u0e87" },
            { "%%JYUTPING", "\u0e81\u0eb2\u0e99\u0e96\u0ead\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec1\u0e9a\u0e9a\u0e8d\u0eb9\u0e94\u0e9e\u0eb4\u0e87" },
            { "%%LUNA1918", "\u0ea5\u0eb9\u0e99\u0ec8\u0eb21918" },
            { "%%PETR1708", "\u0e9e\u0eb5\u0e97\u0ecc1708" },
            { "%%SCOTLAND", "\u0e9e\u0eb2\u0eaa\u0eb2\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99\u0eaa\u0eb0\u0e81\u0eb1\u0ead\u0e94" },
            { "%%SURMIRAN", "\u0e8a\u0eb9\u0ea3\u0ecc\u0ea1\u0eb4\u0ea5\u0eb2\u0e99" },
            { "%%VALENCIA", "\u0ea7\u0eb2\u0ec0\u0ea5\u0eb1\u0e99\u0ec0\u0e8a\u0e8d" },
            { "%%VALLADER", "\u0ea7\u0eb1\u0ea5\u0ea5\u0eb2\u0ec0\u0e94\u0eb5" },
            { "%%WADEGILE", "\u0e81\u0eb2\u0e99\u0e96\u0ead\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec1\u0e9a\u0e9a\u0ec0\u0ea7\u0e94-\u0ec4\u0e88\u0ea5\u0ecc" },
            { "type.ca.roc", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec4\u0e95\u0ec9\u0eab\u0ea7\u0eb1\u0e99" },
            { "type.hc.h11", "\u0e95\u0eb2\u0ea1\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a 12 \u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87 (0\u201311)" },
            { "type.hc.h12", "\u0e95\u0eb2\u0ea1\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a 12 \u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87 (1\u201312)" },
            { "type.hc.h23", "\u0e95\u0eb2\u0ea1\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a 24 \u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87 (0\u201323)" },
            { "type.hc.h24", "\u0e95\u0eb2\u0ea1\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a 24 \u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87 (1\u201324)" },
            { "type.nu.arab", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81-\u0ead\u0eb4\u0e99\u0e94\u0eb4\u0e81" },
            { "type.nu.armn", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ead\u0eb2\u0ec0\u0ea1\u0e99\u0ebd\u0e99" },
            { "type.nu.bali", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e9a\u0eb2\u0ea5\u0eb5" },
            { "type.nu.beng", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e9a\u0eb1\u0e87\u0e81\u0ea5\u0eb2" },
            { "type.nu.cakm", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e88\u0eb1\u0e81\u0e81\u0eb0\u0ea1\u0eb2" },
            { "type.nu.cham", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8a\u0ea3\u0eb2\u0ea1" },
            { "type.nu.deva", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0e94\u0ea7\u0eb2\u0e99\u0eb2\u0e81\u0eb2\u0ea3\u0eb5" },
            { "type.nu.ethi", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0ead\u0e97\u0eb4\u0ec2\u0ead\u0e9b\u0eb4\u0e81" },
            { "type.nu.geor", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e88\u0ecd\u0e88\u0ebd\u0e99" },
            { "type.nu.grek", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0ea3\u0eb5\u0e81" },
            { "type.nu.gujr", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0eb8\u0e88\u0eb2\u0ea3\u0eb2\u0e97\u0eb5" },
            { "type.nu.guru", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0ebb\u0ea7\u0ea1\u0eb9\u0e84\u0eb4" },
            { "type.nu.hans", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e88\u0eb5\u0e99\u0ec1\u0e9a\u0e9a\u0eae\u0ebd\u0e9a\u0e87\u0ec8\u0eb2\u0e8d" },
            { "type.nu.hant", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e88\u0eb5\u0e99\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "type.nu.hebr", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0eae\u0eb4\u0e9a\u0ea3\u0eb4\u0ea7" },
            { "type.nu.java", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8a\u0ebb\u0ea7" },
            { "type.nu.jpan", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99" },
            { "type.nu.kali", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0eb2\u0ea2\u0eb2" },
            { "type.nu.khmr", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e82\u0eb0\u0ec1\u0ea1" },
            { "type.nu.knda", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec1\u0e84\u0e99\u0e99\u0eb2\u0e94\u0eb2" },
            { "type.nu.lana", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec4\u0e97\u0e97\u0eb3\u0ec2\u0eae\u0ea5\u0eb2" },
            { "type.nu.laoo", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea5\u0eb2\u0ea7" },
            { "type.nu.latn", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "type.nu.lepc", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0ea5\u0e8a\u0eb2" },
            { "type.nu.limb", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea5\u0eb4\u0ea1\u0e9a\u0eb9" },
            { "type.nu.mlym", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea1\u0eb2\u0ec0\u0ea5\u0ead\u0eb2\u0ea5\u0eb3" },
            { "type.nu.mong", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea1\u0ec8\u0ead\u0e87\u0ec2\u0e81\u0ec0\u0ea5\u0e8d" },
            { "type.nu.mtei", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0ea1\u0ec4\u0e95\u0ea1\u0eb2\u0ec0\u0ea2\u0e81" },
            { "type.nu.mymr", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea1\u0ebd\u0e99\u0ea1\u0eb2" },
            { "type.nu.nkoo", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0ead\u0eb1\u0e99\u0ec2\u0e81\u0ec9" },
            { "type.nu.olck", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec2\u0ead\u0ea5\u0e88\u0eb4\u0e81\u0eb4" },
            { "type.nu.orya", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec2\u0ead\u0e94\u0eb4\u0ead\u0eb2" },
            { "type.nu.saur", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0eaa\u0ebb\u0eb2\u0ea5\u0eb1\u0e94\u0e97\u0eb2" },
            { "type.nu.sund", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8a\u0eb8\u0e99\u0e94\u0eb2" },
            { "type.nu.talu", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec4\u0e95\u0ea5\u0eb7\u0ec9\u0ec3\u0edd\u0ec8" },
            { "type.nu.taml", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0ea1\u0eb4\u0ea5\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "type.nu.telu", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0e95\u0ea5\u0eb9\u0e81\u0eb9" },
            { "type.nu.thai", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec4\u0e97" },
            { "type.nu.tibt", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb4\u0ec0\u0e9a\u0e94" },
            { "type.nu.vaii", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec3\u0e99\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0ec4\u0ea7" },
            { "type.ca.dangi", "\u0e9b\u0eb0\u200b\u0e95\u0eb4\u200b\u0e97\u0eb4\u0e99\u200b\u0e94\u0eb1\u0e87\u200b\u0e81\u0eb5" },
            { "type.co.ducet", "\u0eae\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ea5\u0eb3\u0e94\u0eb1\u0e9a\u0ea2\u0eb9\u0e99\u0eb4\u0ec2\u0e84\u0e94\u0ec0\u0ea5\u0eb5\u0ec8\u0ea1\u0e95\u0ebb\u0ec9\u0e99" },
            { "type.lb.loose", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0ec0\u0eaa\u0eb1\u0ec9\u0e99\u0e82\u0eb1\u0ec9\u0e99\u0ec1\u0e9a\u0e9a\u0eab\u0ebc\u0ea7\u0ea1" },
            { "type.nu.roman", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec2\u0ea3\u0ea1\u0eb1\u0e99" },
            { "type.ca.coptic", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0e84\u0eb1\u0ead\u0e9a\u0e95\u0eb4\u0e81" },
            { "type.ca.hebrew", "\u0e9b\u0eb0\u200b\u0e95\u0eb4\u200b\u0e97\u0eb4\u0e99\u200b\u0eae\u0eb5\u0e9a\u200b\u0ea3\u0eb4\u0ea7" },
            { "type.ca.indian", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec1\u0eab\u0ec8\u0e87\u0e8a\u0eb2\u0e94\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d" },
            { "type.co.pinyin", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0e81\u0eb2\u0e99\u0ead\u0ead\u0e81\u0eaa\u0ebd\u0e87\u0e9e\u0eb2\u0eaa\u0eb2\u0e88\u0eb5\u0e99" },
            { "type.co.search", "\u0e81\u0eb2\u0e99\u0e8a\u0ead\u0e81\u0eab\u0eb2\u0e97\u0ebb\u0ec8\u0ea7\u0ec4\u0e9b" },
            { "type.co.stroke", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0e81\u0eb2\u0e99\u0ea5\u0eb2\u0e81\u0ec0\u0eaa\u0eb1\u0ec9\u0e99" },
            { "type.co.unihan", "\u0ea5\u0ebd\u0e87\u0ea5\u0eb3\u0e94\u0eb1\u0e9a\u0e95\u0eb2\u0ea1\u0e88\u0eb3\u0e99\u0ea7\u0e99\u0e82\u0eb5\u0e94" },
            { "type.lb.normal", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0ec0\u0eaa\u0eb1\u0ec9\u0e99\u0e82\u0eb1\u0ec9\u0e99\u0ec1\u0e9a\u0e9a\u0e9b\u0ebb\u0e81\u0e81\u0eb0\u0e95\u0eb4" },
            { "type.lb.strict", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0ec0\u0eaa\u0eb1\u0ec9\u0e99\u0e82\u0eb1\u0ec9\u0e99\u0ec1\u0e9a\u0e9a\u0ec0\u0e84\u0eb1\u0ec8\u0e87\u0e84\u0eb1\u0e94" },
            { "type.ms.metric", "\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0ec0\u0ea1\u0e97\u0ea3\u0eb4\u0e81" },
            { "type.ca.chinese", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0e88\u0eb5\u0e99" },
            { "type.ca.islamic", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ead\u0eb4\u0eaa\u0eb0\u0ea5\u0eb2\u0ea1" },
            { "type.ca.iso8601", "\u0e9b\u0eb0\u200b\u0e95\u0eb4\u200b\u0e97\u0eb4\u0e99 ISO-8601" },
            { "type.ca.persian", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec0\u0e9b\u0eb5\u0e8a\u0ebd\u0e99" },
            { "type.cf.account", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0e81\u0eb2\u0e99\u0e9a\u0eb1\u0e99\u0e8a\u0eb5" },
            { "type.co.big5han", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0e88\u0eb5\u0e99\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "type.nu.arabext", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81-\u0ead\u0eb4\u0e99\u0e94\u0eb4\u0e81\u0e95\u0ebb\u0ea7\u0ec0\u0e95\u0eb1\u0ea1" },
            { "type.nu.armnlow", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ead\u0eb2\u0ec0\u0ea1\u0e99\u0ebd\u0e99\u0e95\u0ebb\u0ea7\u0e9e\u0eb4\u0ea1\u0e99\u0ec9\u0ead\u0e8d" },
            { "type.nu.greklow", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0ea3\u0eb5\u0e81\u0e95\u0ebb\u0ea7\u0e9e\u0eb4\u0ea1\u0e99\u0ec9\u0ead\u0e8d" },
            { "type.nu.hanidec", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0ebb\u0e94\u0eaa\u0eb0\u0e99\u0eb4\u0e8d\u0ebb\u0ea1\u0e88\u0eb5\u0e99" },
            { "type.nu.hansfin", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0e87\u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0ec1\u0e9a\u0e9a\u0eae\u0ebd\u0e9a\u0e87\u0ec8\u0eb2\u0e8d\u0e82\u0ead\u0e87\u0e88\u0eb5\u0e99" },
            { "type.nu.hantfin", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0e87\u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1\u0e82\u0ead\u0e87\u0e88\u0eb5\u0e99" },
            { "type.nu.jpanfin", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0e87\u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0e82\u0ead\u0e87\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99" },
            { "type.nu.tamldec", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0ea1\u0eb4\u0ea7" },
            { "type.ca.buddhist", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99 \u0e9e\u0eb8\u0e94\u0e97\u0eb0\u0eaa\u0eb1\u0e87\u0e81\u0eb2\u0e94" },
            { "type.ca.ethiopic", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec0\u0ead\u0e97\u0eb4\u0ec2\u0ead\u0ec0\u0e9b\u0e8d" },
            { "type.ca.japanese", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99" },
            { "type.cf.standard", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99" },
            { "type.co.reformed", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ea5\u0eb3\u0e94\u0eb1\u0e9a\u0eaa\u0eb8\u0e94\u0e97\u0ec9\u0eb2\u0e8d" },
            { "type.co.searchjl", "\u0e84\u0ebb\u0ec9\u0e99\u0eab\u0eb2\u0e95\u0eb2\u0ea1\u0e9e\u0eb0\u0e8d\u0eb1\u0e99\u0e8a\u0eb0\u0e99\u0eb0\u0e82\u0eb6\u0ec9\u0e99\u0e95\u0ebb\u0ec9\u0e99\u0e97\u0eb5\u0ec8\u0ec0\u0e9b\u0eb1\u0e99\u0eae\u0eb1\u0e87\u0e81\u0eb5\u0ea3" },
            { "type.co.standard", "\u0eae\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99" },
            { "type.ms.uksystem", "\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0e81\u0eb2\u0e99\u0ea7\u0eb1\u0e94\u0ec1\u0e97\u0e81\u0ec1\u0e9a\u0e9a\u0ead\u0eb4\u0ea1\u0ec0\u0e9e\u0eb5\u0ea3\u0ebd\u0ea7" },
            { "type.ms.ussystem", "\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0e81\u0eb2\u0e99\u0ea7\u0eb1\u0e94\u0ec1\u0e97\u0e81\u0ec1\u0e9a\u0e9a\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94" },
            { "type.nu.fullwide", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e84\u0ea7\u0eb2\u0ea1\u0e81\u0ea7\u0ec9\u0eb2\u0e87\u0ec0\u0e95\u0eb1\u0ea1" },
            { "type.nu.lanatham", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec4\u0e97\u0e97\u0eb3\u0e97\u0eb3" },
            { "type.nu.mymrshan", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8a\u0eb2\u0e99\u0e9e\u0eb0\u0ea1\u0ec9\u0eb2" },
            { "type.nu.romanlow", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec2\u0ea3\u0ea1\u0eb1\u0e99\u0e95\u0ebb\u0ea7\u0e9e\u0eb4\u0ea1\u0e99\u0ec9\u0ead\u0e8d" },
            { "type.ca.gregorian", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec0\u0e81\u0ea3\u0ec2\u0e81\u0ea3\u0ebd\u0e99" },
            { "type.co.gb2312han", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0e88\u0eb5\u0e99\u0e9b\u0eb0\u0e8d\u0eb8\u0e81" },
            { "type.co.phonebook", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0eaa\u0eb0\u0edd\u0eb8\u0e94\u0ec2\u0e97\u0ea5\u0eb0\u0eaa\u0eb1\u0e9a" },
            { "type.co.dictionary", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0e9e\u0ebb\u0e94\u0e88\u0eb0\u0e99\u0eb2\u0e99\u0eb8\u0e81\u0ebb\u0ea1" },
            { "type.co.traditional", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "type.ca.islamic-civil", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ead\u0eb4\u0e94\u0eaa\u0eb0\u0ea5\u0eb2\u0ea1" },
            { "type.ca.islamic-umalqura", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ead\u0eb4\u0e94\u0eaa\u0eb0\u0ea5\u0eb2\u0ea1 (\u0ead\u0eb3\u0ead\u0eb2\u0ea7\u0e84\u0eb4\u0ea7\u0ea3\u0eb2)" },
            { "type.ca.ethiopic-amete-alem", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0e9b\u0eb5\u0ec2\u0ead\u0ec0\u0ead\u0e97\u0eb4\u0ec2\u0ead\u0ec0\u0e9b\u0e8d" },
        };
        return data;
    }
}
