/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_af extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "Arabies";
        final String metaValue_hy = "Armeens";
        final String metaValue_bn = "Bengaals";
        final String metaValue_ka = "Georgies";
        final String metaValue_el = "Grieks";
        final String metaValue_he = "Hebreeus";
        final String metaValue_ja = "Japannees";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreaans";
        final String metaValue_lo = "Lao";
        final String metaValue_la = "Latyn";
        final String metaValue_ml = "Malabaars";
        final String metaValue_mn = "Mongools";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_syr = "Siries";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Teloegoe";
        final String metaValue_th = "Thai";
        final String metaValue_bo = "Tibettaans";
        final String metaValue_vai = "Vai";
        final Object[][] data = new Object[][] {
            { "001", "W\u00eareld" },
            { "002", "Afrika" },
            { "003", "Noord-Amerika" },
            { "005", "Suid-Amerika" },
            { "009", "Oseani\u00eb" },
            { "011", "Wes-Afrika" },
            { "013", "Sentraal-Amerika" },
            { "014", "Oos-Afrika" },
            { "015", "Noord-Afrika" },
            { "017", "Midde-Afrika" },
            { "018", "Suider-Afrika" },
            { "019", "Amerikas" },
            { "021", "Noordelike Amerika" },
            { "029", "Karibiese streek" },
            { "030", "Oos-Asi\u00eb" },
            { "034", "Suid-Asi\u00eb" },
            { "035", "Suidoos-Asi\u00eb" },
            { "039", "Suid-Europa" },
            { "053", "Australasi\u00eb" },
            { "054", "Melanesi\u00eb" },
            { "057", "Mikronesiese streek" },
            { "061", "Polinesi\u00eb" },
            { "142", "Asi\u00eb" },
            { "143", "Sentraal-Asi\u00eb" },
            { "145", "Wes-Asi\u00eb" },
            { "150", "Europa" },
            { "151", "Oos-Europa" },
            { "154", "Noord-Europa" },
            { "155", "Wes-Europa" },
            { "202", "Afrika suid van die Sahara" },
            { "419", "Latyns-Amerika" },
            { "AC", "Ascensioneiland" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabiese Emirate" },
            { "AF", "Afganistan" },
            { "AG", "Antigua en Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albani\u00eb" },
            { "AM", "Armeni\u00eb" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentini\u00eb" },
            { "AS", "Amerikaanse Samoa" },
            { "AT", "Oostenryk" },
            { "AU", "Australi\u00eb" },
            { "AW", "Aruba" },
            { "AX", "\u00c5landeilande" },
            { "AZ", "Azerbeidjan" },
            { "BA", "Bosni\u00eb en Herzegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesj" },
            { "BE", "Belgi\u00eb" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarye" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Broenei" },
            { "BO", "Bolivi\u00eb" },
            { "BQ", "Karibiese Nederland" },
            { "BR", "Brasili\u00eb" },
            { "BS", "Bahamas" },
            { "BT", "Bhoetan" },
            { "BV", "Bouvet-eiland" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokoseilande" },
            { "CD", "Demokratiese Republiek van die Kongo" },
            { "CF", "Sentraal-Afrikaanse Republiek" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Switserland" },
            { "CI", "Ivoorkus" },
            { "CK", "Cookeilande" },
            { "CL", "Chili" },
            { "CM", "Kameroen" },
            { "CN", "China" },
            { "CO", "Colombi\u00eb" },
            { "CP", "Clippertoneiland" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kaap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Kerseiland" },
            { "CY", "Siprus" },
            { "CZ", "Tsjeggi\u00eb" },
            { "DE", "Duitsland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djiboeti" },
            { "DK", "Denemarke" },
            { "DM", "Dominica" },
            { "DO", "Dominikaanse Republiek" },
            { "DZ", "Algeri\u00eb" },
            { "EA", "Ceuta en Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egipte" },
            { "EH", "Wes-Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "ET", "Ethiopi\u00eb" },
            { "EU", "Europese Unie" },
            { "EZ", "Eurosone" },
            { "FI", "Finland" },
            { "FJ", "Fidji" },
            { "FK", "Falklandeilande" },
            { "FM", "Mikronesi\u00eb" },
            { "FO", "Faro\u00ebreilande" },
            { "FR", "Frankryk" },
            { "GA", "Gaboen" },
            { "GB", "Verenigde Koninkryk" },
            { "GD", "Grenada" },
            { "GE", "Georgi\u00eb" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenland" },
            { "GM", "Gambi\u00eb" },
            { "GN", "Guinee" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekwatoriaal-Guinee" },
            { "GR", "Griekeland" },
            { "GS", "Suid-Georgi\u00eb en die Suidelike Sandwicheilande" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinee-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong SAS China" },
            { "HM", "Heardeiland en McDonaldeilande" },
            { "HN", "Honduras" },
            { "HR", "Kroasi\u00eb" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongarye" },
            { "IC", "Kanariese Eilande" },
            { "ID", "Indonesi\u00eb" },
            { "IE", "Ierland" },
            { "IL", "Israel" },
            { "IM", "Eiland Man" },
            { "IN", "Indi\u00eb" },
            { "IO", "Brits-Indiese Oseaangebied" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Ysland" },
            { "IT", "Itali\u00eb" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordani\u00eb" },
            { "JP", "Japan" },
            { "KE", "Kenia" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comore" },
            { "KN", "Sint Kitts en Nevis" },
            { "KP", "Noord-Korea" },
            { "KR", "Suid-Korea" },
            { "KW", "Koeweit" },
            { "KY", "Kaaimanseilande" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Sint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberi\u00eb" },
            { "LS", "Lesotho" },
            { "LT", "Litaue" },
            { "LU", "Luxemburg" },
            { "LV", "Letland" },
            { "LY", "Libi\u00eb" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldowa" },
            { "ME", "Montenegro" },
            { "MF", "Sint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalleilande" },
            { "MK", "Noord-Macedoni\u00eb" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birma)" },
            { "MN", "Mongoli\u00eb" },
            { "MO", "Macau SAS China" },
            { "MP", "Noord-Mariane-eilande" },
            { "MQ", "Martinique" },
            { "MR", "Mauritani\u00eb" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maledive" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Maleisi\u00eb" },
            { "MZ", "Mosambiek" },
            { "NA", "Namibi\u00eb" },
            { "NC", "Nieu-Kaledoni\u00eb" },
            { "NE", "Niger" },
            { "NF", "Norfolkeiland" },
            { "NG", "Nigeri\u00eb" },
            { "NI", "Nicaragua" },
            { "NL", "Nederland" },
            { "NO", "Noorwe\u00eb" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "Nieu-Seeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Frans-Polinesi\u00eb" },
            { "PG", "Papoea-Nieu-Guinee" },
            { "PH", "Filippyne" },
            { "PK", "Pakistan" },
            { "PL", "Pole" },
            { "PM", "Sint Pierre en Miquelon" },
            { "PN", "Pitcairneilande" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestynse Grondgebiede" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Afgele\u00eb Oseani\u00eb" },
            { "RE", "R\u00e9union" },
            { "RO", "Roemeni\u00eb" },
            { "RS", "Serwi\u00eb" },
            { "RU", "Rusland" },
            { "RW", "Rwanda" },
            { "SA", "Saoedi-Arabi\u00eb" },
            { "SB", "Salomonseilande" },
            { "SC", "Seychelle" },
            { "SD", "Soedan" },
            { "SE", "Swede" },
            { "SG", "Singapoer" },
            { "SH", "Sint Helena" },
            { "SI", "Sloweni\u00eb" },
            { "SJ", "Spitsbergen en Jan Mayen" },
            { "SK", "Slowakye" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali\u00eb" },
            { "SR", "Suriname" },
            { "SS", "Suid-Soedan" },
            { "ST", "S\u00e3o Tom\u00e9 en Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siri\u00eb" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- en Caicoseilande" },
            { "TD", "Tsjad" },
            { "TF", "Franse Suidelike Gebiede" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Oos-Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisi\u00eb" },
            { "TO", "Tonga" },
            { "TR", "Turkye" },
            { "TT", "Trinidad en Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "TZ", "Tanzani\u00eb" },
            { "UA", "Oekra\u00efne" },
            { "UG", "Uganda" },
            { "UM", "Klein afgele\u00eb eilande van die VSA" },
            { "UN", "Verenigde Nasies" },
            { "US", "Verenigde State van Amerika" },
            { "UY", "Uruguay" },
            { "UZ", "Oesbekistan" },
            { "VA", "Vatikaanstad" },
            { "VC", "Sint Vincent en die Grenadine" },
            { "VE", "Venezuela" },
            { "VG", "Britse Maagde-eilande" },
            { "VI", "VSA se Maagde-eilande" },
            { "VN", "Vi\u00ebtnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis en Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudoaksente" },
            { "XB", "Pseudotweerigting" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Suid-Afrika" },
            { "ZM", "Zambi\u00eb" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Onbekende gebied" },
            { "aa", "Afar" },
            { "ab", "Abkasies" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharies" },
            { "an", "Aragonees" },
            { "ar", metaValue_ar },
            { "as", "Assamees" },
            { "av", "Avaries" },
            { "ay", "Aymara" },
            { "az", "Azerbeidjans" },
            { "ba", "Baskir" },
            { "be", "Belarussies" },
            { "bg", "Bulgaars" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Bretons" },
            { "bs", "Bosnies" },
            { "ca", "Katalaans" },
            { "ce", "Tsjetsjeens" },
            { "ch", "Chamorro" },
            { "co", "Korsikaans" },
            { "cs", "Tsjeggies" },
            { "cu", "Kerkslawies" },
            { "cv", "Chuvash" },
            { "cy", "Wallies" },
            { "da", "Deens" },
            { "de", "Duits" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Engels" },
            { "eo", "Esperanto" },
            { "es", "Spaans" },
            { "et", "Estnies" },
            { "eu", "Baskies" },
            { "fa", "Persies" },
            { "ff", "Fulah" },
            { "fi", "Fins" },
            { "fj", "Fidjiaans" },
            { "fo", "Faro\u00ebes" },
            { "fr", "Frans" },
            { "fy", "Fries" },
            { "ga", "Iers" },
            { "gd", "Skotse Gallies" },
            { "gl", "Galisies" },
            { "gn", "Guarani" },
            { "gu", "Goedjarati" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", "Kroaties" },
            { "ht", "Ha\u00eftiaans" },
            { "hu", "Hongaars" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesies" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", "Yslands" },
            { "it", "Italiaans" },
            { "iu", "Inoektitoet" },
            { "ja", metaValue_ja },
            { "jv", "Javaans" },
            { "ka", metaValue_ka },
            { "kg", "Kongolees" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazaks" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kasjmirs" },
            { "ku", "Koerdies" },
            { "kv", "Komi" },
            { "kw", "Kornies" },
            { "ky", "Kirgisies" },
            { "la", metaValue_la },
            { "lb", "Luxemburgs" },
            { "lg", "Ganda" },
            { "li", "Limburgs" },
            { "ln", "Lingaals" },
            { "lo", metaValue_lo },
            { "lt", "Litaus" },
            { "lu", "Luba-Katanga" },
            { "lv", "Letties" },
            { "mg", "Malgassies" },
            { "mh", "Marshallees" },
            { "mi", "Maori" },
            { "mk", "Masedonies" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Maleis" },
            { "mt", "Maltees" },
            { "my", "Birmaans" },
            { "na", metaValue_NR },
            { "nb", "Boeknoors" },
            { "nd", "Noord-Ndebele" },
            { "ne", "Nepalees" },
            { "ng", "Ndonga" },
            { "nl", "Nederlands" },
            { "nn", "Nuwe Noors" },
            { "no", "Noors" },
            { "nr", "Suid-Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Oksitaans" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Osseties" },
            { "pa", "Pandjabi" },
            { "pl", "Pools" },
            { "ps", "Pasjto" },
            { "pt", "Portugees" },
            { "qu", "Quechua" },
            { "rm", "Reto-Romaans" },
            { "rn", "Rundi" },
            { "ro", "Roemeens" },
            { "ru", "Russies" },
            { "rw", "Rwandees" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinies" },
            { "sd", "Sindhi" },
            { "se", "Noord-Sami" },
            { "sg", "Sango" },
            { "sh", "Serwo-Kroaties" },
            { "si", metaValue_si },
            { "sk", "Slowaaks" },
            { "sl", "Sloweens" },
            { "sm", "Samoaans" },
            { "sn", "Shona" },
            { "so", "Somalies" },
            { "sq", "Albanees" },
            { "sr", "Serwies" },
            { "ss", "Swazi" },
            { "st", "Suid-Sotho" },
            { "su", "Sundanees" },
            { "sv", "Sweeds" },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tadjiks" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "tk", "Turkmeens" },
            { "tn", "Tswana" },
            { "to", "Tongaans" },
            { "tr", "Turks" },
            { "ts", "Tsonga" },
            { "tt", "Tataars" },
            { "tw", "Twi" },
            { "ty", "Tahities" },
            { "ug", "Uighur" },
            { "uk", "Oekra\u00efens" },
            { "ur", "Oerdoe" },
            { "uz", "Oezbeeks" },
            { "ve", "Venda" },
            { "vi", "Vi\u00ebtnamees" },
            { "vo", "Volap\u00fck" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddisj" },
            { "yo", "Yoruba" },
            { "zh", "Chinees" },
            { "zu", "Zoeloe" },
            { "ace", "Atsjenees" },
            { "ach", "Akoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Suid-Altai" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arc", "Aramees" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "ars", "Najdi-Arabies" },
            { "asa", "Asu" },
            { "ast", "Asturies" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "ban", "Balinees" },
            { "bas", "Basaa" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bgn", "Wes-Balochi" },
            { "bho", "Bhojpuri" },
            { "bin", "Bini" },
            { "bla", "Siksika" },
            { "brx", "Bodo" },
            { "bug", "Buginees" },
            { "byn", "Blin" },
            { "cay", "Cayuga" },
            { "ccp", "Tsjaakma" },
            { "ceb", "Cebuano" },
            { "cgg", "Kiga" },
            { "chk", "Chuukees" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", "Cherokees" },
            { "chy", "Cheyennees" },
            { "ckb", "Sorani" },
            { "clc", "Tzilkotin" },
            { "cop", "Kopties" },
            { "crg", "Michif" },
            { "crj", "Suidoos-Cree" },
            { "crk", "Laagvlakte-Cree" },
            { "crl", "Noordoos-Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina-Algonkin" },
            { "crs", "Seselwa Franskreools" },
            { "csw", "Swampy Cree" },
            { "dak", "Dakotaans" },
            { "dar", "Dakota" },
            { "dav", "Taita" },
            { "dgr", "Dogrib" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Benedesorbies" },
            { "dua", "Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egy", "Antieke Egipties" },
            { "eka", "Ekajuk" },
            { "ewo", "Ewondo" },
            { "fil", "Filippyns" },
            { "fon", "Fon" },
            { "frc", "Cajun" },
            { "frr", "Noord-Fries" },
            { "fur", "Friuliaans" },
            { "gaa", "Gaa" },
            { "gag", "Gagauz" },
            { "gan", "Gan-Sjinees" },
            { "gez", "Geez" },
            { "gil", "Gilbertees" },
            { "gor", "Gorontalo" },
            { "got", "Goties" },
            { "grc", "Antieke Grieks" },
            { "gsw", "Switserse Duits" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "hak", "Hakka-Sjinees" },
            { "haw", "Hawais" },
            { "hax", "Suid-Haida" },
            { "hil", "Hiligaynon" },
            { "hit", "Hetities" },
            { "hmn", "Hmong" },
            { "hsb", "Oppersorbies" },
            { "hsn", "Xiang-Sjinees" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Ibanees" },
            { "ibb", "Ibibio" },
            { "ikt", "Wes-Kanadese Inoektitoet" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kbd", "Kabardiaans" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyaks" },
            { "kok", "Konkani" },
            { "kpe", "Kpellees" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelies" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Keuls" },
            { "kum", "Kumyk" },
            { "kwk", "Kwak\u2019wala" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lez", "Lezghies" },
            { "lil", "Lillooet" },
            { "lkt", "Lakota" },
            { "lou", "Louisiana Kreool" },
            { "loz", "Lozi" },
            { "lrc", "Noord-Luri" },
            { "lsm", "Saamia" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Madurees" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "mfe", "Morisjen" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u2019" },
            { "mic", "Micmac" },
            { "min", "Minangkabaus" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Verskeie tale" },
            { "mus", "Kreek" },
            { "mwl", "Mirandees" },
            { "myv", "Erzya" },
            { "mzn", "Masanderani" },
            { "nan", "Min Nan-Sjinees" },
            { "nap", "Neapolitaans" },
            { "naq", "Nama" },
            { "nds", "Nederduits" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niueaans" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Noord-Sotho" },
            { "nus", "Nuer" },
            { "nyn", "Nyankole" },
            { "ojb", "Noordwes-Ojibwa" },
            { "ojc", "Sentraal-Ojibwa" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Wes-Ojibwa" },
            { "oka", "Okanagan" },
            { "pag", "Pangasinan" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauaans" },
            { "pcm", "Nigeriese Pidgin" },
            { "phn", "Fenisies" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Pruisies" },
            { "quc", "K\u2019iche\u2019" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongaans" },
            { "rhg", "Rohingya" },
            { "rof", "Rombo" },
            { "rup", "Aromanies" },
            { "rwk", "Rwa" },
            { "sad", "Sandawees" },
            { "sah", "Sakhaans" },
            { "saq", "Samburu" },
            { "sat", "Santalies" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sisiliaans" },
            { "sco", "Skots" },
            { "sdh", "Suid-Koerdies" },
            { "seh", "Sena" },
            { "ses", "Koyraboro Senni" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "slh", "Suid-Lushootseed" },
            { "sma", "Suid-Sami" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "ssy", "Saho" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "swb", "Comoraans" },
            { "syr", metaValue_syr },
            { "tce", "Suid-Tutchone" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "tet", "Tetoem" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "ttm", "Noord-Tutchone" },
            { "tum", "Toemboeka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinees" },
            { "tzm", "Sentraal-Atlas-Tamazight" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "Onbekende taal" },
            { "vai", metaValue_vai },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu-Sjinees" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kantonees" },
            { "zgh", "Standaard Marokkaanse Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "Geen taalinhoud nie" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "Bopomofo" },
            { "Brai", "Braille" },
            { "Cakm", "Chakma" },
            { "Cans", "Verenigde Kanadese Inheemse Lettergreepskrif" },
            { "Cher", "Cherokee" },
            { "Cyrl", "Sirillies" },
            { "Deva", "Devanagari" },
            { "Ethi", "Etiopies" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", "Gudjarati" },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han met Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hans", "Vereenvoudig" },
            { "Hant", "Tradisioneel" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hrkt", "Japannese lettergreepskrif" },
            { "Jamo", "Jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "Katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "Meitei-Majek" },
            { "Mymr", "Mianmar" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chiki" },
            { "Orya", metaValue_or },
            { "Rohg", "Hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", "Soendanees" },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "Tifinagh" },
            { "Thaa", "Thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "Yi" },
            { "Zmth", "Wiskundige notasie" },
            { "Zsye", "Emoji" },
            { "Zsym", "Simbole" },
            { "Zxxx", "Ongeskrewe" },
            { "Zyyy", "Gemeenskaplik" },
            { "Zzzz", "Onbekende skryfstelsel" },
            { "en_GB", "Engels (VK)" },
            { "en_US", "Engels (VSA)" },
            { "fa_AF", "Dari" },
            { "nl_BE", "Vlaams" },
            { "ar_001", "Moderne Standaardarabies" },
            { "key.ca", "Kalender" },
            { "key.cf", "Geldeenheidformaat" },
            { "key.co", "Rangskikvolgorde" },
            { "key.cu", "Geldeenheid" },
            { "key.hc", "Uursiklus (12 vs 24)" },
            { "key.lb", "Re\u00eblafbreek-styl" },
            { "key.ms", "Maatstelsel" },
            { "key.nu", "Syfers" },
            { "key.tz", "Tydsone" },
            { "key.va", "Lokaalvariant" },
            { "nds_NL", "Nedersaksies" },
            { "type.ca.roc", "Minguo-kalender" },
            { "type.hc.h11", "12-uur-stelsel (0-11)" },
            { "type.hc.h12", "12-uur-stelsel (1-12)" },
            { "type.hc.h23", "24-uur-stelsel (0-23)" },
            { "type.hc.h24", "24-uur-stelsel (1-24)" },
            { "type.m0.bgn", "BGN-transliterasie" },
            { "type.nu.arab", "Arabies-Indiese syfers" },
            { "type.nu.armn", "Armeense syfers" },
            { "type.nu.beng", "Bengaalse syfers" },
            { "type.nu.cakm", "Chakma-syfers" },
            { "type.nu.deva", "Devanagari-syfers" },
            { "type.nu.ethi", "Etiopiese syfers" },
            { "type.nu.geor", "Georgiese syfers" },
            { "type.nu.grek", "Griekse syfers" },
            { "type.nu.gujr", "Goedjarati-syfers" },
            { "type.nu.guru", "Gurmukhi-syfers" },
            { "type.nu.hans", "Vereenvoudigde Sjinese syfers" },
            { "type.nu.hant", "Tradisionele Sjinese syfers" },
            { "type.nu.hebr", "Hebreeuse syfers" },
            { "type.nu.java", "Javaanse syfers" },
            { "type.nu.jpan", "Japannese syfers" },
            { "type.nu.khmr", "Khmer-syfers" },
            { "type.nu.knda", "Kannada-syfers" },
            { "type.nu.laoo", "Lao-syfers" },
            { "type.nu.latn", "Westerse syfers" },
            { "type.nu.mlym", "Malabaarse syfers" },
            { "type.nu.mong", "Mongoliese syfers" },
            { "type.nu.mtei", "Meetei Mayak-syfers" },
            { "type.nu.mymr", "Mianmar-syfers" },
            { "type.nu.olck", "Ol Chiki-syfers" },
            { "type.nu.orya", "Odia-syfers" },
            { "type.nu.taml", "Tradisionele Tamil-syfers" },
            { "type.nu.telu", "Teloegoe-syfers" },
            { "type.nu.thai", "Thaise syfers" },
            { "type.nu.tibt", "Tibettaanse syfers" },
            { "type.nu.vaii", "Vai-syfers" },
            { "type.ca.dangi", "Dangi-kalender" },
            { "type.co.ducet", "Verstek Unicode-rangskikvolgorde" },
            { "type.lb.loose", "Losse re\u00eblafbreek-styl" },
            { "type.nu.roman", "Romeinse syfers" },
            { "type.ca.coptic", "Koptiese kalender" },
            { "type.ca.hebrew", "Hebreeuse kalender" },
            { "type.ca.indian", "Indiese nasionale kalender" },
            { "type.co.pinyin", "Pinyin-sorteervolgorde" },
            { "type.co.search", "Algemenedoel-soektog" },
            { "type.co.stroke", "Slag-sorteervolgorde" },
            { "type.co.unihan", "Radikale-slag-sorteervolgorde" },
            { "type.d0.fwidth", "Vollewydte" },
            { "type.d0.hwidth", "Halfwydte" },
            { "type.lb.normal", "Normale re\u00eblafbreek-styl" },
            { "type.lb.strict", "Streng re\u00eblafbreek-styl" },
            { "type.m0.ungegn", "UNGEGN-transliterasie" },
            { "type.ms.metric", "Metrieke stelsel" },
            { "type.nu.native", "Inheemse syfers" },
            { "type.ca.chinese", "Chinese kalender" },
            { "type.ca.islamic", "Islamitiese kalender" },
            { "type.ca.iso8601", "ISO-8601-kalender" },
            { "type.ca.persian", "Persiese kalender" },
            { "type.cf.account", "Rekeningkundige geldeenheidformaat" },
            { "type.co.big5han", "Tradisionele Chinese sorteervolgorde - Groot5" },
            { "type.d0.npinyin", "Numeries" },
            { "type.nu.arabext", "Uitgebreide Arabies-Indiese syfers" },
            { "type.nu.armnlow", "Armeense kleinletter-syfers" },
            { "type.nu.finance", "Finansi\u00eble syfers" },
            { "type.nu.greklow", "Griekse kleinletter-syfers" },
            { "type.nu.hanidec", "Sjinese desimale syfers" },
            { "type.nu.hansfin", "Vereenvoudigde Sjinese finansi\u00eble syfers" },
            { "type.nu.hantfin", "Tradisionele Sjinese finansi\u00eble syfers" },
            { "type.nu.jpanfin", "Japannese finansi\u00eble syfers" },
            { "type.nu.tamldec", "Tamil-syfers" },
            { "type.ca.buddhist", "Boeddhistiese kalender" },
            { "type.ca.ethiopic", "Etiopiese kalender" },
            { "type.ca.japanese", "Japannese kalender" },
            { "type.cf.standard", "Standaard geldeenheidformaat" },
            { "type.co.phonetic", "Fonetiese sorteerorde" },
            { "type.co.reformed", "Gereformeerde sorteervolgorde" },
            { "type.co.searchjl", "Soek volgens Hangul-beginkonsonant" },
            { "type.co.standard", "Standaard rangskikvolgorde" },
            { "type.ms.uksystem", "Imperiale maatstelsel" },
            { "type.ms.ussystem", "VSA-maatstelsel" },
            { "type.nu.fullwide", "Vollewydte-syfers" },
            { "type.nu.romanlow", "Romeinse kleinletter-syfers" },
            { "type.ca.gregorian", "Gregoriaanse kalender" },
            { "type.co.gb2312han", "Vereenvoudigde Chinese sorteervolgorde - GB2312" },
            { "type.co.phonebook", "Foonboek-sorteervolgorde" },
            { "type.co.dictionary", "Woordeboek-sorteervolgorde" },
            { "type.co.traditional", "Tradisionele sorteervolgorde" },
            { "type.nu.traditional", "Tradisionele syfers" },
            { "type.ca.islamic-civil", "Islamitiese siviele kalender" },
            { "type.ca.islamic-umalqura", "Islamitiese kalender (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etiopiese Amete Alem-kalender" },
        };
        return data;
    }
}
