/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.completion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractIntentCompletionProcessor
implements IContentAssistProcessor {
    private static final char[] AUTO_ACTIVATION_CHARACTERS = new char[]{' '};
    protected IDocument document;
    protected int offset;
    protected String start;
    private String indentation;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int currentOffset) {
        this.document = viewer.getDocument();
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        this.offset = selection != null && selection.getOffset() == currentOffset ? selection.getOffset() + selection.getLength() : currentOffset;
        this.computeStart();
        try {
            this.computeIndentation();
        }
        catch (BadLocationException e) {
            IntentUiLogger.logError(e);
        }
        try {
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals();
            return iCompletionProposalArray;
        }
        finally {
            this.document = null;
            this.offset = 0;
        }
    }

    private void computeIndentation() throws BadLocationException {
        int lineOffset = this.document.getLineOffset(this.document.getLineOfOffset(this.offset));
        String text = this.document.get(lineOffset, this.offset - lineOffset);
        Pattern pattern = Pattern.compile("\\s+");
        Matcher matcher = pattern.matcher(text);
        this.indentation = matcher.find() ? matcher.group() : "";
    }

    private void computeStart() {
        int index = this.offset;
        String text = this.document.get();
        while (index > 0 && this.isIntentIdentifierPart(text.charAt(index - 1))) {
            --index;
        }
        this.start = text.substring(index, this.offset);
    }

    private boolean isIntentIdentifierPart(char c) {
        return c == '@' || Character.isJavaIdentifierPart(c);
    }

    protected abstract ICompletionProposal[] computeCompletionProposals();

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int currentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return AUTO_ACTIVATION_CHARACTERS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public abstract String getContextType();

    protected ICompletionProposal createKeyWordProposal(String keyword) {
        return new CompletionProposal(keyword, this.offset - this.start.length(), this.start.length(), keyword.length());
    }

    protected TemplateProposal createTemplateProposal(String templateName, String templateDescription, String templatePattern, String templateImagePath) {
        int startLength = this.start.length();
        Template template = new Template(templateName, templateDescription, this.getContextType(), templatePattern.replaceAll("\n", "\n" + this.indentation), true);
        TemplateContextType type = new TemplateContextType(this.getContextType(), this.getContextType());
        DocumentTemplateContext context = new DocumentTemplateContext(type, this.document, this.offset - startLength, startLength);
        Region region = new Region(this.offset - startLength, startLength);
        Image image = IntentEditorActivator.getDefault().getImage(templateImagePath);
        return new TemplateProposal(template, (TemplateContext)context, (IRegion)region, image);
    }

    protected int getLastIndexOf(String text, Pattern pattern) {
        Matcher matcher = pattern.matcher(text);
        int end = -1;
        while (matcher.find()) {
            end = matcher.end();
        }
        return end;
    }
}

