/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.markup.List;
import org.eclipse.mylyn.docs.intent.markup.markup.ListItem;
import org.eclipse.mylyn.docs.intent.markup.serializer.AttributeStyleSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.BlockSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.ListSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.WikiTextElementDispatcher;

public final class ListItemSerializer {
    private ListItemSerializer() {
    }

    public static String render(ListItem listItem, WikiTextElementDispatcher dispatcher) {
        if (listItem.isIsList()) {
            return ListSerializer.render(listItem, dispatcher);
        }
        String prefix = ListSerializer.getPrefixFromListType(((List)listItem.eContainer()).getListType());
        String listItemPrefix = "";
        int i = 0;
        while (i < listItem.getImbricationLevel()) {
            listItemPrefix = String.valueOf(listItemPrefix) + prefix;
            ++i;
        }
        return String.valueOf(BlockSerializer.renderWithBlocPrefix(listItem, dispatcher, String.valueOf(listItemPrefix) + ListItemSerializer.getListContainerStyle(listItem) + " ")) + "\n";
    }

    private static String getListContainerStyle(ListItem listItem) {
        List containerList = ListItemSerializer.getContainerListIfFirstElementofList(listItem);
        if (containerList != null) {
            return AttributeStyleSerializer.renderAttributeForBloc(containerList.getAttributes());
        }
        return "";
    }

    private static List getContainerListIfFirstElementofList(ListItem element) {
        List returnedList = null;
        EObject container = element.eContainer();
        if (container instanceof List) {
            boolean isFirstOfList;
            List containerList = (List)container;
            boolean bl = isFirstOfList = ((List)container).getItems().indexOf((Object)element) == 0;
            if (isFirstOfList && containerList.eContainer() instanceof List) {
                returnedList = ((List)containerList.eContainer()).getItems().indexOf((Object)element) == 0 ? (List)containerList.eContainer() : containerList;
            }
        }
        return returnedList;
    }
}

