/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.internal.state;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.parser.descriptionunit.DescriptionUnitParser;
import org.eclipse.mylyn.docs.intent.parser.internal.state.IntentDefaultState;
import org.eclipse.mylyn.docs.intent.parser.internal.state.IntentGenericState;
import org.eclipse.mylyn.docs.intent.parser.internal.state.SSection;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;

public class IntentSubSectionContainerState
extends IntentDefaultState {
    private static Map<String, IntentSubSectionContainer> identifiersToSection;

    public IntentSubSectionContainerState(int offset, int declarationLength, IntentGenericState previous, EObject currentElement, IntentPositionManager positionManager, String title) throws ParseException {
        super(offset, declarationLength, previous, currentElement, positionManager);
        this.setTitle(title);
    }

    private void setTitle(String stringTitle) throws ParseException {
        if (stringTitle != null) {
            DescriptionUnit descriptionUnit = new DescriptionUnitParser().parse(stringTitle.trim());
            for (UnitInstruction title : descriptionUnit.getInstructions()) {
                if (!(title instanceof DescriptionBloc)) continue;
                EList contents = ((DescriptionBloc)title).getDescriptionBloc().getContent();
                if (contents.size() != 1) {
                    throw new ParseException("The title of this section isn't well formed", this.fOffset, stringTitle.trim().length());
                }
                Block titleBlock = (Block)contents.get(0);
                ((IntentSubSectionContainer)this.currentElement).setTitle(titleBlock);
                ((IntentSubSectionContainer)this.currentElement).setFormattedTitle(this.createFormattedTitle(stringTitle));
            }
        }
    }

    private String createFormattedTitle(String title) throws ParseException {
        String formattedTitle = "";
        int i = 0;
        while (i < title.length()) {
            if (Character.isJavaIdentifierPart(title.charAt(i))) {
                formattedTitle = String.valueOf(formattedTitle) + title.charAt(i);
            }
            ++i;
        }
        if (identifiersToSection == null) {
            identifiersToSection = new HashMap<String, IntentSubSectionContainer>();
        }
        identifiersToSection.get(formattedTitle);
        identifiersToSection.put(formattedTitle, (IntentSubSectionContainer)this.currentElement);
        return formattedTitle;
    }

    public IntentGenericState beginSection(int offset, int declarationLength, String title) throws ParseException {
        IntentSection subSection = IntentDocumentFactory.eINSTANCE.createIntentSection();
        ((IntentSubSectionContainer)this.currentElement).getIntentContent().add((Object)subSection);
        return new SSection(offset, declarationLength, (IntentGenericState)this, subSection, this.positionManager, title);
    }

    public IntentGenericState descriptionUnitContent(int offset, int length, String descriptionUnitContent) throws ParseException {
        int titleLength = 0;
        String descriptionUnitDescription = descriptionUnitContent;
        if (descriptionUnitDescription.trim().length() > 0) {
            DescriptionUnit descriptionUnit = new DescriptionUnitParser().parse(descriptionUnitDescription);
            ((IntentSubSectionContainer)this.currentElement).getIntentContent().add((Object)descriptionUnit);
            this.positionManager.setPositionForInstruction((EObject)descriptionUnit, offset + titleLength, length - titleLength);
        }
        return this;
    }

    public IntentGenericState endStructuredElement(int offset) {
        this.positionManager.setDeclarationPositionForInstruction(this.getCurrentElement(), this.getOffset(), offset - this.getOffset(), this.getDeclarationLength());
        return this.previousState();
    }
}

