/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.indexer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum INDEX_ENTRY_TYPE implements Enumerator
{
    INTENT_DOCUMENT(0, "IntentDocument", "IntentDocument"),
    INTENT_CHAPTER(1, "IntentChapter", "IntentChapter"),
    INTENT_SECTION(2, "IntentSection", "IntentSection");

    public static final int INTENT_DOCUMENT_VALUE = 0;
    public static final int INTENT_CHAPTER_VALUE = 1;
    public static final int INTENT_SECTION_VALUE = 2;
    private static final INDEX_ENTRY_TYPE[] VALUES_ARRAY;
    public static final List<INDEX_ENTRY_TYPE> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new INDEX_ENTRY_TYPE[]{INTENT_DOCUMENT, INTENT_CHAPTER, INTENT_SECTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static INDEX_ENTRY_TYPE get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            INDEX_ENTRY_TYPE result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static INDEX_ENTRY_TYPE getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            INDEX_ENTRY_TYPE result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static INDEX_ENTRY_TYPE get(int value) {
        switch (value) {
            case 0: {
                return INTENT_DOCUMENT;
            }
            case 1: {
                return INTENT_CHAPTER;
            }
            case 2: {
                return INTENT_SECTION;
            }
        }
        return null;
    }

    private INDEX_ENTRY_TYPE(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

