/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.launcher;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.GeneratedElementListener;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.ReadWriteRepositoryObjectHandlerImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListNotificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;

public final class SynchronizerCreator {
    private SynchronizerCreator() {
    }

    public static SynchronizerRepositoryClient createSynchronizer(Repository repository, GeneratedElementListener generatedElementListener) throws RepositoryConnectionException {
        RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
        LinkedHashSet<EObject> listenedElements = new LinkedHashSet<EObject>();
        ArrayList<String> resourcesToIgnorePaths = new ArrayList<String>();
        resourcesToIgnorePaths.add("/INTENT/");
        repositoryAdapter.setSendSessionWarningBeforeSaving(resourcesToIgnorePaths);
        repositoryAdapter.openSaveContext();
        try {
            final Resource traceabilityResource = repositoryAdapter.getOrCreateResource("/COMPILATION/TRACES/TraceabilityIndex");
            if (traceabilityResource.getContents().isEmpty()) {
                repositoryAdapter.execute(new IntentCommand(){

                    public void execute() {
                        traceabilityResource.getContents().add((Object)CompilerFactory.eINSTANCE.createTraceabilityIndex());
                    }
                });
            }
            EObject traceabilityIndex = (EObject)traceabilityResource.getContents().get(0);
            listenedElements.add(traceabilityIndex);
            ReadWriteRepositoryObjectHandlerImpl handler = new ReadWriteRepositoryObjectHandlerImpl(repositoryAdapter);
            ElementListAdapter adapter = new ElementListAdapter();
            ElementListNotificator listenedElementsNotificator = new ElementListNotificator(listenedElements, adapter, repositoryAdapter);
            handler.addNotificator((Notificator)listenedElementsNotificator);
            SynchronizerRepositoryClient synchronizerClient = new SynchronizerRepositoryClient((TraceabilityIndex)traceabilityIndex);
            synchronizerClient.addRepositoryObjectHandler((RepositoryObjectHandler)handler);
            synchronizerClient.setGeneratedElementListener(generatedElementListener);
            for (TraceabilityIndexEntry indexEntry : ((TraceabilityIndex)traceabilityIndex).getEntries()) {
                String resourceURI;
                if (indexEntry.getResourceDeclaration() == null || indexEntry.getResourceDeclaration().getUri() == null || (resourceURI = indexEntry.getResourceDeclaration().getUri().toString()) == null) continue;
                generatedElementListener.addElementToListen(URI.createURI((String)resourceURI));
            }
            repositoryAdapter.closeContext();
            return synchronizerClient;
        }
        catch (ReadOnlyException e) {
            throw new RepositoryConnectionException(e.getMessage());
        }
    }
}

