/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentPartitioner
implements IDocumentPartitioner {
    private static final Map<Pattern, Integer> KIND_BY_REGEXPS = new LinkedHashMap<Pattern, Integer>();
    private static final int SU_START_KIND = 0;
    private static final int SU_END_KIND = 1;
    private static final int MU_KIND = 2;
    protected final String[] fLegalContentTypes;
    protected IDocument document;
    private List<IntentRegion> regions = new ArrayList<IntentRegion>();

    static {
        KIND_BY_REGEXPS.put(Pattern.compile("@M((?!M@).)*M@", 40), 2);
        KIND_BY_REGEXPS.put(Pattern.compile("Document\\s*\\{\\s*", 40), 0);
        KIND_BY_REGEXPS.put(Pattern.compile("Chapter\\s*\\{\\s*", 40), 0);
        KIND_BY_REGEXPS.put(Pattern.compile("Section\\s*\\{\\s*", 40), 0);
        KIND_BY_REGEXPS.put(Pattern.compile("}\\s*", 40), 1);
    }

    public IntentPartitioner(String[] legalContentTypes) {
        this.fLegalContentTypes = TextUtilities.copy((String[])legalContentTypes);
    }

    public void connect(IDocument currentDocument) {
        this.document = currentDocument;
        this.updateRegions();
    }

    public void disconnect() {
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public String getContentType(int offset) {
        ITypedRegion region = this.getPartition(offset);
        if (region != null) {
            return region.getType();
        }
        return "__Intent__descriptionunit";
    }

    public String[] getLegalContentTypes() {
        return TextUtilities.copy((String[])this.fLegalContentTypes);
    }

    public boolean documentChanged(DocumentEvent event) {
        this.updateRegions();
        return false;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        ITypedRegion[] res = this.regions.toArray(new ITypedRegion[this.regions.size()]);
        Arrays.sort(res, new Comparator<ITypedRegion>(){

            @Override
            public int compare(ITypedRegion o1, ITypedRegion o2) {
                return Integer.valueOf(o1.getOffset()).compareTo(o2.getOffset());
            }
        });
        return res;
    }

    public ITypedRegion getPartition(int offset) {
        for (ITypedRegion iTypedRegion : this.regions) {
            if (iTypedRegion.getOffset() > offset || iTypedRegion.getOffset() + iTypedRegion.getLength() < offset) continue;
            return iTypedRegion;
        }
        return new TypedRegion(offset, 1, "__Intent__descriptionunit");
    }

    public List<IntentRegion> getRegions() {
        return this.regions;
    }

    private boolean alreadyIncluded(List<IntentRegion> existingRegions, ITypedRegion region) {
        for (IntentRegion existingRegion : existingRegions) {
            if (!existingRegion.contains(region)) continue;
            return true;
        }
        return false;
    }

    private void updateRegions() {
        ArrayList<IntentRegion> newRegions = new ArrayList<IntentRegion>();
        String text = this.document.get();
        for (Map.Entry<Pattern, Integer> regexpEntry : KIND_BY_REGEXPS.entrySet()) {
            Matcher m = regexpEntry.getKey().matcher(text);
            while (m.find()) {
                IntentRegion newRegion = this.createIntentRegion(m.start(), m.end() - m.start(), regexpEntry.getValue());
                if (this.alreadyIncluded(newRegions, (ITypedRegion)newRegion)) continue;
                newRegions.add(newRegion);
            }
        }
        Collections.sort(newRegions);
        int lastOffset = 0;
        IntentRegion lastRegion = null;
        ArrayList<IntentRegion> regionsToAdd = new ArrayList<IntentRegion>();
        for (IntentRegion region : newRegions) {
            if (region.getOffset() > lastOffset) {
                regionsToAdd.addAll(this.createDescriptionAndTitle(lastOffset, region.getOffset() - lastOffset, lastRegion));
            }
            lastOffset = region.getOffset() + region.getLength();
            lastRegion = region;
        }
        for (IntentRegion intentTokenToAdd : regionsToAdd) {
            newRegions.add(intentTokenToAdd);
        }
        Collections.sort(newRegions);
        this.regions = newRegions;
    }

    private List<IntentRegion> createDescriptionAndTitle(int offset, int length, IntentRegion previousRegion) {
        ArrayList<IntentRegion> unitRegions = new ArrayList<IntentRegion>();
        int unitOffset = offset;
        int unitLength = length;
        if (previousRegion != null && previousRegion.getKind() == 0) {
            try {
                String text = this.document.get(unitOffset, unitLength);
                String[] lines = text.split("\\n");
                if (lines.length > 2) {
                    int titleLength = lines[0].length();
                    unitRegions.add(new IntentRegion(unitOffset, titleLength, "__Intent__title"));
                    unitOffset += titleLength;
                    unitLength -= titleLength;
                }
            }
            catch (BadLocationException e) {
                IntentUiLogger.logError(e);
            }
        }
        unitRegions.add(new IntentRegion(unitOffset, unitLength, "__Intent__descriptionunit"));
        return unitRegions;
    }

    public IntentRegion createIntentRegion(int offset, int length, int kind) {
        String type = "__Intent__descriptionunit";
        switch (kind) {
            case -1: {
                break;
            }
            case 0: {
                type = "__Intent__structuralcontent";
                break;
            }
            case 1: {
                type = "__Intent__structuralcontent";
                break;
            }
            case 2: {
                type = "__Intent__modelingunit";
                break;
            }
        }
        return new IntentRegion(offset, length, type, kind);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IntentRegion
    extends TypedRegion
    implements Comparable<ITypedRegion> {
        int kind;

        public IntentRegion(int offset, int length, String type) {
            super(offset, length, type);
            this.kind = -1;
        }

        public IntentRegion(int offset, int length, String type, int kind) {
            this(offset, length, type);
            this.kind = kind;
        }

        public int getKind() {
            return this.kind;
        }

        public boolean contains(ITypedRegion o) {
            return o.getOffset() >= this.getOffset() && o.getOffset() + o.getLength() <= this.getOffset() + this.getLength();
        }

        @Override
        public int compareTo(ITypedRegion o) {
            return new Integer(this.getOffset()).compareTo(o.getOffset());
        }
    }
}

