/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.launcher;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.client.compiler.repositoryconnection.CompilerRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.ReadWriteRepositoryObjectHandlerImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.typeListener.TypeNotificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage;
import org.eclipse.mylyn.docs.intent.core.genericunit.GenericUnitPackage;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitPackage;

public final class CompilerCreator {
    private CompilerCreator() {
    }

    public static CompilerRepositoryClient createCompilerClient(Repository repository) throws RepositoryConnectionException {
        LinkedHashSet listenedTypes = new LinkedHashSet();
        for (EObject obj : ModelingUnitPackage.eINSTANCE.eContents()) {
            if (!(obj instanceof EClass)) continue;
            listenedTypes.addAll(TypeNotificator.getStructuralFeaturesForEClass((EClass)((EClass)obj)));
        }
        listenedTypes.remove(IntentDocumentPackage.eINSTANCE.getIntentGenericElement_CompilationStatus());
        listenedTypes.remove(GenericUnitPackage.eINSTANCE.getGenericUnit_Instructions());
        listenedTypes.remove(GenericUnitPackage.eINSTANCE.getGenericUnit_UnitName());
        ArrayList<String> resourcesToIgnorePaths = new ArrayList<String>();
        resourcesToIgnorePaths.add("/INTENT/");
        RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
        repositoryAdapter.setSendSessionWarningBeforeSaving(resourcesToIgnorePaths);
        ReadWriteRepositoryObjectHandlerImpl handler = new ReadWriteRepositoryObjectHandlerImpl(repositoryAdapter);
        TypeNotificator notificator = new TypeNotificator(listenedTypes);
        handler.addNotificator((Notificator)notificator);
        CompilerRepositoryClient compilerClient = new CompilerRepositoryClient();
        compilerClient.setRepository(repository);
        compilerClient.addRepositoryObjectHandler((RepositoryObjectHandler)handler);
        return compilerClient;
    }
}

