/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.repository;

import com.google.common.collect.Sets;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.ide.adapters.DefaultWorkspaceRepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.ide.adapters.WorkspaceAdapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;

public class IntentWorkspaceRepositoryStructurer
extends DefaultWorkspaceRepositoryStructurer {
    private static final String IDENTIFIER_SEPARATOR = ".";

    public void structure(RepositoryAdapter repositoryAdapter) throws ReadOnlyException {
        super.structure(repositoryAdapter);
        WorkspaceAdapter workspaceAdapter = (WorkspaceAdapter)repositoryAdapter;
        Resource documentResource = workspaceAdapter.getResource("/INTENT/IntentDocument");
        for (EObject document : documentResource.getContents()) {
            this.splitElementAndSons(workspaceAdapter, document);
        }
    }

    protected void splitElementAndSons(WorkspaceAdapter workspaceAdapter, EObject element) throws ReadOnlyException {
        if (this.isElementToSplit(element)) {
            String newResourcePath = "/INTENT/" + element.eClass().getName() + "/" + this.getIdentifierForElement(workspaceAdapter, element);
            boolean isInSameResourceThanContainer = this.isInSameResourceThanContainer(element);
            if (isInSameResourceThanContainer || !this.isStoredAtExpectedLocation(element, workspaceAdapter, newResourcePath)) {
                if (!isInSameResourceThanContainer && !(element instanceof IntentDocument)) {
                    try {
                        element.eResource().delete(null);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Resource newResource = workspaceAdapter.getOrCreateResource(newResourcePath);
                newResource.getContents().add((Object)element);
                newResource.setTrackingModification(true);
            }
            for (EObject containedElement : Sets.newLinkedHashSet((Iterable)element.eContents())) {
                this.splitElementAndSons(workspaceAdapter, containedElement);
            }
        }
    }

    private String getIdentifierForElement(WorkspaceAdapter workspaceAdapter, EObject element) {
        String proposal = "";
        if (element instanceof IntentDocument) {
            return "IntentDocument";
        }
        EObject container = element;
        while (!(container instanceof IntentDocument)) {
            proposal = container instanceof ModelingUnit ? String.valueOf(((IntentSection)container.eContainer()).getModelingUnits().indexOf((Object)container) + 1) + IDENTIFIER_SEPARATOR + proposal : (container instanceof IntentSection ? String.valueOf(((IntentSubSectionContainer)container.eContainer()).getSubSections().indexOf((Object)container) + 1) + IDENTIFIER_SEPARATOR + proposal : (container instanceof IntentChapter ? String.valueOf(((IntentDocument)container.eContainer()).getChapters().indexOf((Object)container) + 1) + IDENTIFIER_SEPARATOR + proposal : String.valueOf(container.eContainer().eContents().indexOf((Object)container) + 1) + IDENTIFIER_SEPARATOR + proposal));
            container = container.eContainer();
        }
        proposal = proposal.substring(0, proposal.length() - 1);
        return proposal;
    }

    private boolean isStoredAtExpectedLocation(EObject element, WorkspaceAdapter workspaceAdapter, String expectedResourceLocation) {
        boolean isCorrectlySplit = true;
        try {
            isCorrectlySplit = isCorrectlySplit && element.eResource() == workspaceAdapter.getResource(expectedResourceLocation, false);
        }
        catch (Exception exception) {
            isCorrectlySplit = false;
        }
        return isCorrectlySplit || element instanceof IntentDocument;
    }

    private boolean isInSameResourceThanContainer(EObject element) {
        boolean isInSameResourceThanContainer = element.eResource() == null;
        isInSameResourceThanContainer = isInSameResourceThanContainer || element.eContainer() == null;
        boolean bl = isInSameResourceThanContainer = isInSameResourceThanContainer || element.eContainer().eResource() == element.eResource();
        return isInSameResourceThanContainer && !(element instanceof IntentDocument);
    }

    protected boolean isElementToSplit(EObject element) {
        boolean isElementToSplit;
        boolean bl = isElementToSplit = element instanceof IntentDocument || element instanceof IntentChapter || element instanceof IntentSection;
        return isElementToSplit || element instanceof ModelingUnit;
    }
}

