/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.propertytester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.collab.common.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;

public class IsAssociatedToIntentDocumentTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IntentDocument document = IsAssociatedToIntentDocumentTester.getIntentDocument(receiver);
        if (document instanceof IntentIndexEntry) {
            document = ((IntentIndexEntry)document).getReferencedElement();
        }
        return document instanceof IntentDocument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntentDocument getIntentDocument(Object any) {
        IntentDocument document = null;
        if (any instanceof IProject) {
            IProject project = (IProject)any;
            RepositoryAdapter repositoryAdapter = null;
            try {
                try {
                    Repository repository = IntentRepositoryManager.INSTANCE.getRepository(project.getName());
                    if (repository == null) return document;
                    repositoryAdapter = repository.createRepositoryAdapter();
                    EList contents = repositoryAdapter.getResource("/INTENT/IntentDocument").getContents();
                    if (contents.isEmpty()) return document;
                    if (!(contents.iterator().next() instanceof IntentDocument)) return document;
                    document = (IntentDocument)contents.iterator().next();
                    return document;
                }
                catch (RepositoryConnectionException repositoryConnectionException) {
                    if (repositoryAdapter == null) return document;
                    repositoryAdapter.closeContext();
                    return document;
                }
                catch (CoreException coreException) {
                    if (repositoryAdapter == null) return document;
                    repositoryAdapter.closeContext();
                    return document;
                }
            }
            finally {
                if (repositoryAdapter != null) {
                    repositoryAdapter.closeContext();
                }
            }
        } else {
            if (!(any instanceof IAdaptable)) return document;
            if (!(((IAdaptable)any).getAdapter(EObject.class) instanceof IntentDocument)) return document;
            return (IntentDocument)((IAdaptable)any).getAdapter(EObject.class);
        }
    }
}

