/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.handlers.impl;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;

public abstract class AbstractRepositoryClient
implements RepositoryClient {
    public static final long SCHEDULE_DELAY = 500L;
    protected RepositoryObjectHandler repositoryObjectHandler;
    private Job notificationJob;

    public void addRepositoryObjectHandler(RepositoryObjectHandler handler) {
        handler.addClient(this);
        this.repositoryObjectHandler = handler;
    }

    public void removeRepositoryObjectHandler(RepositoryObjectHandler handler) {
        handler.removeClient(this);
        this.repositoryObjectHandler.stop();
        this.repositoryObjectHandler = null;
    }

    public void handleChangeNotification(RepositoryChangeNotification notification) {
        try {
            if (this.notificationJob != null) {
                this.notificationJob.cancel();
                this.notificationJob = null;
            }
            this.notificationJob = this.createNotificationJob(notification);
            this.notificationJob.schedule(500L);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    protected abstract Job createNotificationJob(RepositoryChangeNotification var1);

    public RepositoryObjectHandler getRepositoryObjectHandler() {
        return this.repositoryObjectHandler;
    }

    public void dispose() {
        if (this.notificationJob != null) {
            this.notificationJob.cancel();
            this.notificationJob = null;
        }
        this.removeRepositoryObjectHandler(this.repositoryObjectHandler);
    }
}

