/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.markup.BlockContent;
import org.eclipse.mylyn.docs.intent.markup.markup.List;
import org.eclipse.mylyn.docs.intent.markup.markup.ListItem;
import org.eclipse.mylyn.docs.intent.markup.markup.ListType;
import org.eclipse.mylyn.docs.intent.markup.markup.SimpleContainer;
import org.eclipse.mylyn.docs.intent.markup.serializer.AttributeStyleSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.SectionSerializer;
import org.eclipse.mylyn.docs.intent.markup.serializer.WikiTextElementDispatcher;

public final class ListSerializer {
    public static final String BULLETED_SYMBOL = "*";
    public static final String NUMERIC_SYMBOL = "#";
    public static final String TABLE_OF_CONTENT_SYMBOL = "{toc}";

    private ListSerializer() {
    }

    public static String render(List list, WikiTextElementDispatcher dispatcher) {
        if (ListSerializer.isTableofContent(list)) {
            return "\n\n{toc}";
        }
        String renderedForm = "";
        String prefix = ListSerializer.getPrefixFromListType(list.getListType());
        String listPrefix = "";
        int i = 0;
        while (i < list.getImbricationLevel()) {
            listPrefix = String.valueOf(listPrefix) + prefix;
            ++i;
        }
        String currentStyle = AttributeStyleSerializer.renderAttributeForBloc(list.getAttributes());
        for (BlockContent blockContent : list.getContent()) {
            renderedForm = String.valueOf(renderedForm) + (String)dispatcher.doSwitch((EObject)blockContent);
        }
        if (!"".equals(renderedForm)) {
            renderedForm = String.valueOf(listPrefix) + currentStyle + " " + renderedForm + "\n";
            currentStyle = "";
        }
        for (ListItem listItem : list.getItems()) {
            renderedForm = String.valueOf(renderedForm) + (String)dispatcher.doSwitch((EObject)listItem);
        }
        if (!(list instanceof ListItem)) {
            if (!SectionSerializer.isFirstElementOfSection(list)) {
                renderedForm = "\n" + renderedForm;
            }
            if (!ListSerializer.isContainedinSimpleContainer(list) && !SectionSerializer.isLastElementOfSection(list)) {
                renderedForm = String.valueOf(renderedForm) + "\n";
            }
        }
        return renderedForm;
    }

    private static boolean isTableofContent(List list) {
        return list.getListType().equals((Object)ListType.TABLE_OF_CONTENT);
    }

    private static boolean isContainedinSimpleContainer(List list) {
        EObject container = list.eContainer();
        return container instanceof SimpleContainer;
    }

    public static String getPrefixFromListType(ListType listType) {
        int listTypeValue = listType.getValue();
        String prefix = "";
        switch (listTypeValue) {
            case 2: {
                prefix = NUMERIC_SYMBOL;
                break;
            }
            default: {
                prefix = BULLETED_SYMBOL;
            }
        }
        return prefix;
    }
}

