/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.remote.thrift;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IMetaModelIntrospector;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IMetaModelUpdater;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.query.IAccessListener;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.core.runtime.CompositeGraphChangeListener;
import org.eclipse.hawk.core.runtime.CompositeStateListener;
import org.eclipse.hawk.core.util.DerivedAttributeParameters;
import org.eclipse.hawk.core.util.HawkProperties;
import org.eclipse.hawk.core.util.IndexedAttributeParameters;
import org.eclipse.hawk.core.util.XStreamUtils;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.service.api.Credentials;
import org.eclipse.hawk.service.api.DerivedAttributeSpec;
import org.eclipse.hawk.service.api.FailedQuery;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.HawkInstance;
import org.eclipse.hawk.service.api.HawkInstanceNotFound;
import org.eclipse.hawk.service.api.HawkQueryOptions;
import org.eclipse.hawk.service.api.HawkState;
import org.eclipse.hawk.service.api.HawkStateEvent;
import org.eclipse.hawk.service.api.IndexedAttributeSpec;
import org.eclipse.hawk.service.api.InvalidQuery;
import org.eclipse.hawk.service.api.MetamodelParserDetails;
import org.eclipse.hawk.service.api.QueryReport;
import org.eclipse.hawk.service.api.Repository;
import org.eclipse.hawk.service.api.Subscription;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.UnknownQueryLanguage;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.api.utils.ActiveMQBufferTransport;
import org.eclipse.hawk.service.remote.thrift.Activator;
import org.eclipse.hawk.service.remote.thrift.ThriftRemoteHawk;
import org.eclipse.hawk.service.remote.thrift.ThriftRemoteHawkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftRemoteModelIndexer
implements IModelIndexer,
IMetaModelIntrospector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftRemoteModelIndexer.class);
    private final String name;
    private final String location;
    private final ThriftRemoteHawkFactory factory;
    private final ThreadLocal<Hawk.Client> client;
    private final IConsole console;
    private final File parentFolder;
    private final ICredentialsStore credStore;
    private String dbType;
    private final List<String> enabledPlugins;
    private ScheduledExecutorService executor;
    private final CompositeStateListener stateListener = new CompositeStateListener();
    private org.eclipse.hawk.service.artemis.consumer.Consumer artemisConsumer;

    public ThriftRemoteModelIndexer(String name, String location, ThriftRemoteHawkFactory factory, File parentFolder, Supplier<Hawk.Client> clientSupplier, ICredentialsStore credStore, IConsole console, List<String> enabledPlugins) throws IOException {
        this.name = name;
        this.location = location;
        this.factory = factory;
        this.client = ThreadLocal.withInitial(clientSupplier);
        this.credStore = credStore;
        this.console = console;
        this.parentFolder = parentFolder;
        this.enabledPlugins = enabledPlugins;
        this.createDummyProperties(parentFolder);
        try {
            this.connectToArtemis();
        }
        catch (ConnectException | TTransportException ex) {
            LOGGER.warn("Hawk index {} is not running at {}: cannot connect", (Object)name, (Object)location);
        }
    }

    private void createDummyProperties(File parentFolder) throws IOException {
        if (parentFolder.exists()) {
            return;
        }
        parentFolder.mkdirs();
        HawkProperties props = new HawkProperties();
        props.setDbType("dummy");
        props.setMonitoredVCS(new ArrayList());
        XStream stream = XStreamUtils.createXStreamLoader((Class[])new Class[]{HawkProperties.class});
        String out = stream.toXML((Object)props);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter b = new BufferedWriter(new FileWriter(this.getParentFolder() + File.separator + "properties.xml"));){
            b.write(out);
            b.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void requestImmediateSync() throws Exception {
        this.client.get().syncInstance(this.name, false);
    }

    public void shutdown(IModelIndexer.ShutdownRequestType type) throws Exception {
        if (type == IModelIndexer.ShutdownRequestType.ALWAYS) {
            this.client.get().stopInstance(this.name);
        }
        this.artemisConsumer.closeSession();
    }

    public void delete() throws Exception {
        this.client.get().removeInstance(this.name);
        this.artemisConsumer.closeSession();
    }

    public IGraphDatabase getGraph() {
        this.console.printerrln("Graph is not accessible for " + ThriftRemoteHawk.class.getName());
        return null;
    }

    public Set<IVcsManager> getRunningVCSManagers() {
        try {
            List repositories = this.client.get().listRepositories(this.name);
            HashSet<IVcsManager> dummies = new HashSet<IVcsManager>();
            for (Repository repo : repositories) {
                dummies.add(new DummyVcsManager(repo.uri, repo.type));
            }
            return dummies;
        }
        catch (TException e) {
            this.console.printerrln((Throwable)e);
            return Collections.emptySet();
        }
    }

    public Set<String> getKnownMMUris() {
        try {
            return new HashSet<String>(this.client.get().listMetamodels(this.name));
        }
        catch (TException e) {
            this.console.printerrln((Throwable)e);
            return Collections.emptySet();
        }
    }

    public String getId() {
        return this.name;
    }

    public void registerMetamodels(File ... files) throws Exception {
        ArrayList<org.eclipse.hawk.service.api.File> thriftFiles = new ArrayList<org.eclipse.hawk.service.api.File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            thriftFiles.add(APIUtils.convertJavaFileToThriftFile((File)f));
            ++n2;
        }
        this.client.get().registerMetamodels(this.name, thriftFiles);
    }

    public IConsole getConsole() {
        return this.console;
    }

    public void addVCSManager(IVcsManager vcs, boolean persist) {
        try {
            ICredentialsStore.Credentials storedCredentials = this.getCredentialsStore().get(vcs.getLocation());
            Credentials credentials = null;
            if (storedCredentials != null) {
                credentials = new Credentials();
                credentials.setUsername(storedCredentials.getUsername());
                credentials.setPassword(storedCredentials.getPassword());
            }
            Repository repo = new Repository(vcs.getLocation(), vcs.getType());
            repo.setIsFrozen(false);
            this.client.get().addRepository(this.name, repo, credentials);
        }
        catch (Exception e) {
            this.console.printerrln("Could not add the specified repository");
            this.console.printerrln((Throwable)e);
        }
    }

    public void addModelUpdater(IModelUpdater updater) {
        this.console.printerrln("Cannot add model updaters to " + this.getClass().getName());
    }

    public void addMetaModelResourceFactory(IMetaModelResourceFactory metaModelParser) {
        this.console.printerrln("Cannot add metamodel resource factories to " + this.getClass().getName());
    }

    public void addModelResourceFactory(IModelResourceFactory modelParser) {
        this.console.printerrln("Cannot add model resource factories to " + this.getClass().getName());
    }

    public void setDB(IGraphDatabase db, boolean persist) {
        this.setDBType(db.getClass().getCanonicalName());
    }

    public void addQueryEngine(IQueryEngine q) {
        this.console.printerrln("Cannot add query engines to " + this.getClass().getName());
    }

    public void init(int minDelay, int maxDelay) throws Exception {
        try {
            this.client.get().startInstance(this.name);
        }
        catch (HawkInstanceNotFound ex) {
            String factoryName = this.factory.getFactoryName();
            this.client.get().createInstance(this.name, this.dbType, minDelay, maxDelay, this.enabledPlugins, factoryName);
        }
        this.connectToArtemis();
    }

    protected void connectToArtemis() throws TTransportException, ConnectException {
        try {
            HawkState currentState = HawkState.RUNNING;
            String currentInfo = "";
            for (HawkInstance instance : this.client.get().listInstances()) {
                if (!this.name.equals(instance.getName())) continue;
                currentState = instance.getState();
                currentInfo = instance.getMessage();
            }
            ICredentialsStore.Credentials creds = HManager.getInstance().getCredentialsStore().get(this.location);
            if (this.artemisConsumer == null) {
                Subscription subState = this.client.get().watchStateChanges(this.name);
                this.artemisConsumer = APIUtils.connectToArtemis((Subscription)subState, (SubscriptionDurability)SubscriptionDurability.TEMPORARY);
            }
            if (!this.artemisConsumer.isSessionOpen()) {
                if (creds != null) {
                    this.artemisConsumer.openSession(creds.getUsername(), creds.getPassword());
                } else {
                    this.artemisConsumer.openSession(null, null);
                }
                this.artemisConsumer.processChangesAsync((MessageHandler)new StatePropagationConsumer(currentState, currentInfo));
            }
        }
        catch (HawkInstanceNotFound currentState) {
        }
        catch (ConnectException | TTransportException ex) {
            throw ex;
        }
        catch (Exception e) {
            Activator.logError(e);
        }
    }

    public Collection<IModelResourceFactory> getModelParsers() {
        LOGGER.warn("Cannot access model parsers in {}", (Object)this.getClass().getName());
        return Collections.emptyList();
    }

    public Collection<IMetaModelResourceFactory> getMetaModelParsers() {
        LOGGER.warn("Cannot access metamodel parsers in {}", (Object)this.getClass().getName());
        return Collections.emptyList();
    }

    public IMetaModelResourceFactory getMetaModelParser(String metaModelType) {
        LOGGER.warn("Cannot access metamodel parsers in {}", (Object)this.getClass().getName());
        return null;
    }

    public Map<String, IQueryEngine> getKnownQueryLanguages() {
        try {
            HashMap<String, IQueryEngine> dummyMap = new HashMap<String, IQueryEngine>();
            for (String language : this.client.get().listQueryLanguages(this.name)) {
                dummyMap.put(language, new RemoteQueryEngine(language));
            }
            return dummyMap;
        }
        catch (TException e) {
            this.console.printerrln("Could not retrieve the known query languages");
            this.console.printerrln((Throwable)e);
            return Collections.emptyMap();
        }
    }

    public File getParentFolder() {
        return this.parentFolder;
    }

    public IMetaModelUpdater getMetaModelUpdater() {
        this.console.printerrln("Cannot check the metamodel updater in " + this.getClass().getName());
        return null;
    }

    public void setMetaModelUpdater(IMetaModelUpdater metaModelUpdater) {
        this.console.printerrln("Cannot change the metamodel updater in " + this.getClass().getName());
    }

    public void addDerivedAttribute(String metamodeluri, String typename, String attributename, String attributetype, boolean isMany, boolean isOrdered, boolean isUnique, String derivationlanguage, String derivationlogic) {
        DerivedAttributeSpec spec = new DerivedAttributeSpec();
        spec.setMetamodelUri(metamodeluri);
        spec.setTypeName(typename);
        spec.setAttributeName(attributename);
        spec.setAttributeType(attributetype);
        spec.setIsMany(isMany);
        spec.setIsOrdered(isOrdered);
        spec.setIsUnique(isUnique);
        spec.setDerivationLanguage(derivationlanguage);
        spec.setDerivationLogic(derivationlogic);
        try {
            this.client.get().addDerivedAttribute(this.name, spec);
        }
        catch (TException e) {
            this.console.printerrln("Could not add derived attribute");
            this.console.printerrln((Throwable)e);
        }
    }

    public void addIndexedAttribute(String metamodeluri, String typename, String attributename) {
        IndexedAttributeSpec spec = new IndexedAttributeSpec();
        spec.setMetamodelUri(metamodeluri);
        spec.setTypeName(typename);
        spec.setAttributeName(attributename);
        try {
            this.client.get().addIndexedAttribute(this.name, spec);
        }
        catch (TException e) {
            this.console.printerrln("Could not add indexed attribute");
            this.console.printerrln((Throwable)e);
        }
    }

    public Collection<IndexedAttributeParameters> getDerivedAttributes() {
        ArrayList<IndexedAttributeParameters> attrs = new ArrayList<IndexedAttributeParameters>();
        try {
            for (DerivedAttributeSpec spec : this.client.get().listDerivedAttributes(this.name)) {
                DerivedAttributeParameters params = new DerivedAttributeParameters(spec.metamodelUri, spec.typeName, spec.attributeName, spec.attributeType, spec.isMany, spec.isOrdered, spec.isUnique, spec.derivationLanguage, spec.derivationLogic);
                attrs.add((IndexedAttributeParameters)params);
            }
        }
        catch (TException e) {
            this.console.printerrln("Could not list the derived attributes");
            this.console.printerrln((Throwable)e);
        }
        return attrs;
    }

    public Collection<IndexedAttributeParameters> getIndexedAttributes() {
        ArrayList<IndexedAttributeParameters> attrs = new ArrayList<IndexedAttributeParameters>();
        try {
            for (IndexedAttributeSpec spec : this.client.get().listIndexedAttributes(this.name)) {
                IndexedAttributeParameters params = new IndexedAttributeParameters(spec.metamodelUri, spec.typeName, spec.attributeName);
                attrs.add(params);
            }
        }
        catch (TException e) {
            this.console.printerrln("Could not list the derived attributes");
            this.console.printerrln((Throwable)e);
        }
        return attrs;
    }

    public Collection<String> getIndexes() {
        return Collections.emptyList();
    }

    public List<String> validateExpression(String derivationlanguage, String derivationlogic) {
        return this.getKnownQueryLanguages().get(derivationlanguage).validate(derivationlogic);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRunning() {
        try {
            this.connectToArtemis();
            for (HawkInstance instance : this.client.get().listInstances()) {
                if (!instance.name.equals(this.name)) continue;
                return instance.state != HawkState.STOPPED;
            }
        }
        catch (ConnectException | TTransportException ex) {
            LOGGER.warn("Hawk index {} is not running at {}: cannot connect", (Object)this.name, (Object)this.location);
            return false;
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean addGraphChangeListener(IGraphChangeListener changeListener) {
        return false;
    }

    public boolean removeGraphChangeListener(IGraphChangeListener changeListener) {
        return false;
    }

    public CompositeGraphChangeListener getCompositeGraphChangeListener() {
        return null;
    }

    public void setSyncMetricsEnabled(Boolean enable) {
    }

    public void removeMetamodels(String ... metamodelURIs) throws Exception {
        this.client.get().unregisterMetamodels(this.name, Arrays.asList(metamodelURIs));
    }

    public ICredentialsStore getCredentialsStore() {
        return this.credStore;
    }

    public String getDBType() {
        return this.dbType;
    }

    public void setDBType(String dbtype) {
        this.dbType = dbtype;
    }

    public boolean addStateListener(IStateListener l) {
        return this.stateListener.add(l);
    }

    public boolean removeStateListener(IStateListener l) {
        return this.stateListener.remove((Object)l);
    }

    public CompositeStateListener getCompositeStateListener() {
        return this.stateListener;
    }

    public String getDerivedAttributeExecutionEngine() {
        return null;
    }

    public void removeVCSManager(IVcsManager vcs) throws Exception {
        this.client.get().removeRepository(this.name, vcs.getLocation());
    }

    public void setPolling(int base, int max) {
        try {
            this.client.get().configurePolling(this.name, base, max);
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean removeIndexedAttribute(String metamodelUri, String typename, String attributename) {
        IndexedAttributeSpec spec = new IndexedAttributeSpec();
        spec.setMetamodelUri(metamodelUri);
        spec.setTypeName(typename);
        spec.setAttributeName(attributename);
        try {
            this.client.get().removeIndexedAttribute(this.name, spec);
            return true;
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean removeDerivedAttribute(String metamodelUri, String typeName, String attributeName) {
        DerivedAttributeSpec spec = new DerivedAttributeSpec();
        spec.setMetamodelUri(metamodelUri);
        spec.setTypeName(typeName);
        spec.setAttributeName(attributeName);
        try {
            this.client.get().removeDerivedAttribute(this.name, spec);
            return true;
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void waitFor(IStateListener.HawkState targetState) throws InterruptedException {
        this.waitFor(targetState, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(IStateListener.HawkState targetState, long timeoutMillis) throws InterruptedException {
        CompositeStateListener compositeStateListener = this.stateListener;
        synchronized (compositeStateListener) {
            long end = System.currentTimeMillis() + timeoutMillis;
            IStateListener.HawkState s = this.stateListener.getCurrentState();
            while (s != targetState) {
                if (s == IStateListener.HawkState.STOPPED) {
                    throw new IllegalStateException("The selected Hawk is stopped");
                }
                if (timeoutMillis == 0L) {
                    this.stateListener.wait();
                } else {
                    long remaining = end - System.currentTimeMillis();
                    if (remaining <= 0L) break;
                    this.stateListener.wait(remaining);
                }
                s = this.stateListener.getCurrentState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ScheduledFuture<T> scheduleTask(Callable<T> task, long delayMillis) {
        ThriftRemoteModelIndexer thriftRemoteModelIndexer = this;
        synchronized (thriftRemoteModelIndexer) {
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadScheduledExecutor();
            }
        }
        return this.executor.schedule(task, delayMillis, TimeUnit.MILLISECONDS);
    }

    public Set<String> getKnownMetamodelFileExtensions() {
        try {
            List details = this.client.get().listMetamodelParsers(this.name);
            HashSet<String> extensions = new HashSet<String>();
            for (MetamodelParserDetails e : details) {
                extensions.addAll(e.getFileExtensions());
            }
            return extensions;
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public Set<String> getKnownMetaModelParserTypes() {
        try {
            List details = this.client.get().listMetamodelParsers(this.name);
            HashSet<String> types = new HashSet<String>();
            for (MetamodelParserDetails e : details) {
                types.add(e.getIdentifier());
            }
            return types;
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public List<IModelUpdater> getModelUpdaters() {
        this.console.printerrln("Cannot access updaters in " + this.getClass().getName());
        return null;
    }

    public List<String> getMetamodels() {
        try {
            return this.client.get().listMetamodels(this.name);
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> getTypes(String metamodelURI) throws NoSuchElementException {
        try {
            return this.client.get().listTypeNames(this.name, metamodelURI);
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> getAttributes(String metamodelURI, String typeName) throws NoSuchElementException {
        try {
            return this.client.get().listAttributeNames(this.name, metamodelURI, typeName);
        }
        catch (TException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void removeMetaModelResourceFactory(IMetaModelResourceFactory metaModelParser) {
        this.console.printerrln("Cannot remove metamodel resource factories to " + this.getClass().getName());
    }

    public void removeModelResourceFactory(IModelResourceFactory modelParser) {
        this.console.printerrln("Cannot remove model resource factories to " + this.getClass().getName());
    }

    public void removeModelUpdater(IModelUpdater updater) throws Exception {
        this.console.printerrln("Cannot remove model updaters to " + this.getClass().getName());
    }

    private final class DummyVcsManager
    implements IVcsManager {
        private final String location;
        private final String type;

        private DummyVcsManager(String location, String type) {
            this.location = location;
            this.type = type;
        }

        public File importFile(String revision, String path, File temp) {
            return null;
        }

        public boolean isActive() {
            return true;
        }

        public void shutdown() {
        }

        public String getLocation() {
            return this.location;
        }

        public String getType() {
            return this.type;
        }

        public String getHumanReadableName() {
            return this.location;
        }

        public String getCurrentRevision() throws Exception {
            return null;
        }

        public List<VcsCommitItem> getDelta(String string) throws Exception {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DummyVcsManager other = (DummyVcsManager)obj;
            return !(this.location == null ? other.location != null : !this.location.equals(other.location));
        }

        public boolean isAuthSupported() {
            return true;
        }

        public boolean isPathLocationAccepted() {
            return true;
        }

        public boolean isURLLocationAccepted() {
            return true;
        }

        public void setCredentials(String username, String password, ICredentialsStore credStore) {
            try {
                credStore.put(this.location, new ICredentialsStore.Credentials(username, password));
                ((Hawk.Client)ThriftRemoteModelIndexer.this.client.get()).updateRepositoryCredentials(ThriftRemoteModelIndexer.this.name, this.location, new Credentials(username, password));
            }
            catch (Exception e) {
                ThriftRemoteModelIndexer.this.console.printerrln((Throwable)e);
            }
        }

        public String getFirstRevision() throws Exception {
            return null;
        }

        public VcsRepositoryDelta getDelta(String startRevision, String endRevision) throws Exception {
            return null;
        }

        public void init(String vcsloc, IModelIndexer indexer) throws Exception {
        }

        public void run() throws Exception {
        }

        public String getRepositoryPath(String rawPath) {
            return rawPath;
        }

        public String getUsername() {
            try {
                ICredentialsStore.Credentials credentials = ThriftRemoteModelIndexer.this.getCredentialsStore().get(this.location);
                if (credentials != null) {
                    return credentials.getUsername();
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not retrieve username from credentials store", (Throwable)e);
            }
            return null;
        }

        public String getPassword() {
            try {
                ICredentialsStore.Credentials credentials = ThriftRemoteModelIndexer.this.getCredentialsStore().get(this.location);
                if (credentials != null) {
                    return credentials.getPassword();
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not retrieve password from credentials store", (Throwable)e);
            }
            return null;
        }

        public boolean isFrozen() {
            try {
                return ((Hawk.Client)ThriftRemoteModelIndexer.this.client.get()).isFrozen(ThriftRemoteModelIndexer.this.name, this.location);
            }
            catch (TException e) {
                LOGGER.error(String.format("Could not retrieve frozen state of repository %s from remote Hawk %s", ThriftRemoteModelIndexer.this.name, this.location), (Throwable)e);
                return false;
            }
        }

        public void setFrozen(boolean f) {
            try {
                ((Hawk.Client)ThriftRemoteModelIndexer.this.client.get()).setFrozen(ThriftRemoteModelIndexer.this.name, this.location, f);
            }
            catch (TException e) {
                LOGGER.error(String.format("Could not change frozen state of repository %s of remote Hawk %s", ThriftRemoteModelIndexer.this.name, this.location), (Throwable)e);
            }
        }

        public String getDefaultLocation() {
            return "";
        }
    }

    private final class RemoteQueryEngine
    implements IQueryEngine {
        private final String language;
        private String defaultNamespaces = "";

        private RemoteQueryEngine(String language) {
            this.language = language;
        }

        public List<String> validate(String derivationlogic) {
            return Collections.emptyList();
        }

        public String getType() {
            return this.language;
        }

        public Object query(IModelIndexer m, String query, Map<String, Object> context) throws InvalidQueryException, QueryExecutionException {
            String sRepoScope;
            if (context == null) {
                context = Collections.emptyMap();
            }
            if ((sRepoScope = (String)context.get("REPOSITORY")) == null) {
                sRepoScope = "*";
            }
            String sFileScope = (String)context.get("FILE");
            ArrayList<String> filePatterns = new ArrayList<String>();
            if (sFileScope == null) {
                filePatterns.add("*");
            } else {
                String[] sFilePatterns;
                String[] stringArray = sFilePatterns = sFileScope.split(",");
                int n = sFilePatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String sFilePattern = stringArray[n2];
                    filePatterns.add(sFilePattern);
                    ++n2;
                }
            }
            try {
                HawkQueryOptions opts = new HawkQueryOptions();
                if (context.containsKey("DEFAULTNAMESPACES")) {
                    opts.setDefaultNamespaces((String)context.get("DEFAULTNAMESPACES"));
                } else {
                    opts.setDefaultNamespaces(this.defaultNamespaces);
                }
                opts.setRepositoryPattern(sRepoScope);
                opts.setFilePatterns(filePatterns);
                opts.setIncludeAttributes(true);
                opts.setIncludeReferences(true);
                opts.setIncludeNodeIDs(true);
                opts.setIncludeContained(false);
                String uuid = ((Hawk.Client)ThriftRemoteModelIndexer.this.client.get()).asyncQuery(ThriftRemoteModelIndexer.this.name, query, this.language, opts);
                if (context.containsKey("EXEC_CANCEL_CONSUMER")) {
                    Consumer consumer = (Consumer)context.get("EXEC_CANCEL_CONSUMER");
                    consumer.accept(() -> {
                        try {
                            ((Hawk.Client)ThriftRemoteModelIndexer.this.client.get()).cancelAsyncQuery(uuid);
                        }
                        catch (TException e) {
                            LOGGER.error("Failed to cancel query " + uuid, (Throwable)e);
                        }
                    });
                }
                QueryReport result = ((Hawk.Client)ThriftRemoteModelIndexer.this.client.get()).fetchAsyncQueryResults(uuid);
                return result;
            }
            catch (InvalidQuery | UnknownQueryLanguage ex) {
                throw new InvalidQueryException(ex);
            }
            catch (FailedQuery ex) {
                throw new QueryExecutionException((Throwable)ex);
            }
            catch (TException e) {
                ThriftRemoteModelIndexer.this.console.printerrln("Could not run contextful query");
                ThriftRemoteModelIndexer.this.console.printerrln((Throwable)e);
                return e;
            }
        }

        public IAccessListener calculateDerivedAttributes(IModelIndexer m, Iterable<IGraphNode> nodes) throws InvalidQueryException, QueryExecutionException {
            return null;
        }

        public void setDefaultNamespaces(String defaultNamespaces) {
            this.defaultNamespaces = defaultNamespaces;
        }

        public String getHumanReadableName() {
            return "Thrift-based remote query engine";
        }
    }

    private final class StatePropagationConsumer
    implements MessageHandler {
        private long currentTimestamp = 0L;
        private HawkState currentState;
        private String currentInfo;

        public StatePropagationConsumer(HawkState state, String info) {
            this.currentState = state;
            this.currentInfo = info;
            this.fireState();
            this.fireInfo();
        }

        public void onMessage(ClientMessage message) {
            TProtocol proto = APIUtils.ThriftProtocol.JSON.getProtocolFactory().getProtocol((TTransport)new ActiveMQBufferTransport(message.getBodyBuffer()));
            HawkStateEvent change = new HawkStateEvent();
            try {
                change.read(proto);
                if (message.getTimestamp() < this.currentTimestamp) {
                    return;
                }
                this.currentTimestamp = message.getTimestamp();
                if (change.getState() != this.currentState) {
                    this.currentState = change.getState();
                    this.fireState();
                }
                if (!change.getMessage().equals(this.currentInfo)) {
                    this.currentInfo = change.getMessage();
                    this.fireInfo();
                }
            }
            catch (Exception ex) {
                Activator.logError(ex);
            }
        }

        protected void fireInfo() {
            ThriftRemoteModelIndexer.this.getCompositeStateListener().info(this.currentInfo);
        }

        protected void fireState() {
            switch (this.currentState) {
                case RUNNING: {
                    ThriftRemoteModelIndexer.this.stateListener.state(IStateListener.HawkState.RUNNING);
                    break;
                }
                case STOPPED: {
                    ThriftRemoteModelIndexer.this.stateListener.state(IStateListener.HawkState.STOPPED);
                    break;
                }
                case UPDATING: {
                    ThriftRemoteModelIndexer.this.stateListener.state(IStateListener.HawkState.UPDATING);
                }
            }
        }
    }
}

