/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.handlers;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.utils.ServerMessageUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class IdeActionHandler
extends AbstractHandler {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPartSite partSite = HandlerUtil.getActivePart((ExecutionEvent)event).getSite();
        IEclipseContext context = (IEclipseContext)partSite.getService(IEclipseContext.class);
        this.execute(context);
        return null;
    }

    protected abstract void execute(IEclipseContext var1);

    protected void dispatchMessage(IEclipseContext context, Action action) {
        ActionDispatcher dispatcher = (ActionDispatcher)context.get(ActionDispatcher.class);
        String clientId = (String)context.get("GLSP_CLIENT_ID");
        Optional<GLSPClient> client = Optional.ofNullable((GLSPClient)context.get(GLSPClient.class));
        dispatcher.dispatch(action).exceptionally(ex -> this.handleError((Throwable)ex, client, clientId, action));
    }

    protected <T> Optional<T> getInstance(IEclipseContext context, Class<T> type) {
        IEditorPart editor = (IEditorPart)context.get(IEditorPart.class);
        return editor instanceof GLSPDiagramEditor ? Optional.ofNullable(((GLSPDiagramEditor)editor).getInjector().getInstance(type)) : Optional.empty();
    }

    protected Optional<GModelState> getModelState(IEclipseContext context) {
        return this.getInstance(context, GModelState.class);
    }

    protected Void handleError(Throwable ex, Optional<GLSPClient> client, String clientId, Action action) {
        String errorMsg = "Could not process action:" + action;
        this.log.error((Object)("[ERROR] " + errorMsg), ex);
        client.ifPresent(c -> c.process(new ActionMessage(clientId, (Action)ServerMessageUtil.error((String)("[GLSP-Server] " + errorMsg), (Throwable)ex))));
        return null;
    }
}

