/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.handlers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.glsp.ide.editor.handlers.IdeActionHandler;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ExternalBrowserDebugHandler
extends IdeActionHandler {
    private static Logger LOG = Logger.getLogger(ExternalBrowserDebugHandler.class);

    @Override
    protected void execute(IEclipseContext context) {
        String clientId = (String)context.get("GLSP_CLIENT_ID");
        Optional<GLSPDiagramEditor> editor = GLSPIdeEditorPlugin.getDefault().getGLSPEditorRegistry().getGLSPEditor(clientId);
        if (editor.isPresent()) {
            String url = editor.get().getBrowserUrl();
            this.openInExternalBrowser(url);
            return;
        }
        LOG.warn((Object)"Execute failed, could not retrieve active GLSPDiagramEditor");
    }

    protected void openInExternalBrowser(String url) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
        }
        catch (MalformedURLException | PartInitException e) {
            LOG.error((Object)("Could not open url in external browser. Url: " + url), e);
        }
    }
}

