/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.pptx;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.eclipse.gendoc.document.parser.documents.openoffice.OpenOfficeDocument;
import org.eclipse.gendoc.document.parser.pptx.PPTXParser;
import org.w3c.dom.Node;

public class PPTXDocument
extends OpenOfficeDocument {
    public PPTXDocument(File documentFile) throws IOException {
        this(documentFile.toURI().toURL(), null);
    }

    public PPTXDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) throws IOException {
        this(documentFile.toURI().toURL(), configuration);
    }

    public PPTXDocument(URL documentFile, Map<Document.CONFIGURATION, Boolean> configuration) {
        super(documentFile, configuration);
    }

    protected Collection<XMLParser> getXmlParsers(Document.CONFIGURATION idForDocument) {
        LinkedList<XMLParser> parsers = new LinkedList<XMLParser>();
        switch (idForDocument) {
            case content: {
                PPTXParser presentation = new PPTXParser(this, this.getUnzipper().getFile("presentation.xml"), idForDocument);
                parsers.add((XMLParser)presentation);
                break;
            }
            case footer: {
                break;
            }
        }
        return parsers;
    }

    public String getTextCorrespondingToCurrentStyle() {
        return null;
    }

    public String getText() {
        StringBuffer result = new StringBuffer("");
        Node n = this.getXMLParser().getCurrentNode();
        if ("a:p".equals(n.getNodeName())) {
            Node tmp = XMLHelper.next((Node)n);
            while (tmp != null && !"a:p".equals(tmp.getNodeName())) {
                if ("a:t".equals(tmp.getNodeName())) {
                    result.append(tmp.getTextContent());
                }
                tmp = XMLHelper.next((Node)tmp);
            }
        }
        return result.toString();
    }

    public Object get(Document.PROPERTY property) {
        switch (property) {
            case text: {
                return this.getText();
            }
        }
        return null;
    }
}

