/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.services.AbstractExtension;
import org.eclipse.gendoc.services.IService;
import org.eclipse.gendoc.services.ServiceExtension;
import org.eclipse.gendoc.services.ServiceTypesExtensionPoint;
import org.eclipse.gendoc.services.ServicesExtensionPoint;
import org.eclipse.gendoc.services.exception.ServiceException;

class ServiceTypeExtension
extends AbstractExtension {
    private final String id;
    private final String interfaceName;
    private List<ServiceExtension> serviceExtensions;
    private ServiceExtension defaultServiceExtension;
    private Class<? extends IService> interfaceClass;

    public ServiceTypeExtension(IConfigurationElement configElement) {
        super(configElement);
        this.id = this.parseStringAttribute(configElement, ServiceTypesExtensionPoint.SERVICE_TYPE_ID, true);
        this.interfaceName = this.parseStringAttribute(configElement, ServiceTypesExtensionPoint.SERVICE_TYPE_INTERFACE, true);
    }

    public ServiceExtension getDefaultServiceExtension() throws ServiceException {
        if (this.defaultServiceExtension == null) {
            boolean found = false;
            int prio = 0;
            for (ServiceExtension serviceExtension : this.getServiceExtensions()) {
                if (serviceExtension.getPriority() > prio) {
                    prio = serviceExtension.getPriority();
                    this.defaultServiceExtension = serviceExtension;
                }
                if (prio != 0 || !serviceExtension.isDefault()) continue;
                if (!found) {
                    this.defaultServiceExtension = serviceExtension;
                    found = true;
                    continue;
                }
                throw new ServiceException("Multiple service extensions declared as default for serviceType " + this.getId());
            }
            if (prio == 0 && !found) {
                throw new ServiceException("No default service found for serviceType " + this.getId());
            }
        }
        return this.defaultServiceExtension;
    }

    public String getId() {
        return this.id;
    }

    public Class<? extends IService> getInterface() {
        try {
            this.interfaceClass = this.getClass().getClassLoader().loadClass(this.interfaceName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                this.interfaceClass = Platform.getBundle((String)this.getConfigElement().getContributor().getName()).loadClass(this.interfaceName);
            }
            catch (InvalidRegistryObjectException e1) {
                throw new RuntimeException("Unable to create service type interface '" + this.interfaceName + ".", e1);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("Unable to create service type interface '" + this.interfaceName + ".", e1);
            }
            catch (ClassCastException e3) {
                throw new RuntimeException("Unable to create service type interface '" + this.interfaceName + ".", e3);
            }
        }
        return this.interfaceClass;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public List<ServiceExtension> getServiceExtensions() {
        if (this.serviceExtensions == null) {
            this.serviceExtensions = new ArrayList<ServiceExtension>();
            for (ServiceExtension serviceExtension : ServicesExtensionPoint.getDefault().getServiceExtensions()) {
                if (!serviceExtension.getServiceTypeId().equals(this.id)) continue;
                this.serviceExtensions.add(serviceExtension);
            }
        }
        Collections.sort(this.serviceExtensions, new Comparator<ServiceExtension>(){

            @Override
            public int compare(ServiceExtension o1, ServiceExtension o2) {
                return Integer.compare(o2.getPriority(), o1.getPriority());
            }
        });
        return this.serviceExtensions;
    }
}

