/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.openoffice;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public class OpenOfficeNamespaceContext
implements NamespaceContext {
    private final String[] mapping;
    private final String prefixMapping;

    public OpenOfficeNamespaceContext(String[] mapping) {
        this.mapping = mapping;
        StringBuffer buf = new StringBuffer();
        buf.append("xmlns=\"").append(mapping[1]).append("\" ");
        int i = 2;
        while (i < mapping.length) {
            buf.append("xmlns:").append(mapping[i]).append("=\"").append(mapping[i + 1]).append("\" ");
            i += 2;
        }
        this.prefixMapping = buf.toString().trim();
    }

    public final String getPrefixMapping() {
        return this.prefixMapping;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null || prefix.equals("")) {
            return this.mapping[1];
        }
        int i = 2;
        while (i < this.mapping.length) {
            if (prefix.equals(this.mapping[i])) {
                return this.mapping[i + 1];
            }
            i += 2;
        }
        return "";
    }

    @Override
    public String getPrefix(String uri) {
        int i = 0;
        while (i < this.mapping.length) {
            if (uri.equals(this.mapping[i + 1])) {
                return this.mapping[i];
            }
            i += 2;
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        return new Iterator<String>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < OpenOfficeNamespaceContext.this.mapping.length;
            }

            @Override
            public String next() {
                String str = OpenOfficeNamespaceContext.this.mapping[this.pos];
                this.pos += 2;
                return str;
            }
        };
    }
}

