/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.batch;

import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gendoc.GendocProcess;
import org.eclipse.gendoc.batch.ArgOpt;
import org.eclipse.gendoc.batch.GetOpt;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.IProgressMonitorService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;

public class GendocBatchModeRunnableApplication
implements IApplication {
    private boolean validArguments = true;
    public static Logger logger = Logger.getRootLogger();
    private ArgOpt inputDocArg = new ArgOpt("input_DocTemplate", 0, 1, "idt", "input document template URL ");
    private String argDocTemplate = "";

    public Object start(IApplicationContext context) throws Exception {
        Display.getDefault().wake();
        this.setupWorkbench();
        String[] args = (String[])context.getArguments().get("application.args");
        GetOpt getOpt = new GetOpt();
        String argFlat = getOpt.getFlatArguments(args);
        ArgOpt[] listOpts = new ArgOpt[]{this.inputDocArg};
        HashMap<Object, Object> parameters = new HashMap();
        if (argFlat.indexOf("--help") >= 0 || argFlat.indexOf("-h") >= 0) {
            getOpt.printHelp(listOpts);
            this.validArguments = false;
        } else {
            parameters = getOpt.getArguments(listOpts, args);
            if (GetOpt.error == null || GetOpt.error.length() > 0) {
                System.out.println(GetOpt.error);
                this.validArguments = false;
            }
        }
        if (this.validArguments) {
            this.argDocTemplate = (String)parameters.get("input_DocTemplate");
            try {
                logger.log((Priority)Level.INFO, (Object)"Starting the batch mode...");
                logger.log((Priority)Level.INFO, (Object)"---------------------");
                File templateDoc = new File(this.argDocTemplate);
                String templateName = templateDoc.getName();
                if (!templateDoc.exists()) {
                    throw new Exception("Your input document does not exist ");
                }
                if (!templateDoc.isDirectory()) {
                    boolean isSupported;
                    boolean bl = isSupported = templateName.substring(templateName.lastIndexOf(".")).equalsIgnoreCase(".docx") || templateName.substring(templateName.lastIndexOf(".")).equalsIgnoreCase(".odt");
                    if (!isSupported) {
                        throw new Exception("Your input document is not supported");
                    }
                }
                IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                diagnostician.init();
                IProgressMonitorService service = (IProgressMonitorService)GendocServices.getDefault().getService(IProgressMonitorService.class);
                service.setMonitor((IProgressMonitor)new NullProgressMonitor());
                GendocProcess process = new GendocProcess();
                String resultFile = process.runProcess(templateDoc);
                this.handleDiagnostic(diagnostician.getResultDiagnostic(), "The file has been generated but contains errors :\n", resultFile);
            }
            catch (Exception e) {
                logger.log((Priority)Level.INFO, (Object)"\n$$$$$$$$$$$$$--ERROR--$$$$$$$$$$$$$");
                String message = " Exception occured in the generation ";
                if (e.getMessage() != null) {
                    message = String.valueOf(message) + ": " + e.getMessage();
                }
                if (e.getCause() != null) {
                    message = String.valueOf(message) + "::" + e.getCause();
                }
                logger.log((Priority)Level.ERROR, (Object)message);
                logger.log((Priority)Level.INFO, (Object)"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n");
            }
        }
        this.stop();
        return EXIT_OK;
    }

    private void handleDiagnostic(Diagnostic resultDiagnostic, String message, String resultFilePath) {
        if (resultDiagnostic.getSeverity() == 0) {
            logger.log((Priority)Level.INFO, (Object)("The document has been generated successfully: \n" + resultFilePath));
        } else {
            String path = "";
            if (resultFilePath != null) {
                path = resultFilePath;
            }
            logger.log((Priority)Level.ERROR, (Object)(String.valueOf(message) + path));
        }
    }

    public void stop() {
        logger.log((Priority)Level.INFO, (Object)"End of the generation");
        logger.log((Priority)Level.INFO, (Object)"---------------------");
    }

    private void setupWorkbench() {
        Workbench.createAndRunWorkbench((Display)Display.getDefault(), (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return "";
            }

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                return null;
            }

            public IAdaptable getDefaultPageInput() {
                return null;
            }

            public String getMainPreferencePageId() {
                return "";
            }

            protected IWorkbenchConfigurer getWorkbenchConfigurer() {
                return null;
            }

            public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
                return null;
            }

            public void initialize(IWorkbenchConfigurer configurer) {
            }

            public boolean openWindows() {
                return false;
            }

            public IStatus restoreState(IMemento memento) {
                return null;
            }

            public IStatus saveState(IMemento memento) {
                return null;
            }
        });
    }
}

