/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.services.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gendoc.m2t.IFragmentService;
import org.eclipse.gendoc.m2t.IFragmentableM2TProcessor;
import org.eclipse.gendoc.m2t.IM2TProcessor;
import org.eclipse.gendoc.m2t.IScriptLanguageExtensionService;
import org.eclipse.gendoc.m2t.model.Fragment;
import org.eclipse.gendoc.script.acceleo.Generator;
import org.eclipse.gendoc.script.acceleo.IFileAndMMRegistry;
import org.eclipse.gendoc.script.acceleo.Messages;
import org.eclipse.gendoc.script.services.IModuleManagerService;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.GenerationException;
import org.eclipse.gendoc.services.exception.UnknownScriptLanguageException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleManagerService
extends AbstractService
implements IModuleManagerService {
    Map<String, Set<Module>> mapMetamodels2CompiledBundlesIds = new HashMap<String, Set<Module>>();

    @Override
    public List<String> getImportedModules(EObject element) throws GenDocException {
        IConfigurationService config = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
        IScriptLanguageExtensionService scriptLanguageExtensionService = (IScriptLanguageExtensionService)GendocServices.getDefault().getService(IScriptLanguageExtensionService.class);
        try {
            IM2TProcessor processor = scriptLanguageExtensionService.getProcessor(config.getLanguage());
            if (processor instanceof IFragmentableM2TProcessor) {
                IFragmentableM2TProcessor fragmentable = (IFragmentableM2TProcessor)processor;
                IFragmentService fragmentService = (IFragmentService)GendocServices.getDefault().getService(IFragmentService.class);
                List fragments = fragmentService.getAllFragments();
                if (fragments != null) {
                    return this.manageFragments(element, fragments, fragmentable);
                }
            }
        }
        catch (UnknownScriptLanguageException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected List<String> manageFragments(EObject element, List<Fragment> fragments, IFragmentableM2TProcessor fragmentable) throws GenDocException {
        Collection<String> metamodels = this.getMetamodels(element);
        String id = this.getMMString(metamodels);
        Set<Module> result = this.mapMetamodels2CompiledBundlesIds.get(id);
        if (result == null) {
            result = new HashSet<Module>();
            this.mapMetamodels2CompiledBundlesIds.put(id, result);
            Map<String, Fragment> map = this.getFragmentsMap();
            try {
                Collections.sort(fragments, new FragmentComparator());
            }
            catch (DependencyCycleRuntimeException e) {
                throw new GenDocException(e.getMessage()){
                    private static final long serialVersionUID = 1L;
                };
            }
            for (Fragment f : fragments) {
                String script = fragmentable.runFragmentScript(element, f);
                try {
                    ArrayList<URI> dependencies = new ArrayList<URI>();
                    for (String dep : f.getImportedFragments()) {
                        if (!map.containsKey(dep)) {
                            throw new GenDocException(String.format("the fragment %s references an unknow fragment named : %s", f, dep)){
                                private static final long serialVersionUID = 1L;
                            };
                        }
                        dependencies.add(this.getModuleURIForFragmentName(metamodels, dep));
                    }
                    Generator generator = new Generator(element, script, dependencies);
                    Module m = generator.getModule();
                    m.eResource().setURI(this.generateURI(id, m));
                    if (m == null) continue;
                    result.add(m);
                }
                catch (IOException e) {
                    throw new GenerationException("Error during generation of the following script : \n" + script, (Throwable)e);
                }
            }
        }
        LinkedList<String> toReturn = new LinkedList<String>();
        for (Module m : result) {
            toReturn.add(m.getName());
        }
        return toReturn;
    }

    private Map<String, Fragment> getFragmentsMap() {
        IFragmentService service = (IFragmentService)GendocServices.getDefault().getService(IFragmentService.class);
        HashMap<String, Fragment> allFragments = new HashMap<String, Fragment>();
        for (Fragment f : service.getAllFragments()) {
            allFragments.put(f.getName(), f);
        }
        return allFragments;
    }

    private String getMMString(Collection<String> metamodels) {
        StringBuilder id = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>(metamodels);
        Collections.sort(list);
        for (String s : list) {
            id.append(s.replace(':', '_').replace('/', '_').replace('.', '_'));
        }
        return id.toString();
    }

    private URI getModuleURIForFragmentName(Collection<String> metamodels, String dep) {
        return this.generateURI(this.getMMString(metamodels), dep);
    }

    public void clear() {
        super.clear();
        for (Set<Module> list : this.mapMetamodels2CompiledBundlesIds.values()) {
            for (Module m : list) {
                if (m.eResource() == null) continue;
                m.eResource().unload();
            }
        }
        this.mapMetamodels2CompiledBundlesIds.clear();
    }

    protected URI generateURI(String generateUUID, Module m) {
        return this.generateURI(generateUUID, m.getName());
    }

    protected URI generateURI(String generateUUID, String moduleName) {
        return URI.createURI((String)(String.valueOf(Messages.GendocResourceFactory_BUNDLE_URI_SCHEME) + "://" + generateUUID + "/" + moduleName + ".emtl"));
    }

    protected Collection<String> getMetamodels(EObject element) {
        IFileAndMMRegistry registry = (IFileAndMMRegistry)GendocServices.getDefault().getService(IFileAndMMRegistry.class);
        Collection<String> metamodels = registry.getMetamodels(element);
        return metamodels;
    }

    @Override
    public List<URI> getModuleURIs(EObject element) {
        LinkedList<URI> result = new LinkedList<URI>();
        IFileAndMMRegistry registry = (IFileAndMMRegistry)GendocServices.getDefault().getService(IFileAndMMRegistry.class);
        Collection<String> metamodels = registry.getMetamodels(element);
        Set<Module> modules = this.mapMetamodels2CompiledBundlesIds.get(this.getMMString(metamodels));
        for (Module m : modules) {
            result.add(m.eResource().getURI());
        }
        return result;
    }

    @Override
    public Module getModule(URI uri) {
        String name;
        Set<Module> modules;
        if (uri == null) {
            return null;
        }
        if (uri.segmentCount() != 1) {
            return null;
        }
        String id = (uri = uri.trimFileExtension()).host();
        if (id != null && (modules = this.mapMetamodels2CompiledBundlesIds.get(id)) != null && (name = uri.segment(0)) != null) {
            for (Module m : modules) {
                if (!name.equals(m.getName())) continue;
                return m;
            }
        }
        return null;
    }

    private class DependencyCycleRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DependencyCycleRuntimeException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FragmentComparator
    implements Comparator<Fragment> {
        @Override
        public int compare(Fragment o1, Fragment o2) {
            Map allFragments;
            boolean found;
            int result = o1.getImportedFragments().size() == 0 && o2.getImportedFragments().size() == 0 ? 0 : (o1.getImportedFragments().size() == 0 ? -1 : (o2.getImportedFragments().size() == 0 ? 1 : (!(found = this.isDependant(o1, o2, allFragments = ModuleManagerService.this.getFragmentsMap())) ? (this.isDependant(o2, o1, allFragments) ? -1 : 0) : 1)));
            return result;
        }

        private boolean isDependant(Fragment o1, Fragment o2, Map<String, Fragment> allFragments) {
            Stack<String> deps = new Stack<String>();
            deps.addAll(o1.getImportedFragments());
            boolean found = false;
            while (!deps.isEmpty() && !found) {
                String aDep = (String)deps.pop();
                if (aDep.equals(o1.getName())) {
                    throw new DependencyCycleRuntimeException(String.format("a cycle has been detected for fragment <<%s>> please check the attribute 'importedFragments'", o1.getName()));
                }
                found |= o2 != null && o2.getName().equals(aDep);
                Fragment f = allFragments.get(aDep);
                if (f == null) continue;
                for (String s : f.getImportedFragments()) {
                    deps.push(s);
                }
            }
            return found;
        }
    }
}

