/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.xtext.xtext.ui.graph.RailroadView;
import org.eclipse.xtext.xtext.ui.graph.figures.IEObjectReferer;
import org.eclipse.xtext.xtext.ui.graph.figures.ISelectable;

@Singleton
public class RailroadSelectionProvider
implements MouseListener,
ISelectionProvider {
    @Inject
    private RailroadView view;
    private ListenerList<ISelectionChangedListener> selectionListeners = new ListenerList();
    private IFigure currentSelectedFigure;

    public void mousePressed(MouseEvent me) {
        this.setSelection(me, false);
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseDoubleClicked(MouseEvent me) {
        this.setSelection(me, true);
    }

    protected void setSelection(MouseEvent me, boolean isDoubleClick) {
        IFigure selectedFigure = this.view.findFigureAt(me.getLocation());
        while (selectedFigure != null && !(selectedFigure instanceof IEObjectReferer)) {
            selectedFigure = selectedFigure.getParent();
        }
        if (selectedFigure != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)selectedFigure), isDoubleClick);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        if (this.currentSelectedFigure != null) {
            return new StructuredSelection((Object)this.currentSelectedFigure);
        }
        return StructuredSelection.EMPTY;
    }

    protected void setSelection(ISelection selection, boolean isDoubleClick) {
        IFigure selectedFigure = this.getSelectedFigure(selection);
        if (this.currentSelectedFigure instanceof ISelectable) {
            ((ISelectable)this.currentSelectedFigure).setSelected(false);
        }
        this.currentSelectedFigure = selectedFigure;
        if (selectedFigure instanceof ISelectable) {
            ((ISelectable)selectedFigure).setSelected(true);
        }
        DoubleClickEvent event = isDoubleClick ? new DoubleClickEvent(this, selection) : new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = this.selectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged((SelectionChangedEvent)event);
            ++n2;
        }
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, false);
    }

    protected IFigure getSelectedFigure(ISelection selection) {
        Object selectedElement;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IFigure) {
            return (IFigure)selectedElement;
        }
        return null;
    }

    public static class DoubleClickEvent
    extends SelectionChangedEvent {
        private static final long serialVersionUID = 6328075027502345297L;

        public DoubleClickEvent(ISelectionProvider source, ISelection selection) {
            super(source, selection);
        }
    }
}

