/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.ui.builder;

import fr.inria.diverse.k3.ui.builder.JavaAspectFinderResourceVisitor;
import fr.inria.diverse.k3.ui.builder.K3Builder;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class AspectMappingPropertiesChecker {
    protected K3Builder hostBuilder;

    public AspectMappingPropertiesChecker(K3Builder hostBuilder) {
        this.hostBuilder = hostBuilder;
    }

    void checkK3AspectMappingPropertiesForGeneratedJava(IResource resource) {
        if (resource instanceof IFile && resource.getName().endsWith(String.valueOf(resource.getProject().getName()) + ".k3_aspect_mapping.properties")) {
            IFile file = (IFile)resource;
            this.hostBuilder.deleteMarkers(file);
            Properties properties = new Properties();
            try {
                properties.load(file.getContents());
                int mostProbableLine = 1;
                for (Map.Entry<Object, Object> entrySet : properties.entrySet()) {
                    String[] values;
                    ++mostProbableLine;
                    String[] stringArray = values = entrySet.getValue().toString().split(", ");
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        String searchedJavaFile = value.replaceAll("\\.", "/");
                        JavaAspectFinderResourceVisitor finder = new JavaAspectFinderResourceVisitor(String.valueOf(searchedJavaFile) + ".java");
                        resource.getProject().accept((IResourceVisitor)finder);
                        if (!finder.getSearchResult()) {
                            this.hostBuilder.addMarker(file, "Aspect " + value + " not found, clean project recommanded", mostProbableLine, 1);
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

