/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.nexus;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.Field;
import org.apache.maven.index.MAVEN;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IMutableIndex;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.SearchExpression;
import org.eclipse.m2e.core.internal.index.nexus.IndexedArtifactGroup;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.repository.IRepository;

public class NexusIndex
implements IIndex,
IMutableIndex {
    public static final String DETAILS_DISABLED = "off";
    public static final String DETAILS_MIN = "min";
    public static final String DETAILS_FULL = "full";
    private final NexusIndexManager indexManager;
    private final IRepository repository;
    private final String indexDetails;

    NexusIndex(NexusIndexManager indexManager, IRepository repository, String indexDetails) {
        this.indexManager = indexManager;
        this.repository = repository;
        this.indexDetails = indexDetails;
    }

    public String getRepositoryUrl() {
        return this.repository.getUrl();
    }

    public String getIndexDetails() {
        return this.indexDetails;
    }

    @Override
    public void addArtifact(File pomFile, ArtifactKey artifactKey) {
        this.indexManager.addDocument(this.repository, pomFile, artifactKey);
    }

    @Override
    public void removeArtifact(File pomFile, ArtifactKey artifactKey) {
        this.indexManager.removeDocument(this.repository, pomFile, artifactKey, null);
    }

    @Override
    public Collection<IndexedArtifact> find(SearchExpression groupId, SearchExpression artifactId, SearchExpression version, SearchExpression packaging) throws CoreException {
        return this.find(this.wrapIfNotNull(groupId), this.wrapIfNotNull(artifactId), this.wrapIfNotNull(version), this.wrapIfNotNull(packaging));
    }

    private Collection<SearchExpression> wrapIfNotNull(SearchExpression se) {
        if (se == null) {
            return null;
        }
        return Collections.singleton(se);
    }

    @Override
    public Collection<IndexedArtifact> find(Collection<SearchExpression> groupId, Collection<SearchExpression> artifactId, Collection<SearchExpression> version, Collection<SearchExpression> packaging) throws CoreException {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        this.addQueryFromSearchExpressionCollection(query, MAVEN.PACKAGING, packaging);
        this.addQueryFromSearchExpressionCollection(query, MAVEN.GROUP_ID, groupId);
        this.addQueryFromSearchExpressionCollection(query, MAVEN.ARTIFACT_ID, artifactId);
        this.addQueryFromSearchExpressionCollection(query, MAVEN.VERSION, version);
        return this.indexManager.search(this.repository, (Query)query.build()).values();
    }

    private void addQueryFromSearchExpressionCollection(BooleanQuery.Builder query, Field field, Collection<SearchExpression> sec) {
        if (sec != null && !sec.isEmpty()) {
            if (sec.size() > 1) {
                BooleanQuery.Builder q = new BooleanQuery.Builder();
                for (SearchExpression se : sec) {
                    q.add(this.indexManager.constructQuery(field, se), BooleanClause.Occur.SHOULD);
                }
                query.add((Query)q.build(), BooleanClause.Occur.MUST);
            } else {
                query.add(this.indexManager.constructQuery(field, sec.iterator().next()), BooleanClause.Occur.MUST);
            }
        }
    }

    @Override
    public IndexedArtifactFile getIndexedArtifactFile(ArtifactKey artifact) throws CoreException {
        return this.indexManager.getIndexedArtifactFile(this.repository, artifact);
    }

    @Override
    public IndexedArtifactFile identify(File file) throws CoreException {
        return this.indexManager.identify(this.repository, file);
    }

    @Override
    public void updateIndex(boolean force, IProgressMonitor monitor) throws CoreException {
        this.indexManager.updateIndex(this.repository, force, monitor);
    }

    public void scheduleIndexUpdate(boolean force) {
        this.indexManager.scheduleIndexUpdate(this.repository, force);
    }

    public IndexedArtifactGroup[] getRootIndexedArtifactGroups() throws CoreException {
        return this.indexManager.getRootIndexedArtifactGroups(this.repository);
    }

    public boolean isUpdating() {
        return this.indexManager.isUpdatingIndex(this.repository);
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public boolean isEnabled() {
        return DETAILS_MIN.equals(this.indexDetails) || DETAILS_FULL.equals(this.indexDetails);
    }

    public void setIndexDetails(String details) throws CoreException {
        this.indexManager.setIndexDetails(this.repository, details, null);
    }

    @Override
    public Map<String, IndexedArtifact> search(SearchExpression term, String searchType) throws CoreException {
        return this.indexManager.search(this.getRepository(), term, searchType);
    }

    @Override
    public Map<String, IndexedArtifact> search(SearchExpression term, String searchType, int classifier) throws CoreException {
        return this.indexManager.search(this.getRepository(), term, searchType, classifier);
    }
}

