/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.traceaddon;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.ITraceListener;
import org.eclipse.gemoc.trace.gemoc.api.ITraceNotifier;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.BatchModelChangeListener;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NewObjectModelChange;

public class GenericTraceNotifier
implements ITraceNotifier {
    private BatchModelChangeListener traceListener;
    private final List<ITraceListener> listeners = new ArrayList<ITraceListener>();

    public GenericTraceNotifier(BatchModelChangeListener traceListener) {
        this.traceListener = traceListener;
    }

    public void notifyListeners() {
        for (ITraceListener listener : this.listeners) {
            this.notifyListener(listener);
        }
    }

    public void notifyListener(ITraceListener listener) {
        List changes = this.traceListener.getChanges((Object)listener);
        if (!changes.isEmpty()) {
            ArrayList startedSteps = new ArrayList();
            ArrayList endedSteps = new ArrayList();
            ArrayList newStates = new ArrayList();
            ArrayList newValues = new ArrayList();
            ArrayList newDimensions = new ArrayList();
            changes.forEach(c -> {
                if (c instanceof NewObjectModelChange) {
                    EObject o = c.getChangedObject();
                    if (o instanceof Value) {
                        newValues.add((Value)o);
                    } else if (o instanceof Step) {
                        startedSteps.add((Step)o);
                    } else if (o instanceof State) {
                        State newState = (State)o;
                        newStates.add(newState);
                        endedSteps.addAll(newState.getEndedSteps());
                    } else if (o instanceof TracedObject) {
                        newDimensions.addAll(((TracedObject)o).getDimensions());
                    }
                }
            });
            if (!newValues.isEmpty()) {
                listener.valuesAdded(newValues);
            }
            if (!newDimensions.isEmpty()) {
                listener.dimensionsAdded(newDimensions);
            }
            if (!newStates.isEmpty()) {
                listener.statesAdded(newStates);
            }
            if (!startedSteps.isEmpty()) {
                listener.stepsStarted(startedSteps);
            }
            if (!endedSteps.isEmpty()) {
                listener.stepsEnded(endedSteps);
            }
        }
    }

    public void addListener(ITraceListener listener) {
        this.listeners.add(listener);
        this.traceListener.registerObserver((Object)listener);
    }

    public void removeListener(ITraceListener listener) {
        this.listeners.remove(listener);
        this.traceListener.removeObserver((Object)listener);
    }
}

