/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.registration;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ServiceHolder;
import org.eclipse.equinox.http.servlet.internal.registration.Registration;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.runtime.dto.PreprocessorDTO;
import org.osgi.service.http.whiteboard.Preprocessor;

public class PreprocessorRegistration
extends Registration<Preprocessor, PreprocessorDTO>
implements Comparable<PreprocessorRegistration> {
    private final ServiceHolder<Preprocessor> preprocessorHolder;
    private final ClassLoader classLoader;
    private final HttpServiceRuntimeImpl httpServiceRuntime;

    public PreprocessorRegistration(ServiceHolder<Preprocessor> preprocessorHolder, PreprocessorDTO preprocessorDTO, HttpServiceRuntimeImpl httpServiceRuntime) {
        super(preprocessorHolder.get(), preprocessorDTO);
        this.preprocessorHolder = preprocessorHolder;
        this.httpServiceRuntime = httpServiceRuntime;
        this.classLoader = ((BundleWiring)preprocessorHolder.getBundle().adapt(BundleWiring.class)).getClassLoader();
    }

    @Override
    public int compareTo(PreprocessorRegistration o) {
        ServiceReference<Preprocessor> thisRef = this.preprocessorHolder.getServiceReference();
        ServiceReference<Preprocessor> otherRef = o.preprocessorHolder.getServiceReference();
        return thisRef.compareTo(otherRef);
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            ((Preprocessor)this.getT()).doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    @Override
    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.httpServiceRuntime.getPreprocessorRegistrations().remove(this.preprocessorHolder.getServiceReference());
            this.preprocessorHolder.getBundle().getBundleContext().ungetService(this.preprocessorHolder.getServiceReference());
            super.destroy();
            ((Preprocessor)this.getT()).destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
            this.preprocessorHolder.release();
        }
    }

    public int hashCode() {
        return Long.valueOf(((PreprocessorDTO)this.getD()).serviceId).hashCode();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            ((Preprocessor)this.getT()).init(filterConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

