/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.ajde;

import java.io.File;
import java.net.URI;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class FileURICache {
    private static final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    private final WeakHashMap<URI, IFile[]> uriFileMap;
    private final WeakHashMap<URI, IContainer[]> uriContainerMap;
    private final IProject project;

    public FileURICache(IProject project) {
        this.project = project;
        this.uriFileMap = new WeakHashMap();
        this.uriContainerMap = new WeakHashMap();
    }

    public IFile[] findFilesForURI(URI uri) {
        IFile[] files = this.uriFileMap.get(uri);
        if (files == null) {
            files = root.findFilesForLocationURI(uri);
            boolean shouldCache = files.length == 0;
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.getProject().equals((Object)this.project)) {
                    shouldCache = true;
                }
                ++n2;
            }
            if (shouldCache) {
                this.uriFileMap.put(uri, files);
            }
        }
        return files;
    }

    public IContainer[] findContainersForURI(URI uri) {
        IContainer[] containers = this.uriContainerMap.get(uri);
        if (containers == null) {
            containers = root.findContainersForLocationURI(uri);
            boolean shouldCache = containers.length == 0;
            IContainer[] iContainerArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                if (container.getProject().equals((Object)this.project)) {
                    shouldCache = true;
                }
                ++n2;
            }
            if (shouldCache) {
                this.uriContainerMap.put(uri, containers);
            }
        }
        return containers;
    }

    public IResource findResource(String fullPath, IProject p) {
        URI uri = new File(fullPath).toURI();
        IFile[] files = this.findFilesForURI(uri);
        if (files != null) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (p == null || file.getProject().equals((Object)p)) {
                    return file;
                }
                ++n2;
            }
        } else {
            IContainer[] containers;
            IContainer[] iContainerArray = containers = this.findContainersForURI(uri);
            int n = containers.length;
            int n3 = 0;
            while (n3 < n) {
                IContainer container = iContainerArray[n3];
                if (p == null || container.getProject().equals((Object)p)) {
                    return container;
                }
                ++n3;
            }
        }
        return null;
    }

    public IResource findResource(String fullPath) {
        return this.findResource(fullPath, null);
    }
}

