/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.ui.wizards.pages;

import fr.inria.diverse.melange.ui.wizards.pages.NewMelangeProjectWizardFields;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewMelangeProjectWizardPage
extends WizardPage {
    protected NewMelangeProjectWizardFields context;
    protected static final List<String> FILE_EXTENSIONS = Arrays.asList("ecore");
    protected boolean enableNext = true;
    protected Composite container;
    protected Label lblProjectName;
    protected Text txtProjectName;
    protected Text txtProjectLocation;
    protected Button btnBrowseLocation;
    protected Button btnCheckLocation;
    protected Group grpGeneral;

    public NewMelangeProjectWizardPage(NewMelangeProjectWizardFields context) {
        super("wizardPage");
        this.context = context;
        this.setTitle("New Melange project");
        this.setDescription("This wizard creates a new Melange project");
    }

    public NewMelangeProjectWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("New Melange project");
        this.setDescription("This wizard creates a new Melange project");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.grpGeneral = new Group(this.container, 0);
        this.grpGeneral.setText("General");
        this.grpGeneral.setLayout((Layout)new GridLayout(4, false));
        this.lblProjectName = new Label((Composite)this.grpGeneral, 0);
        this.lblProjectName.setText("Project name");
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        this.txtProjectName = new Text((Composite)this.grpGeneral, 2048);
        this.txtProjectName.setText(this.context.projectName);
        this.txtProjectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label((Composite)this.grpGeneral, 0);
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewMelangeProjectWizardPage.this.checkPageFields();
                NewMelangeProjectWizardPage.this.updateNameProject(NewMelangeProjectWizardPage.this.txtProjectName.getText());
            }
        });
        this.btnCheckLocation = new Button((Composite)this.grpGeneral, 32);
        this.btnCheckLocation.setText("Use default location");
        this.btnCheckLocation.setSelection(true);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        this.btnCheckLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewMelangeProjectWizardPage.this.btnCheckLocation.getSelection()) {
                    NewMelangeProjectWizardPage.this.txtProjectLocation.setEnabled(false);
                    NewMelangeProjectWizardPage.this.btnBrowseLocation.setEnabled(false);
                } else {
                    NewMelangeProjectWizardPage.this.txtProjectLocation.setEnabled(true);
                    NewMelangeProjectWizardPage.this.btnBrowseLocation.setEnabled(true);
                }
            }
        });
        this.txtProjectLocation = new Text((Composite)this.grpGeneral, 2048);
        this.txtProjectLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.txtProjectLocation.setText(this.context.projectLocation);
        this.btnBrowseLocation = new Button((Composite)this.grpGeneral, 0);
        this.btnBrowseLocation.setText("Browse...");
        this.btnBrowseLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMelangeProjectWizardPage.this.txtProjectLocation.setText(NewMelangeProjectWizardPage.this.locationDialog());
            }
        });
        this.txtProjectLocation.setEnabled(false);
        this.btnBrowseLocation.setEnabled(false);
        this.checkPageFields();
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    protected String locationDialog() {
        DirectoryDialog dirDialog = new DirectoryDialog(new Shell());
        dirDialog.setText("Select location directory");
        this.context.projectLocation = dirDialog.open();
        return this.context.projectLocation;
    }

    protected boolean existNameProject() {
        boolean bFinder = false;
        int i = 0;
        while (!bFinder && i < ResourcesPlugin.getWorkspace().getRoot().getProjects().length) {
            if (ResourcesPlugin.getWorkspace().getRoot().getProjects()[i].getName().contentEquals(this.txtProjectName.getText())) {
                bFinder = true;
            }
            ++i;
        }
        return bFinder;
    }

    protected void checkPageFields() {
        if (this.existNameProject()) {
            this.setErrorMessage("A project already exist with this name");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public void updateNameProject(String nameProject) {
        this.context.projectName = nameProject;
    }

    public boolean canFlipToNextPage() {
        return this.enableNext;
    }

    public void setProjectName(String nameProject) {
        this.txtProjectName.setText(nameProject);
        this.context.projectName = nameProject;
    }
}

