/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import fr.inria.diverse.k3.al.annotationprocessor.Composition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.xtend.lib.macro.AbstractFieldProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * The processor for the Composition annotation.
 * TODO: does not support collection yet.
 * @author Arnaud Blouin
 */
@SuppressWarnings("all")
public class CompositionProcessor extends AbstractFieldProcessor {
  protected static final String NAME_CONTAINER = "_kContainer";
  
  protected final Set<TypeReference> interfaceObsGenerated = new HashSet<TypeReference>();
  
  protected String getObservabilityInterfaceName(final TypeReference type) {
    String _name = type.getName();
    return (_name + "__K3__Observer4Composition");
  }
  
  protected String getObservabilityOperationName(final String typeName) {
    return ("__remove__K3__Observer4Composition_" + typeName);
  }
  
  protected TypeReference getFieldType(final FieldDeclaration field, final TransformationContext ctx) {
    final TypeReference type = field.getType();
    if ((ctx != null)) {
      boolean _isAssignableFrom = type.isAssignableFrom(ctx.newTypeReference(Collection.class));
      if (_isAssignableFrom) {
        ctx.addError(field, "Collections not supported yet.");
        return null;
      }
    }
    return type;
  }
  
  @Override
  public void doRegisterGlobals(final FieldDeclaration field, final RegisterGlobalsContext ctx) {
    final TypeReference type = this.getFieldType(field, null);
    if (((type != null) && (!this.interfaceObsGenerated.contains(type)))) {
      try {
        ctx.registerInterface(this.getObservabilityInterfaceName(type));
        this.interfaceObsGenerated.add(type);
      } catch (final Throwable _t) {
        if (_t instanceof IllegalArgumentException) {
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
  }
  
  @Override
  public void doTransform(final MutableFieldDeclaration field, final TransformationContext ctx) {
    final TypeReference fieldType = this.getFieldType(field, ctx);
    if ((fieldType == null)) {
      return;
    }
    final MutableClassDeclaration clazzTypeField = ctx.findClass(fieldType.getName());
    if ((clazzTypeField == null)) {
      String _name = field.getType().getName();
      String _plus = ("Cannot find the class " + _name);
      ctx.addError(field, _plus);
      return;
    }
    MutableTypeDeclaration _declaringType = field.getDeclaringType();
    final MutableClassDeclaration clazzContainField = ((MutableClassDeclaration) _declaringType);
    final String interfObsName = this.getObservabilityInterfaceName(fieldType);
    final TypeReference typeRefContainer = ctx.newTypeReference(interfObsName);
    final MutableInterfaceDeclaration interfaceObs = ctx.findInterface(interfObsName);
    final String obsMethodName = this.getObservabilityOperationName(fieldType.getSimpleName());
    final Visibility oldFieldVisibility = field.getVisibility();
    boolean _isPrimitive = fieldType.isPrimitive();
    if (_isPrimitive) {
      ctx.addError(field, "Primitive attributes cannot be composite.");
    }
    field.setVisibility(Visibility.PRIVATE);
    final Function1<MutableFieldDeclaration, Boolean> _function = (MutableFieldDeclaration fi) -> {
      return Boolean.valueOf(fi.getSimpleName().equals(CompositionProcessor.NAME_CONTAINER));
    };
    boolean _exists = IterableExtensions.exists(clazzTypeField.getDeclaredFields(), _function);
    boolean _not = (!_exists);
    if (_not) {
      final Procedure1<MutableFieldDeclaration> _function_1 = (MutableFieldDeclaration it) -> {
        it.setVisibility(Visibility.PRIVATE);
        it.setType(typeRefContainer);
      };
      clazzTypeField.addField(CompositionProcessor.NAME_CONTAINER, _function_1);
      final Procedure1<MutableMethodDeclaration> _function_2 = (MutableMethodDeclaration it) -> {
        it.addParameter("obj", typeRefContainer);
        final CompilationStrategy _function_3 = (CompilationStrategy.CompilationContext it_1) -> {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("if(");
          _builder.append(CompositionProcessor.NAME_CONTAINER);
          _builder.append("!=null) ");
          _builder.append(CompositionProcessor.NAME_CONTAINER);
          _builder.append(".");
          _builder.append(obsMethodName);
          _builder.append("(this);");
          _builder.newLineIfNotEmpty();
          _builder.append(CompositionProcessor.NAME_CONTAINER);
          _builder.append(" = obj;");
          _builder.newLineIfNotEmpty();
          return _builder;
        };
        it.setBody(_function_3);
      };
      clazzTypeField.addMethod(CompositionProcessor.NAME_CONTAINER, _function_2);
      final Procedure1<MutableMethodDeclaration> _function_3 = (MutableMethodDeclaration it) -> {
        it.setReturnType(ctx.newTypeReference("java.lang.Object"));
        final CompilationStrategy _function_4 = (CompilationStrategy.CompilationContext it_1) -> {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("return ");
          _builder.append(CompositionProcessor.NAME_CONTAINER);
          _builder.append(";");
          return _builder;
        };
        it.setBody(_function_4);
      };
      clazzTypeField.addMethod(CompositionProcessor.NAME_CONTAINER, _function_3);
    }
    final Function1<MutableMethodDeclaration, Boolean> _function_4 = (MutableMethodDeclaration meth) -> {
      return Boolean.valueOf(meth.getSimpleName().equals(obsMethodName));
    };
    boolean _exists_1 = IterableExtensions.exists(interfaceObs.getDeclaredMethods(), _function_4);
    boolean _not_1 = (!_exists_1);
    if (_not_1) {
      final Procedure1<MutableMethodDeclaration> _function_5 = (MutableMethodDeclaration it) -> {
        it.addParameter("object", ctx.newTypeReference(fieldType.getName()));
      };
      ctx.findInterface(interfObsName).addMethod(obsMethodName, _function_5);
    }
    final Function1<TypeReference, Boolean> _function_6 = (TypeReference interf) -> {
      return Boolean.valueOf(interf.getSimpleName().equals(interfObsName));
    };
    boolean _exists_2 = IterableExtensions.exists(clazzContainField.getImplementedInterfaces(), _function_6);
    boolean _not_2 = (!_exists_2);
    if (_not_2) {
      clazzContainField.setImplementedInterfaces(Collections.<TypeReference>unmodifiableList(CollectionLiterals.<TypeReference>newArrayList(typeRefContainer)));
    }
    final Function1<MutableMethodDeclaration, Boolean> _function_7 = (MutableMethodDeclaration meth) -> {
      return Boolean.valueOf(meth.getSimpleName().equals(obsMethodName));
    };
    boolean _exists_3 = IterableExtensions.exists(clazzContainField.getDeclaredMethods(), _function_7);
    boolean _not_3 = (!_exists_3);
    if (_not_3) {
      final Function1<MutableFieldDeclaration, Boolean> _function_8 = (MutableFieldDeclaration fi) -> {
        return Boolean.valueOf((fi.getType().equals(fieldType) && IterableExtensions.exists(fi.getAnnotations(), ((Function1<AnnotationReference, Boolean>) (AnnotationReference ann) -> {
          return Boolean.valueOf(ann.getAnnotationTypeDeclaration().getQualifiedName().equals(Composition.class.getName()));
        }))));
      };
      final Iterable<? extends MutableFieldDeclaration> listFieldComposit = IterableExtensions.filter(clazzContainField.getDeclaredFields(), _function_8);
      final Procedure1<MutableMethodDeclaration> _function_9 = (MutableMethodDeclaration it) -> {
        it.addParameter("obj", ctx.newTypeReference(fieldType.getName()));
        final CompilationStrategy _function_10 = (CompilationStrategy.CompilationContext it_1) -> {
          StringConcatenation _builder = new StringConcatenation();
          {
            for(final MutableFieldDeclaration fi : listFieldComposit) {
              _builder.append("if(this.");
              String _simpleName = fi.getSimpleName();
              _builder.append(_simpleName);
              _builder.append("==obj) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("this.");
              String _simpleName_1 = fi.getSimpleName();
              _builder.append(_simpleName_1, "\t");
              _builder.append(" = null;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("return ;");
              _builder.newLine();
              _builder.append("}");
              _builder.newLine();
            }
          }
          return _builder;
        };
        it.setBody(_function_10);
      };
      clazzContainField.addMethod(obsMethodName, _function_9);
    }
    String _firstUpper = StringExtensions.toFirstUpper(field.getSimpleName());
    String _plus_1 = ("set" + _firstUpper);
    final Procedure1<MutableMethodDeclaration> _function_10 = (MutableMethodDeclaration it) -> {
      it.setVisibility(oldFieldVisibility);
      it.addParameter("obj", fieldType);
      final CompilationStrategy _function_11 = (CompilationStrategy.CompilationContext it_1) -> {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(obj!=null) obj.");
        _builder.append(CompositionProcessor.NAME_CONTAINER);
        _builder.append("(this);");
        _builder.newLineIfNotEmpty();
        _builder.append("if(");
        String _simpleName = field.getSimpleName();
        _builder.append(_simpleName);
        _builder.append("!=null) ");
        String _simpleName_1 = field.getSimpleName();
        _builder.append(_simpleName_1);
        _builder.append(".");
        _builder.append(CompositionProcessor.NAME_CONTAINER);
        _builder.append("(null);");
        _builder.newLineIfNotEmpty();
        String _simpleName_2 = field.getSimpleName();
        _builder.append(_simpleName_2);
        _builder.append(" = obj;");
        _builder.newLineIfNotEmpty();
        return _builder;
      };
      it.setBody(_function_11);
    };
    clazzContainField.addMethod(_plus_1, _function_10);
    String _firstUpper_1 = StringExtensions.toFirstUpper(field.getSimpleName());
    String _plus_2 = ("get" + _firstUpper_1);
    final Procedure1<MutableMethodDeclaration> _function_11 = (MutableMethodDeclaration it) -> {
      it.setVisibility(oldFieldVisibility);
      it.setReturnType(field.getType());
      final CompilationStrategy _function_12 = (CompilationStrategy.CompilationContext it_1) -> {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return  ");
        String _simpleName = field.getSimpleName();
        _builder.append(_simpleName);
        _builder.append(";");
        return _builder;
      };
      it.setBody(_function_12);
    };
    clazzContainField.addMethod(_plus_2, _function_11);
  }
}
