/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler.ui.handler;

import fr.inria.aoste.timesquare.ccslkernel.compiler.Compiler;
import fr.inria.aoste.timesquare.ccslkernel.compiler.CompilerParameters;
import fr.inria.aoste.timesquare.ccslkernel.compiler.exceptions.CompilerException;
import fr.inria.aoste.timesquare.ccslkernel.compiler.ui.dialog.CCSLCompilerProjectSelectionDialog;
import fr.inria.aoste.timesquare.ccslkernel.model.utils.ResourceLoader;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CCSLCompileHandler
extends AbstractHandler {
    private IFile ccslFile;
    private ResourceLoader loader = ResourceLoader.INSTANCE;
    private Compiler compiler;
    private CompilerParameters parameters;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selected;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.ccslFile = (IFile)selected;
            String filename = this.ccslFile.getFullPath().toString();
            Resource resource = null;
            Throwable exception = null;
            try {
                resource = this.loader.loadResource(filename);
            }
            catch (IOException e) {
                exception = e;
            }
            Shell parentShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            if (exception != null) {
                Object status = null;
                status = exception instanceof CoreException ? ((CoreException)exception).getStatus() : new Status(4, "fr.inria.aoste.timesquare.ccslkernel.compiler.ui", exception.getLocalizedMessage(), exception);
                ErrorDialog.openError((Shell)parentShell, null, (String)("Resource " + filename + " IO load error: " + exception.getLocalizedMessage()), (IStatus)status);
                return null;
            }
            if (!resource.getErrors().isEmpty()) {
                Vector<Status> statusObjects = new Vector<Status>();
                for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                    statusObjects.add(new Status(4, "fr.inria.aoste.timesquare.ccslkernel.compiler.ui", diagnostic.getMessage()));
                }
                IStatus[] allStatus = new IStatus[statusObjects.size()];
                int i = 0;
                while (i < statusObjects.size()) {
                    IStatus s;
                    allStatus[i] = s = (IStatus)statusObjects.get(i);
                    ++i;
                }
                MultiStatus errors = new MultiStatus("fr.inria.aoste.timesquare.ccslkernel.compiler.ui", 4, allStatus, "Load errors for resource " + filename, null);
                ErrorDialog.openError((Shell)parentShell, null, (String)("Resource " + filename + " load errors"), (IStatus)errors);
                return null;
            }
            CCSLCompilerProjectSelectionDialog dialog = new CCSLCompilerProjectSelectionDialog(parentShell);
            if (dialog.open() != 0) {
                return null;
            }
            this.parameters = new CompilerParameters();
            String newProjectName = dialog.getNewProjectName();
            if (newProjectName == null || newProjectName.isEmpty()) {
                Object result = dialog.getFirstResult();
                if (result == null) {
                    return null;
                }
                if (!(result instanceof IProject)) {
                    return null;
                }
                this.parameters.outputProjectName = ((IProject)result).getName();
            } else {
                this.parameters.outputProjectName = newProjectName;
            }
            this.parameters.outputProjectNamePrefix = null;
            this.parameters.packagePrefix = this.parameters.outputProjectName;
            this.parameters.modelsAreSingleton = dialog.getModelsAreSingleton();
            this.parameters.generateTests = dialog.getGenerateTest();
            this.parameters.generateMain = dialog.getGenerateMain();
            this.parameters.useRuntimeFilterBy = dialog.getUseRuntimeFilterBy();
            this.compiler = new Compiler(this.parameters);
            try {
                this.compiler.compile(resource);
            }
            catch (CompilerException e) {
                exception = e;
            }
            if (exception != null) {
                Object status = null;
                status = exception instanceof CoreException ? ((CoreException)exception).getStatus() : new Status(4, "fr.inria.aoste.timesquare.ccslkernel.compiler.ui", exception.getLocalizedMessage(), exception);
                ErrorDialog.openError((Shell)parentShell, null, (String)("Resource " + filename + " compilation error: " + exception.getLocalizedMessage()), (IStatus)status);
            }
        }
        return null;
    }
}

