/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler.ui.dialog;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CCSLCompilerProjectSelectionDialog
extends ElementListSelectionDialog {
    private IWorkspaceRoot workspaceRoot;
    private String newProjectName = null;
    private boolean modelsAreSingleton = false;
    private boolean generateTest = true;
    private boolean generateMain = false;
    private boolean useRuntimeFilterBy = false;

    public CCSLCompilerProjectSelectionDialog(Shell parent) {
        super(parent, WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.init();
    }

    public CCSLCompilerProjectSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
        this.init();
    }

    private void init() {
        this.setMultipleSelection(false);
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.setElements(this.workspaceRoot.getProjects());
        this.setMessage("Select an existing project or enter the name of a new project");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createNewProjectNameText(composite);
        this.createCompilationOptionsCheckboxes(parent);
        return composite;
    }

    protected Text createNewProjectNameText(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Enter the name of a new project:");
        label.setFont(parent.getFont());
        GridData data1 = new GridData();
        data1.grabExcessVerticalSpace = false;
        data1.grabExcessHorizontalSpace = true;
        data1.horizontalAlignment = 4;
        data1.verticalAlignment = 1;
        label.setLayoutData((Object)data1);
        final Text text = new Text(parent, 2048);
        GridData data2 = new GridData();
        data2.grabExcessVerticalSpace = false;
        data2.grabExcessHorizontalSpace = true;
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 1;
        text.setLayoutData((Object)data2);
        text.setFont(parent.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                CCSLCompilerProjectSelectionDialog.this.setNewProjectName(text.getText());
            }
        };
        text.addListener(24, listener);
        return text;
    }

    public String getNewProjectName() {
        return this.newProjectName;
    }

    private void setNewProjectName(String newProjectName) {
        this.newProjectName = newProjectName;
    }

    private void createCompilationOptionsCheckboxes(Composite parent) {
        final Button singletonModelsButton = new Button(parent, 32);
        singletonModelsButton.setText("Generate model classes as Singleton");
        singletonModelsButton.setToolTipText("If the import graph of the models is not a tree it may be necessary to activate this option so that each model has a unique instance.");
        singletonModelsButton.setSelection(this.modelsAreSingleton);
        singletonModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (singletonModelsButton.getSelection()) {
                    CCSLCompilerProjectSelectionDialog.this.modelsAreSingleton = true;
                } else {
                    CCSLCompilerProjectSelectionDialog.this.modelsAreSingleton = false;
                }
            }
        });
        final Button generateTestButton = new Button(parent, 32);
        generateTestButton.setText("Generate test class (junit) skeleton");
        generateTestButton.setSelection(this.generateTest);
        generateTestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (generateTestButton.getSelection()) {
                    CCSLCompilerProjectSelectionDialog.this.generateTest = true;
                } else {
                    CCSLCompilerProjectSelectionDialog.this.generateTest = false;
                }
            }
        });
        final Button generateMainButton = new Button(parent, 32);
        generateMainButton.setText("Generate class with main() function");
        generateMainButton.setSelection(this.generateMain);
        generateMainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (generateMainButton.getSelection()) {
                    CCSLCompilerProjectSelectionDialog.this.generateMain = true;
                } else {
                    CCSLCompilerProjectSelectionDialog.this.generateMain = false;
                }
            }
        });
        final Button useRuntimeFilterbyButton = new Button(parent, 32);
        useRuntimeFilterbyButton.setText("Use FilterBy from runtime");
        useRuntimeFilterbyButton.setToolTipText("If the CCSL specification model contains some instance of the FilterBy expression, select this option to have these instances use the FilterBy implementation from the CCSL runtime rather than have it generated from the CCSL expression definition");
        useRuntimeFilterbyButton.setSelection(this.useRuntimeFilterBy);
        useRuntimeFilterbyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CCSLCompilerProjectSelectionDialog.this.useRuntimeFilterBy = useRuntimeFilterbyButton.getSelection();
            }
        });
    }

    public boolean getModelsAreSingleton() {
        return this.modelsAreSingleton;
    }

    public boolean getGenerateTest() {
        return this.generateTest;
    }

    public boolean getGenerateMain() {
        return this.generateMain;
    }

    public boolean getUseRuntimeFilterBy() {
        return this.useRuntimeFilterBy;
    }
}

