/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.progress.WorkbenchJob;

public class IDEWorkbenchActivityHelper {
    private static final String NATURE_POINT = "org.eclipse.ui.ide.natures";
    private IResourceChangeListener listener;
    private Map<String, IPluginContribution> natureMap;
    private final IDEWorkbenchActivityHelper lock;
    private WorkbenchJob fUpdateJob;
    private HashSet<String> fPendingNatureUpdates = new HashSet();
    private static IDEWorkbenchActivityHelper singleton;

    public static IDEWorkbenchActivityHelper getInstance() {
        if (singleton == null) {
            singleton = new IDEWorkbenchActivityHelper();
        }
        return singleton;
    }

    private IDEWorkbenchActivityHelper() {
        this.lock = this;
        this.natureMap = new HashMap<String, IPluginContribution>();
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            if (event.getExtensionDeltas("org.eclipse.core.resources", "natures").length > 0) {
                this.loadNatures();
            }
        }, "org.eclipse.core.resources");
        this.loadNatures();
        this.listener = this.getChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.processProjects(new HashSet<IProject>(Arrays.asList(projects)));
    }

    public void loadNatures() {
        this.natureMap.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources.natures");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            final String localId = extension.getSimpleIdentifier();
            final String pluginId = extension.getContributor().getName();
            String natureId = extension.getUniqueIdentifier();
            this.natureMap.put(natureId, new IPluginContribution(){

                public String getLocalId() {
                    return localId;
                }

                public String getPluginId() {
                    return pluginId;
                }
            });
            ++n2;
        }
    }

    private IResourceChangeListener getChangeListener() {
        return event -> {
            if (!WorkbenchActivityHelper.isFiltering()) {
                return;
            }
            IResourceDelta mainDelta = event.getDelta();
            if (mainDelta == null) {
                return;
            }
            if (mainDelta.getKind() == 4 && mainDelta.getResource().getType() == 8) {
                HashSet<IProject> projectsToUpdate = new HashSet<IProject>();
                IResourceDelta[] iResourceDeltaArray = mainDelta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project;
                    IResourceDelta delta = iResourceDeltaArray[n2];
                    if (delta.getResource().getType() == 4 && (project = (IProject)delta.getResource()).isOpen()) {
                        projectsToUpdate.add(project);
                    }
                    ++n2;
                }
                this.processProjects(projectsToUpdate);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPendingUpdates() {
        String[] ids = null;
        IDEWorkbenchActivityHelper iDEWorkbenchActivityHelper = this.lock;
        synchronized (iDEWorkbenchActivityHelper) {
            ids = this.fPendingNatureUpdates.toArray(new String[this.fPendingNatureUpdates.size()]);
            this.fPendingNatureUpdates.clear();
        }
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IPluginContribution contribution = this.natureMap.get(id);
            if (contribution != null) {
                ITriggerPoint triggerPoint = workbenchActivitySupport.getTriggerPointManager().getTriggerPoint(NATURE_POINT);
                WorkbenchActivityHelper.allowUseOf((ITriggerPoint)triggerPoint, (Object)contribution);
            }
            ++n2;
        }
    }

    public void shutdown() {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProjects(Set<IProject> projectsToUpdate) {
        boolean needsUpdate = false;
        Iterator<IProject> i = projectsToUpdate.iterator();
        while (i.hasNext()) {
            try {
                IProject project = i.next();
                String[] ids = project.getDescription().getNatureIds();
                if (ids.length == 0) continue;
                IDEWorkbenchActivityHelper iDEWorkbenchActivityHelper = this.lock;
                synchronized (iDEWorkbenchActivityHelper) {
                    needsUpdate = this.fPendingNatureUpdates.addAll(Arrays.asList(ids)) | needsUpdate;
                }
            }
            catch (CoreException coreException) {}
        }
        if (needsUpdate) {
            if (this.fUpdateJob == null) {
                this.fUpdateJob = new WorkbenchJob(IDEWorkbenchMessages.IDEWorkbenchActivityHelper_jobName){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IDEWorkbenchActivityHelper.this.runPendingUpdates();
                        return Status.OK_STATUS;
                    }
                };
                this.fUpdateJob.setSystem(true);
            }
            this.fUpdateJob.schedule();
        }
    }
}

