/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.impl.NodeCreationDescriptionImpl;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class RequestQuery {
    protected final Request request;

    public RequestQuery(Request request) {
        this.request = request;
    }

    public boolean isNoteCreationRequest() {
        boolean isNoteCreationRequest = false;
        if (this.request instanceof CreateViewRequest) {
            CreateViewRequest cvr = (CreateViewRequest)this.request;
            for (CreateViewRequest.ViewDescriptor viewDesc : Iterables.filter((Iterable)cvr.getViewDescriptors(), CreateViewRequest.ViewDescriptor.class)) {
                if (!"Note".equals(viewDesc.getSemanticHint())) continue;
                isNoteCreationRequest = true;
                break;
            }
        }
        return isNoteCreationRequest;
    }

    public boolean isNoteAttachmentCreationRequest() {
        boolean isNoteAttachmentCreationRequest = false;
        if (this.request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest cvr = (CreateConnectionViewRequest)this.request;
            isNoteAttachmentCreationRequest = "NoteAttachment".equals(cvr.getConnectionViewDescriptor().getSemanticHint());
        }
        return isNoteAttachmentCreationRequest;
    }

    public boolean isTextCreationRequest() {
        boolean isTextCreationRequest = false;
        if (this.request instanceof CreateViewRequest) {
            CreateViewRequest cvr = (CreateViewRequest)this.request;
            for (CreateViewRequest.ViewDescriptor viewDesc : Iterables.filter((Iterable)cvr.getViewDescriptors(), CreateViewRequest.ViewDescriptor.class)) {
                if (!"Text".equals(viewDesc.getSemanticHint())) continue;
                isTextCreationRequest = true;
                break;
            }
        }
        return isTextCreationRequest;
    }

    public boolean isNoteDropRequest() {
        boolean isNoteDropRequest = false;
        if ("add children".equals(this.request.getType()) && this.request instanceof GroupRequest) {
            GroupRequest groupRequest = (GroupRequest)this.request;
            isNoteDropRequest = !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)groupRequest.getEditParts(), NoteEditPart.class));
        }
        return isNoteDropRequest;
    }

    public boolean isTextDropRequest() {
        boolean isTextDropRequest = false;
        if ("add children".equals(this.request.getType()) && this.request instanceof GroupRequest) {
            GroupRequest groupRequest = (GroupRequest)this.request;
            isTextDropRequest = !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)groupRequest.getEditParts(), TextEditPart.class));
        }
        return isTextDropRequest;
    }

    public boolean isMove() {
        Object type = this.request.getType();
        return "move".equals(type) || "drop".equals(type);
    }

    public boolean isResize() {
        return "resize children".equals(this.request.getType()) || "resize".equals(this.request.getType());
    }

    public boolean isResizeFromTop() {
        boolean isResizeFromTop = false;
        if (this.request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)this.request;
            isResizeFromTop = ("resize children".equals(cbr.getType()) || "resize".equals(cbr.getType())) && (cbr.getResizeDirection() & 1) != 0;
        }
        return isResizeFromTop;
    }

    public boolean isResizeFromBottom() {
        boolean isResizeFromBottom = false;
        if (this.request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)this.request;
            isResizeFromBottom = ("resize children".equals(cbr.getType()) || "resize".equals(cbr.getType())) && (cbr.getResizeDirection() & 4) != 0;
        }
        return isResizeFromBottom;
    }

    public boolean isResizeFromRight() {
        boolean isResizeFromRight = false;
        if (this.request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)this.request;
            isResizeFromRight = ("resize children".equals(cbr.getType()) || "resize".equals(cbr.getType())) && (cbr.getResizeDirection() & 0x10) != 0;
        }
        return isResizeFromRight;
    }

    public boolean isResizeFromLeft() {
        boolean isResizeFromLeft = false;
        if (this.request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)this.request;
            isResizeFromLeft = ("resize children".equals(cbr.getType()) || "resize".equals(cbr.getType())) && (cbr.getResizeDirection() & 8) != 0;
        }
        return isResizeFromLeft;
    }

    public boolean isMultiSelectionOperation() {
        if (this.request instanceof GroupRequest) {
            GroupRequest gr = (GroupRequest)this.request;
            return gr.getEditParts() != null && gr.getEditParts().size() > 1;
        }
        return false;
    }

    public Rectangle getLogicalDelta() {
        return this.getLogicalTransformedRectangle(new Rectangle());
    }

    public Rectangle getLogicalTransformedRectangle(Rectangle bounds) {
        Rectangle result = bounds.getCopy();
        if (this.request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)this.request;
            Option<IGraphicalEditPart> part = this.getOnePart();
            if (part.some()) {
                GraphicalHelper.logical2screen((Rectangle)result, (IGraphicalEditPart)((IGraphicalEditPart)part.get()));
            }
            result = cbr.getTransformedRectangle(result);
            if (part.some()) {
                GraphicalHelper.screen2logical((Rectangle)result, (GraphicalEditPart)((GraphicalEditPart)part.get()));
            }
        }
        return result;
    }

    protected Option<IGraphicalEditPart> getOnePart() {
        List<IGraphicalEditPart> editParts = this.getEditParts();
        if (editParts != null && !editParts.isEmpty()) {
            return Options.newSome((Object)editParts.get(0));
        }
        return Options.newNone();
    }

    protected List<IGraphicalEditPart> getEditParts() {
        if (this.request instanceof GroupRequest) {
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)((GroupRequest)this.request).getEditParts(), IGraphicalEditPart.class));
        }
        return Collections.emptyList();
    }

    public boolean isDropOrCreationOfBorderNode() {
        boolean isConcerningBorderNode = false;
        if (this.request instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)this.request;
            if (createRequest.getNewObject() instanceof NodeCreationDescriptionImpl) {
                isConcerningBorderNode = true;
                NodeCreationDescriptionImpl nodeCreationDescriptionImpl = (NodeCreationDescriptionImpl)createRequest.getNewObject();
                for (NodeMapping nodeMapping : nodeCreationDescriptionImpl.getNodeMappings()) {
                    if (DescriptionPackage.eINSTANCE.getAbstractNodeMapping_BorderedNodeMappings().equals(nodeMapping.eContainingFeature())) continue;
                    isConcerningBorderNode = false;
                }
            }
        } else if ("drop".equals(this.request.getType())) {
            isConcerningBorderNode = !this.getEditParts().isEmpty() && Iterables.all(this.getEditParts(), (Predicate)Predicates.instanceOf(IBorderItemEditPart.class));
        }
        return isConcerningBorderNode;
    }
}

