/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileDialog;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileNewWizard;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.ocl.xtext.completeocl.ui.messages.CompleteOCLUIMessages;
import org.eclipse.ocl.xtext.completeocl.ui.wizards.CompleteOCLFileDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class CompleteOCLFileNewWizard
extends AbstractFileNewWizard {
    protected @NonNull CompleteOCLFileDialog createDialog(@NonNull AbstractFileNewWizardPage wizardPage, @Nullable IResource initialSelection) {
        return new CompleteOCLFileDialog(this, wizardPage, initialSelection);
    }

    protected String getEditorId() {
        return "org.eclipse.ocl.xtext.completeocl.CompleteOCL";
    }

    public @NonNull String getInitialContentsAsString(@NonNull IFile newFile, @NonNull AbstractFileDialog dialog) {
        String firstPackageName = null;
        String firstTypeName = null;
        String firstPropertyName = null;
        StringBuilder s = new StringBuilder();
        HashSet uris = new HashSet(dialog.getURIs());
        if (uris.size() > 0) {
            ArrayList sortedURIs = new ArrayList(uris);
            Collections.sort(sortedURIs, new Comparator<URI>(){

                @Override
                public int compare(URI o1, URI o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            block2: for (URI uri : sortedURIs) {
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    URI newURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
                    URI deresolvedURI = uri.deresolve(newURI);
                    s.append("import '" + ValueUtil.oclToString((Object)deresolvedURI) + "'\n");
                    if (firstPropertyName != null) continue;
                    for (EObject eObject : resource.getContents()) {
                        Iterator iterator;
                        if (eObject instanceof Package) {
                            Package umlPackage = (Package)eObject;
                            if (firstPackageName == null) {
                                firstPackageName = umlPackage.getName();
                            }
                            for (Type umlType : umlPackage.getOwnedTypes()) {
                                if (firstTypeName == null) {
                                    firstTypeName = umlType.getName();
                                    firstPackageName = umlPackage.getName();
                                }
                                if (umlType instanceof Class && (iterator = ((Class)umlType).getOwnedAttributes().iterator()).hasNext()) {
                                    Property umlProperty = (Property)iterator.next();
                                    firstPropertyName = umlProperty.getName();
                                    firstTypeName = umlType.getName();
                                    firstPackageName = umlPackage.getName();
                                }
                                if (firstPropertyName == null) {
                                    continue;
                                }
                                break;
                            }
                        } else if (eObject instanceof EPackage) {
                            EPackage ePackage = (EPackage)eObject;
                            if (firstPackageName == null) {
                                firstPackageName = ePackage.getName();
                            }
                            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                                if (firstTypeName == null) {
                                    firstTypeName = eClassifier.getName();
                                    firstPackageName = ePackage.getName();
                                }
                                if (eClassifier instanceof EClass && (iterator = ((EClass)eClassifier).getEAllStructuralFeatures().iterator()).hasNext()) {
                                    EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                                    firstPropertyName = eStructuralFeature.getName();
                                    firstTypeName = eClassifier.getName();
                                    firstPackageName = ePackage.getName();
                                }
                                if (firstPropertyName == null) {
                                    continue;
                                }
                                break;
                            }
                        }
                        if (firstPropertyName != null) continue block2;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            s.append("\n");
        }
        if (firstPackageName == null) {
            firstPackageName = "undefined_root_package_name";
        }
        if (firstTypeName == null) {
            firstTypeName = "Example";
        }
        if (firstPropertyName == null) {
            firstPropertyName = "feature";
        }
        s.append("package " + firstPackageName + "\n");
        s.append("\n");
        s.append("context " + firstTypeName + "\n");
        s.append("--\n");
        s.append("-- example invariant with a custom error message to verify that\n");
        s.append("-- the '" + firstPropertyName + "' property of all '" + firstPackageName + "::" + firstTypeName + "' instances is non-null\n");
        s.append("--\n");
        s.append("inv NonNull_" + firstPropertyName + "('The \\'" + firstPropertyName + "\\' property of \"' + self.toString() + '\" is null'):\n");
        s.append("\t" + firstPropertyName + " <> null\n");
        s.append("\n");
        s.append("endpackage\n");
        return s.toString();
    }

    public @NonNull String getNewFileExtension() {
        return "ocl";
    }

    public @NonNull String getNewFileName() {
        return CompleteOCLUIMessages.NewWizardPage_defaultFileName;
    }

    public @NonNull String getNewFileLabel() {
        return CompleteOCLUIMessages.NewWizardPage_fileNameLabel;
    }

    public @NonNull String getPageDescription() {
        return CompleteOCLUIMessages.NewWizardPage_pageDescription;
    }

    public @NonNull String getPageSummary() {
        return CompleteOCLUIMessages.NewWizardPage_pageSummary;
    }

    public @NonNull String getPageTitle() {
        return CompleteOCLUIMessages.NewWizardPage_pageTitle;
    }
}

