/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.CompletePackageImpl;
import org.eclipse.ocl.pivot.internal.PackageImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.PackageListeners;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public final class PartialPackages
extends EObjectResolvingEList<Package>
implements PackageListeners.IPackageListener {
    private static final @NonNull Package2PackageOwnedPackages package2PackageOwnedPackages = new Package2PackageOwnedPackages();
    public static final @NonNull TracingOption PARTIAL_PACKAGES = new TracingOption("org.eclipse.ocl.pivot", "partialPackages");
    private static final long serialVersionUID = 1L;
    private Map<String, CompletePackage> name2nestedCompletePackage = null;
    protected final @NonNull Map<String, CompleteInheritanceImpl> name2inheritance = new HashMap<String, CompleteInheritanceImpl>();

    public PartialPackages(@NonNull CompletePackageImpl owner) {
        super(Package.class, (InternalEObject)owner, 9);
    }

    public void addUnique(Package partialPackage) {
        assert (partialPackage != null);
        this.didAdd(partialPackage);
        super.addUnique((Object)partialPackage);
    }

    public void addUnique(int index, Package partialPackage) {
        assert (partialPackage != null);
        this.didAdd(partialPackage);
        super.addUnique(index, (Object)partialPackage);
    }

    protected void didAdd(@NonNull Package partialPackage) {
        if (PARTIAL_PACKAGES.isActive()) {
            PARTIAL_PACKAGES.println("Do-didAdd " + this + " " + partialPackage);
        }
        ((PackageImpl)partialPackage).addPackageListener(this);
        this.getCompletePackage().didAddPartialPackage(partialPackage);
        for (Package nestedPackage : partialPackage.getOwnedPackages()) {
            if (nestedPackage == null) continue;
            this.getCompletePackage().didAddNestedPackage(nestedPackage);
        }
    }

    @Override
    public void didAddPackage(@NonNull Package nestedPackage) {
        this.getCompletePackage().didAddNestedPackage(nestedPackage);
    }

    void didAddNestedCompletePackage(@NonNull CompletePackage nestedCompletePackage) {
        assert (this.name2nestedCompletePackage != null);
        String name = nestedCompletePackage.getName();
        if (name != null) {
            CompletePackage oldCompletePackage = this.name2nestedCompletePackage.put(name, nestedCompletePackage);
            assert (oldCompletePackage == null);
        }
    }

    void didRemoveNestedCompletePackage(@NonNull CompletePackage nestedCompletePackage) {
        assert (this.name2nestedCompletePackage != null);
        String name = nestedCompletePackage.getName();
        if (name != null) {
            this.name2nestedCompletePackage.remove(name);
        }
    }

    protected void didRemove(int index, Package partialPackage) {
        assert (partialPackage != null);
        if (PARTIAL_PACKAGES.isActive()) {
            PARTIAL_PACKAGES.println("Do-didRemove " + this + " " + partialPackage);
        }
        super.didRemove(index, (Object)partialPackage);
        ((PackageImpl)partialPackage).removePackageListener(this);
        this.getCompletePackage().didRemovePartialPackage(partialPackage);
    }

    @Override
    public void didRemovePackage(@NonNull Package nestedPackage) {
        this.getCompletePackage().didRemoveNestedPackage(nestedPackage);
    }

    @Override
    public void didAddClass(@NonNull Class partialClass) {
        this.getCompletePackage().didAddClass(partialClass);
    }

    @Override
    public void didRemoveClass(@NonNull Class partialClass) {
        CompleteInheritanceImpl completeInheritance = this.name2inheritance.remove(partialClass.getName());
        this.getCompletePackage().didRemoveClass(partialClass);
        if (completeInheritance != null) {
            completeInheritance.uninstall();
        }
    }

    public @NonNull CompleteInheritanceImpl getCompleteInheritance(@NonNull CompleteClassInternal completeClass) {
        String name = completeClass.getName();
        CompleteInheritanceImpl completeInheritance = this.name2inheritance.get(name);
        if (completeInheritance == null) {
            completeInheritance = new CompleteInheritanceImpl(completeClass);
            this.name2inheritance.put(name, completeInheritance);
        }
        return completeInheritance;
    }

    public @NonNull CompleteModelInternal getCompleteModel() {
        return this.getCompletePackage().getCompleteModel();
    }

    public @NonNull CompletePackageImpl getCompletePackage() {
        return (CompletePackageImpl)this.owner;
    }

    protected @NonNull Iterable<Package> getNestedPartialPackages() {
        PartialPackages partialPackages = this.getCompletePackage().getPartialPackages();
        Iterable roots_packages = Iterables.transform((Iterable)((Object)partialPackages), (Function)package2PackageOwnedPackages);
        @NonNull Iterable allPackages = Iterables.concat((Iterable)roots_packages);
        return allPackages;
    }

    public void uninstalled(@NonNull CompleteClassInternal completeClass) {
        CompleteInheritanceImpl inheritance = this.name2inheritance.remove(completeClass.getName());
        if (inheritance != null) {
            inheritance.uninstall();
        }
    }

    private static class Package2PackageOwnedPackages
    implements Function<Package, Iterable<Package>> {
        private Package2PackageOwnedPackages() {
        }

        public Iterable<Package> apply(Package partialPackage) {
            return partialPackage.getOwnedPackages();
        }
    }
}

