/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.dynamic;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.dynamic.ExplicitClassLoader;

public class JavaSourceFileObject
extends SimpleJavaFileObject {
    public static Class<?> loadExplicitClass(@NonNull File explicitClassPath, @NonNull String qualifiedClassName) throws ClassNotFoundException, IOException {
        ClassLoader thisClassLoader = JavaSourceFileObject.class.getClassLoader();
        assert (thisClassLoader != null);
        ExplicitClassLoader classLoader = new ExplicitClassLoader(explicitClassPath, qualifiedClassName, thisClassLoader);
        return classLoader.loadClass(qualifiedClassName);
    }

    public JavaSourceFileObject(@NonNull URI uri) {
        super(uri, JavaFileObject.Kind.SOURCE);
    }

    @Override
    public @NonNull CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        char[] buf = new char[4096];
        StringBuilder s = new StringBuilder();
        try (FileReader reader = new FileReader(new File(this.uri));){
            int len;
            while ((len = reader.read(buf)) > 0) {
                s.append(buf, 0, len);
            }
        }
        return s.toString();
    }
}

