/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cse.AbstractAnalysis;
import org.eclipse.ocl.examples.codegen.cse.AbstractPlace;
import org.eclipse.ocl.examples.codegen.cse.ControlPlace;
import org.eclipse.ocl.examples.codegen.cse.HashedAnalyses;
import org.eclipse.ocl.examples.codegen.cse.LocalPlace;

public class IfPlaces {
    public static @NonNull LocalPlace createIfPlaces(@NonNull Map<@Nullable CGElement, @NonNull AbstractPlace> element2place, @NonNull CGIfExp cgIfExp) {
        ControlPlace ifPlace = ControlPlace.getControlPlace(element2place, cgIfExp);
        CGValuedElement cgThenExp = cgIfExp.getThenExpression();
        CGValuedElement cgElseExp = cgIfExp.getElseExpression();
        if (cgThenExp != null && cgElseExp != null) {
            ThenPlace thenPlace = new ThenPlace(ifPlace, cgThenExp, cgElseExp);
            ElsePlace elsePlace = thenPlace.elsePlace;
            element2place.put(cgThenExp, thenPlace);
            element2place.put(cgElseExp, elsePlace);
        }
        return ifPlace;
    }

    public static class ElsePlace
    extends ControlPlace {
        protected final @NonNull ThenPlace thenPlace;

        private ElsePlace(@NonNull LocalPlace ifPlace, @NonNull ThenPlace thenPlace, @NonNull CGValuedElement cgElseExp) {
            super(ifPlace, cgElseExp);
            this.thenPlace = thenPlace;
        }

        @Override
        public void pushUp() {
            super.pushUp();
            this.thenPlace.pushUp();
            HashedAnalyses thenSet = this.thenPlace.getHashedAnalyses();
            HashedAnalyses elseSet = this.getHashedAnalyses();
            HashedAnalyses intersection = HashedAnalyses.intersection(thenSet, elseSet);
            if (intersection != null) {
                ControlPlace parentPlace = ElsePlace.getControlPlace(this.getParentPlace());
                for (AbstractAnalysis commonAnalysis : intersection) {
                    AbstractAnalysis thenAnalysis = thenSet.remove(commonAnalysis);
                    AbstractAnalysis elseAnalysis = elseSet.remove(commonAnalysis);
                    if (thenAnalysis != null && elseAnalysis != null) {
                        parentPlace.addAnalysis(thenAnalysis);
                        parentPlace.addAnalysis(elseAnalysis);
                        continue;
                    }
                    assert (thenAnalysis == null && elseAnalysis == null);
                }
            }
        }
    }

    public static class ThenPlace
    extends ControlPlace {
        protected final @NonNull ElsePlace elsePlace;

        private ThenPlace(@NonNull LocalPlace ifPlace, @NonNull CGValuedElement cgThenExp, @NonNull CGValuedElement cgElseExp) {
            super(ifPlace, cgThenExp);
            this.elsePlace = new ElsePlace(ifPlace, this, cgElseExp);
        }
    }
}

