/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGAssertNonNullExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCachedOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCastExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcorePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGGuardExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqual2Exp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqualExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNativeOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNavigationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.java.types.BoxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EcoreDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.library.LibraryIteration;
import org.eclipse.ocl.pivot.library.iterator.IterateIteration;
import org.eclipse.ocl.pivot.utilities.ValueUtil;

public class BoxingAnalyzer
extends AbstractExtendingCGModelVisitor<Object, CodeGenAnalyzer> {
    protected final @NonNull CodeGenerator codeGenerator;

    public BoxingAnalyzer(@NonNull CodeGenAnalyzer analyzer) {
        super(analyzer);
        this.codeGenerator = analyzer.getCodeGenerator();
    }

    protected boolean hasOclVoidOperation(@NonNull OperationId operationId) {
        PivotMetamodelManager metamodelManager = this.codeGenerator.getEnvironmentFactory().getMetamodelManager();
        CompleteClassInternal completeClass = metamodelManager.getCompleteClass((Type)metamodelManager.getStandardLibrary().getOclVoidType());
        Operation memberOperation = completeClass.getOperation(operationId);
        if (memberOperation == null) {
            return false;
        }
        Class owningType = memberOperation.getOwningClass();
        if (owningType == null) {
            return false;
        }
        CompleteClassInternal owningCompleteClass = metamodelManager.getCompleteClass((Type)owningType);
        return completeClass == owningCompleteClass;
    }

    protected @Nullable CGValuedElement rewriteAsAssertNonNulled(@Nullable CGValuedElement cgChild) {
        if (cgChild == null || cgChild.isNonNull()) {
            return cgChild;
        }
        CGAssertNonNullExp cgAssertExp = CGModelFactory.eINSTANCE.createCGAssertNonNullExp();
        CGUtil.wrap(cgAssertExp, cgChild);
        return cgAssertExp;
    }

    protected boolean isSafe(@NonNull CGCallExp cgCallExp) {
        Element asElement = cgCallExp.getAst();
        return asElement instanceof CallExp && ((CallExp)asElement).isIsSafe();
    }

    protected CGValuedElement rewriteAsBoxed(@Nullable CGValuedElement cgChild) {
        if (cgChild == null || cgChild.isBoxed()) {
            return cgChild;
        }
        CGTypeId cgTypeId = cgChild.getTypeId();
        ElementId elementId = cgTypeId.getElementId();
        if (elementId != null) {
            UnboxedDescriptor unboxedDescriptor;
            EClassifier eClassifier;
            java.lang.Class instanceClass;
            EcoreDescriptor ecoreDescriptor;
            BoxedDescriptor boxedDescriptor = this.codeGenerator.getBoxedDescriptor(elementId);
            if (cgChild.isEcore() ? boxedDescriptor == (ecoreDescriptor = boxedDescriptor.getEcoreDescriptor(this.codeGenerator, instanceClass = (eClassifier = cgChild.getEcoreClassifier()) != null ? eClassifier.getInstanceClass() : null)) : (unboxedDescriptor = boxedDescriptor.getUnboxedDescriptor(this.codeGenerator)) == boxedDescriptor) {
                return cgChild;
            }
        }
        CGBoxExp cgBoxExp = CGModelFactory.eINSTANCE.createCGBoxExp();
        CGUtil.wrap(cgBoxExp, cgChild);
        return cgBoxExp;
    }

    protected CGValuedElement rewriteAsEcore(@Nullable CGValuedElement cgChild, EClassifier eClassifier) {
        if (cgChild == null || cgChild.isEcore()) {
            return cgChild;
        }
        CGTypeId cgTypeId = cgChild.getTypeId();
        ElementId elementId = cgTypeId.getElementId();
        if (elementId != null) {
            UnboxedDescriptor unboxedDescriptor;
            BoxedDescriptor boxedDescriptor = this.codeGenerator.getBoxedDescriptor(elementId);
            java.lang.Class instanceClass = eClassifier != null ? eClassifier.getInstanceClass() : null;
            EcoreDescriptor ecoreDescriptor = boxedDescriptor.getEcoreDescriptor(this.codeGenerator, instanceClass);
            if (cgChild.isUnboxed() ? ecoreDescriptor == (unboxedDescriptor = boxedDescriptor.getUnboxedDescriptor(this.codeGenerator)) : ecoreDescriptor == boxedDescriptor) {
                return cgChild;
            }
        }
        CGEcoreExp cgEcoreExp = CGModelFactory.eINSTANCE.createCGEcoreExp();
        cgEcoreExp.setEClassifier(eClassifier);
        CGUtil.wrap(cgEcoreExp, cgChild);
        return cgEcoreExp;
    }

    protected @Nullable CGValuedElement rewriteAsGuarded(@Nullable CGValuedElement cgChild, boolean isSafe, @NonNull String message) {
        if (cgChild == null || cgChild.isNonNull()) {
            return cgChild;
        }
        CGGuardExp cgGuardExp = CGModelFactory.eINSTANCE.createCGGuardExp();
        cgGuardExp.setMessage(message);
        cgGuardExp.setSafe(isSafe);
        CGUtil.wrap(cgGuardExp, cgChild);
        return cgGuardExp;
    }

    protected CGValuedElement rewriteAsCast(@Nullable CGVariableExp cgChild) {
        if (cgChild == null) {
            return cgChild;
        }
        CGCastExp cgCastExp = CGModelFactory.eINSTANCE.createCGCastExp();
        CGUtil.wrap(cgCastExp, cgChild);
        TypedElement pivot = (TypedElement)cgChild.getAst();
        Type asType = pivot.getType();
        cgCastExp.setAst((Element)pivot);
        if (asType != null) {
            CGExecutorType cgExecutorType = ((CodeGenAnalyzer)this.context).createExecutorType(asType);
            cgCastExp.setExecutorType(cgExecutorType);
        }
        cgCastExp.setTypeId(this.codeGenerator.getAnalyzer().getTypeId(pivot.getTypeId()));
        return cgCastExp;
    }

    protected CGValuedElement rewriteAsUnboxed(@Nullable CGValuedElement cgChild) {
        if (cgChild == null || cgChild.isUnboxed()) {
            return cgChild;
        }
        CGTypeId cgTypeId = cgChild.getTypeId();
        ElementId elementId = cgTypeId.getElementId();
        if (elementId != null) {
            EClassifier eClassifier;
            java.lang.Class instanceClass;
            EcoreDescriptor ecoreDescriptor;
            BoxedDescriptor boxedDescriptor = this.codeGenerator.getBoxedDescriptor(elementId);
            UnboxedDescriptor unboxedDescriptor = boxedDescriptor.getUnboxedDescriptor(this.codeGenerator);
            if (cgChild.isEcore() ? unboxedDescriptor == (ecoreDescriptor = boxedDescriptor.getEcoreDescriptor(this.codeGenerator, instanceClass = (eClassifier = cgChild.getEcoreClassifier()) != null ? eClassifier.getInstanceClass() : null)) || ecoreDescriptor instanceof UnboxedDescriptor : unboxedDescriptor == boxedDescriptor) {
                return cgChild;
            }
        }
        CGUnboxExp cgUnboxExp = CGModelFactory.eINSTANCE.createCGUnboxExp();
        CGUtil.wrap(cgUnboxExp, cgChild);
        return cgUnboxExp;
    }

    @Override
    public @Nullable Object visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    @Override
    public @Nullable Object visitCGBuiltInIterationCallExp(@NonNull CGBuiltInIterationCallExp cgElement) {
        super.visitCGBuiltInIterationCallExp(cgElement);
        this.rewriteAsBoxed(this.rewriteAsGuarded(cgElement.getSource(), this.isSafe(cgElement), "source for '" + cgElement.getReferredIteration() + "'"));
        CGValuedElement cgBody = cgElement.getBody();
        if (cgBody.isRequired()) {
            this.rewriteAsBoxed(this.rewriteAsGuarded(cgBody, false, "body for '" + cgElement.getReferredIteration() + "'"));
        } else {
            this.rewriteAsBoxed(cgBody);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGCachedOperationCallExp(@NonNull CGCachedOperationCallExp cgElement) {
        super.visitCGCachedOperationCallExp(cgElement);
        CGValuedElement cgSource = cgElement.getSource();
        this.rewriteAsGuarded(cgSource, this.isSafe(cgElement), "source for '" + cgElement.getReferredOperation() + "'");
        this.rewriteAsBoxed(cgSource);
        List<CGValuedElement> cgArguments = cgElement.getArguments();
        int iMax = cgArguments.size();
        int i = 0;
        while (i < iMax) {
            this.rewriteAsBoxed(cgArguments.get(i));
            ++i;
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGEcoreOperation(@NonNull CGEcoreOperation cgElement) {
        super.visitCGEcoreOperation(cgElement);
        CGValuedElement body = cgElement.getBody();
        if (body != null) {
            this.rewriteAsEcore(body, cgElement.getEOperation().getEType());
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGEcoreOperationCallExp(@NonNull CGEcoreOperationCallExp cgElement) {
        super.visitCGEcoreOperationCallExp(cgElement);
        CGValuedElement cgSource = cgElement.getSource();
        this.rewriteAsGuarded(cgSource, this.isSafe(cgElement), "source for '" + cgElement.getReferredOperation() + "'");
        EOperation eOperation = cgElement.getEOperation();
        EList eParameters = eOperation.getEParameters();
        this.rewriteAsEcore(cgSource, (EClassifier)eOperation.getEContainingClass());
        List<CGValuedElement> cgArguments = cgElement.getArguments();
        int iMax = cgArguments.size();
        int i = 0;
        while (i < iMax) {
            this.rewriteAsEcore(cgArguments.get(i), ((EParameter)eParameters.get(i)).getEType());
            ++i;
        }
        if (eOperation.isMany()) {
            this.rewriteAsAssertNonNulled(cgElement);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGEcoreOppositePropertyCallExp(@NonNull CGEcoreOppositePropertyCallExp cgElement) {
        super.visitCGEcoreOppositePropertyCallExp(cgElement);
        this.rewriteAsEcore(cgElement.getSource(), cgElement.getEStructuralFeature().getEType());
        if (cgElement.getEStructuralFeature().isMany()) {
            this.rewriteAsAssertNonNulled(cgElement);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGEcorePropertyCallExp(@NonNull CGEcorePropertyCallExp cgElement) {
        super.visitCGEcorePropertyCallExp(cgElement);
        this.rewriteAsEcore(cgElement.getSource(), (EClassifier)cgElement.getEStructuralFeature().getEContainingClass());
        if (cgElement.getEStructuralFeature().isMany()) {
            this.rewriteAsAssertNonNulled(cgElement);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGExecutorOppositePropertyCallExp(@NonNull CGExecutorOppositePropertyCallExp cgElement) {
        super.visitCGExecutorOppositePropertyCallExp(cgElement);
        this.rewriteAsUnboxed(cgElement.getSource());
        CGTypedElement cgParent = (CGTypedElement)cgElement.getParent();
        if (cgParent != null) {
            this.rewriteAsBoxed(cgElement);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGExecutorPropertyCallExp(@NonNull CGExecutorPropertyCallExp cgElement) {
        super.visitCGExecutorPropertyCallExp(cgElement);
        this.rewriteAsUnboxed(cgElement.getSource());
        CGTypedElement cgParent = (CGTypedElement)cgElement.getParent();
        if (cgParent != null) {
            this.rewriteAsBoxed(cgElement);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGElement(@NonNull CGElement cgElement) {
        for (CGElement cGElement : cgElement.getChildren()) {
            cGElement.accept(this);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGIfExp(@NonNull CGIfExp cgElement) {
        boolean elseIsBoxed;
        boolean thenIsBoxed;
        super.visitCGIfExp(cgElement);
        this.rewriteAsGuarded(cgElement.getCondition(), false, "if condition");
        CGValuedElement thenExpression = cgElement.getThenExpression();
        CGValuedElement elseExpression = cgElement.getElseExpression();
        if (thenExpression != null && elseExpression != null && (thenIsBoxed = thenExpression.isBoxed()) != (elseIsBoxed = elseExpression.isBoxed())) {
            if (thenIsBoxed) {
                this.rewriteAsBoxed(cgElement.getElseExpression());
            } else {
                this.rewriteAsBoxed(cgElement.getThenExpression());
            }
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGIsEqualExp(@NonNull CGIsEqualExp cgElement) {
        super.visitCGIsEqualExp(cgElement);
        CGValuedElement cgSource = cgElement.getSource();
        CGValuedElement cgArgument = cgElement.getArgument();
        boolean sourceIsBoxed = cgSource.isBoxed();
        boolean argumentIsBoxed = cgArgument.isBoxed();
        if (sourceIsBoxed != argumentIsBoxed) {
            if (!sourceIsBoxed) {
                this.rewriteAsBoxed(cgSource);
            }
            if (!argumentIsBoxed) {
                this.rewriteAsBoxed(cgArgument);
            }
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGIsEqual2Exp(@NonNull CGIsEqual2Exp cgElement) {
        super.visitCGIsEqual2Exp(cgElement);
        CGValuedElement cgSource = cgElement.getSource();
        CGValuedElement cgArgument = cgElement.getArgument();
        boolean sourceIsBoxed = cgSource.isBoxed();
        boolean argumentIsBoxed = cgArgument.isBoxed();
        if (sourceIsBoxed != argumentIsBoxed) {
            if (!sourceIsBoxed) {
                this.rewriteAsBoxed(cgSource);
            }
            if (!argumentIsBoxed) {
                this.rewriteAsBoxed(cgArgument);
            }
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGLibraryIterateCallExp(@NonNull CGLibraryIterateCallExp cgElement) {
        super.visitCGLibraryIterateCallExp(cgElement);
        this.rewriteAsGuarded(cgElement.getSource(), this.isSafe(cgElement), "source for '" + cgElement.getReferredIteration() + "'");
        this.rewriteAsBoxed(cgElement.getSource());
        LibraryIteration libraryIteration = cgElement.getLibraryIteration();
        if (!(libraryIteration instanceof IterateIteration)) {
            this.rewriteAsBoxed(cgElement.getBody());
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGLibraryIterationCallExp(@NonNull CGLibraryIterationCallExp cgElement) {
        super.visitCGLibraryIterationCallExp(cgElement);
        this.rewriteAsGuarded(cgElement.getSource(), this.isSafe(cgElement), "source for '" + cgElement.getReferredIteration() + "'");
        this.rewriteAsBoxed(cgElement.getSource());
        LibraryIteration libraryIteration = cgElement.getLibraryIteration();
        if (!(libraryIteration instanceof IterateIteration)) {
            this.rewriteAsBoxed(cgElement.getBody());
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGLibraryOperation(@NonNull CGLibraryOperation cgLibraryOperation) {
        super.visitCGLibraryOperation(cgLibraryOperation);
        this.rewriteAsBoxed(cgLibraryOperation.getBody());
        return null;
    }

    @Override
    public @Nullable Object visitCGLibraryOperationCallExp(@NonNull CGLibraryOperationCallExp cgElement) {
        super.visitCGLibraryOperationCallExp(cgElement);
        this.rewriteAsBoxed(cgElement.getSource());
        List<CGValuedElement> cgArguments = cgElement.getArguments();
        int iMax = cgArguments.size();
        int i = 0;
        while (i < iMax) {
            this.rewriteAsBoxed(cgArguments.get(i));
            ++i;
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGNativeOperationCallExp(@NonNull CGNativeOperationCallExp cgElement) {
        super.visitCGNativeOperationCallExp(cgElement);
        CGValuedElement cgSource = cgElement.getSource();
        this.rewriteAsGuarded(cgSource, this.isSafe(cgElement), "source for '" + cgElement.getReferredOperation() + "'");
        this.rewriteAsUnboxed(cgSource);
        List<CGValuedElement> cgArguments = cgElement.getArguments();
        int iMax = cgArguments.size();
        int i = 0;
        while (i < iMax) {
            this.rewriteAsUnboxed(cgArguments.get(i));
            ++i;
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGNavigationCallExp(@NonNull CGNavigationCallExp cgElement) {
        String referredPropertyName;
        super.visitCGNavigationCallExp(cgElement);
        Property referredProperty = cgElement.getReferredProperty();
        if (referredProperty == null) {
            referredPropertyName = "unknown";
        } else if (referredProperty.eContainer() instanceof TupleType) {
            referredPropertyName = referredProperty.getName();
        } else {
            PropertyId referredPropertyId = referredProperty.getPropertyId();
            referredPropertyName = ValueUtil.getElementIdName((ElementId)referredPropertyId);
        }
        this.rewriteAsGuarded(cgElement.getSource(), this.isSafe(cgElement), "source for '" + referredPropertyName + "'");
        return null;
    }

    @Override
    public @Nullable Object visitCGOperation(@NonNull CGOperation cgElement) {
        CGValuedElement body;
        super.visitCGOperation(cgElement);
        if (cgElement.isRequired() && (body = cgElement.getBody()) != null) {
            this.rewriteAsGuarded(body, false, "body for '" + cgElement.getAst() + "'");
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGProperty(@NonNull CGProperty cgElement) {
        CGValuedElement body;
        super.visitCGProperty(cgElement);
        if (cgElement.isRequired() && (body = cgElement.getBody()) != null) {
            this.rewriteAsGuarded(body, false, "body for '" + cgElement.getAst() + "'");
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGShadowPart(@NonNull CGShadowPart cgShadowPart) {
        this.rewriteAsUnboxed(cgShadowPart.getInit());
        return super.visitCGShadowPart(cgShadowPart);
    }

    @Override
    public @Nullable Object visitCGVariableExp(@NonNull CGVariableExp cgElement) {
        CGParameter cgParameter;
        EObject cgOperation;
        super.visitCGVariableExp(cgElement);
        CGVariable referredVariable = cgElement.getReferredVariable();
        if (referredVariable instanceof CGIterator) {
            CGIterator cgIterator = (CGIterator)referredVariable;
            EObject cgOperation2 = cgIterator.eContainer();
            if (cgOperation2 instanceof CGIterationCallExp && !(cgOperation2 instanceof CGBuiltInIterationCallExp)) {
                this.rewriteAsCast(cgElement);
            }
        } else if (referredVariable instanceof CGParameter && (cgOperation = (cgParameter = (CGParameter)referredVariable).eContainer()) instanceof CGLibraryOperation) {
            this.rewriteAsCast(cgElement);
        }
        return null;
    }
}

