/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class TraceMMExplorer {
  private final EPackage tracemm;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass stateClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificStateClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificTraceClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificTracedObjectClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificDimensionClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificStepClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificRootStepClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificValueClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificAttributeValueClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EClass specificReferenceValueClass;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EReference dimensionsReference;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EPackage stepsPackage;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  protected final EPackage statesPackage;
  
  protected final EFactory rootFactory;
  
  protected final EFactory stepFactory;
  
  protected final EFactory stateFactory;
  
  /**
   * Here we focus on the part of the base trace mm, because TraceMMExplorer is
   * used in the TraceMMGenerator as well.
   */
  public TraceMMExplorer(final EPackage traceMetamodel) {
    this.tracemm = traceMetamodel;
    final Function1<EClass, Boolean> _function = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_Trace));
    };
    EClass _findFirst = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function);
    this.specificTraceClass = ((EClass) _findFirst);
    final Function1<EClass, Boolean> _function_1 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_SpecificState));
    };
    EClass _findFirst_1 = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function_1);
    this.specificStateClass = ((EClass) _findFirst_1);
    final Function1<EClass, Boolean> _function_2 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_State));
    };
    EClass _findFirst_2 = IterableExtensions.<EClass>findFirst(Iterables.<EClass>filter(this.specificStateClass.getEAllSuperTypes(), EClass.class), _function_2);
    this.stateClass = ((EClass) _findFirst_2);
    final Function1<EClass, Boolean> _function_3 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_TracedObject));
    };
    EClass _findFirst_3 = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function_3);
    this.specificTracedObjectClass = ((EClass) _findFirst_3);
    final Function1<EReference, Boolean> _function_4 = (EReference r) -> {
      return Boolean.valueOf(r.getName().equals(TraceMMStrings.ref_Dimensions));
    };
    this.dimensionsReference = IterableExtensions.<EReference>findFirst(this.specificTracedObjectClass.getEAllContainments(), _function_4);
    final Function1<EClass, Boolean> _function_5 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_Dimension));
    };
    EClass _findFirst_4 = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function_5);
    this.specificDimensionClass = ((EClass) _findFirst_4);
    final Function1<EClass, Boolean> _function_6 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_Value));
    };
    EClass _findFirst_5 = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function_6);
    this.specificValueClass = ((EClass) _findFirst_5);
    final Function1<EClass, Boolean> _function_7 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_AttributeValue));
    };
    EClass _findFirst_6 = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function_7);
    this.specificAttributeValueClass = ((EClass) _findFirst_6);
    final Function1<EClass, Boolean> _function_8 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_ReferenceValue));
    };
    EClass _findFirst_7 = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function_8);
    this.specificReferenceValueClass = ((EClass) _findFirst_7);
    final Function1<EClass, Boolean> _function_9 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_Step));
    };
    EClass _findFirst_8 = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function_9);
    this.specificStepClass = ((EClass) _findFirst_8);
    this.stepsPackage = this.specificStepClass.getEPackage();
    final Function1<EClass, Boolean> _function_10 = (EClass c) -> {
      return Boolean.valueOf(c.getName().equals(TraceMMStrings.class_RootStep));
    };
    EClass _findFirst_9 = IteratorExtensions.<EClass>findFirst(Iterators.<EClass>filter(this.tracemm.eAllContents(), EClass.class), _function_10);
    this.specificRootStepClass = ((EClass) _findFirst_9);
    final Function1<EPackage, Boolean> _function_11 = (EPackage p) -> {
      return Boolean.valueOf(p.getName().equals(TraceMMStrings.package_States));
    };
    EPackage _findFirst_10 = IteratorExtensions.<EPackage>findFirst(Iterators.<EPackage>filter(this.tracemm.eAllContents(), EPackage.class), _function_11);
    this.statesPackage = ((EPackage) _findFirst_10);
    this.rootFactory = this.tracemm.getEFactoryInstance();
    this.stepFactory = this.stepsPackage.getEFactoryInstance();
    this.stateFactory = this.statesPackage.getEFactoryInstance();
  }
  
  private boolean initDone = false;
  
  public void init() {
    if ((!this.initDone)) {
      HashSet<EClass> _hashSet = new HashSet<EClass>();
      this.stepClassesCache = _hashSet;
      final Function1<EClass, Boolean> _function = (EClass c) -> {
        return Boolean.valueOf((!Objects.equal(c, this.specificStepClass)));
      };
      this.stepClassesCache.addAll(IteratorExtensions.<EClass>toSet(IteratorExtensions.<EClass>filter(Iterators.<EClass>filter(this.stepsPackage.eAllContents(), EClass.class), _function)));
      final Function1<EReference, Boolean> _function_1 = (EReference r) -> {
        boolean _equals = r.getName().equals(TraceMMStrings.ref_ValueToStates);
        return Boolean.valueOf((!_equals));
      };
      this.refs_valueRefsFromStateClassCache = IterableExtensions.<EReference>toSet(IterableExtensions.<EReference>filter(this.specificStateClass.getEAllReferences(), _function_1));
      this.initDone = true;
    }
  }
  
  private Set<EClass> stepClassesCache = null;
  
  public Set<EClass> stepClasses() {
    this.init();
    return this.stepClassesCache;
  }
  
  private final Map<EClass, EReference> stepSequenceRefOfCache = new HashMap<EClass, EReference>();
  
  public EReference stepSequenceRefOf(final EClass stepClass) {
    boolean _containsKey = this.stepSequenceRefOfCache.containsKey(stepClass);
    boolean _not = (!_containsKey);
    if (_not) {
      final Function1<EReference, Boolean> _function = (EReference r) -> {
        return Boolean.valueOf(r.getName().equals(TraceMMStrings.ref_createTraceClassToStepClass(stepClass)));
      };
      this.stepSequenceRefOfCache.put(stepClass, IterableExtensions.<EReference>findFirst(this.specificTraceClass.getEReferences(), _function));
    }
    return this.stepSequenceRefOfCache.get(stepClass);
  }
  
  public EObject createEventOccurrence(final EClass stepClass) {
    return this.stepFactory.create(stepClass);
  }
  
  public EObject createTracedObject(final EClass tracedClass) {
    return tracedClass.getEPackage().getEFactoryInstance().create(tracedClass);
  }
  
  public EObject createState(final EClass stateClass) {
    return this.stateFactory.create(stateClass);
  }
  
  private Set<EReference> refs_valueRefsFromStateClassCache;
  
  public Set<EReference> refs_valueRefsFromStateClass() {
    this.init();
    return this.refs_valueRefsFromStateClassCache;
  }
  
  private final Map<EClass, Set<EReference>> refs_originalObjectCache = new HashMap<EClass, Set<EReference>>();
  
  public Set<EReference> refs_originalObject(final EClass traceClass) {
    boolean _containsKey = this.refs_originalObjectCache.containsKey(traceClass);
    boolean _not = (!_containsKey);
    if (_not) {
      final Function1<EReference, Boolean> _function = (EReference r) -> {
        return Boolean.valueOf(r.getName().startsWith(TraceMMStrings.ref_OriginalObject));
      };
      this.refs_originalObjectCache.put(traceClass, IterableExtensions.<EReference>toSet(IterableExtensions.<EReference>filter(traceClass.getEAllReferences(), _function)));
    }
    return this.refs_originalObjectCache.get(traceClass);
  }
  
  @Pure
  public EClass getStateClass() {
    return this.stateClass;
  }
  
  @Pure
  public EClass getSpecificStateClass() {
    return this.specificStateClass;
  }
  
  @Pure
  public EClass getSpecificTraceClass() {
    return this.specificTraceClass;
  }
  
  @Pure
  public EClass getSpecificTracedObjectClass() {
    return this.specificTracedObjectClass;
  }
  
  @Pure
  public EClass getSpecificDimensionClass() {
    return this.specificDimensionClass;
  }
  
  @Pure
  public EClass getSpecificStepClass() {
    return this.specificStepClass;
  }
  
  @Pure
  public EClass getSpecificRootStepClass() {
    return this.specificRootStepClass;
  }
  
  @Pure
  public EClass getSpecificValueClass() {
    return this.specificValueClass;
  }
  
  @Pure
  public EClass getSpecificAttributeValueClass() {
    return this.specificAttributeValueClass;
  }
  
  @Pure
  public EClass getSpecificReferenceValueClass() {
    return this.specificReferenceValueClass;
  }
  
  @Pure
  public EReference getDimensionsReference() {
    return this.dimensionsReference;
  }
  
  @Pure
  public EPackage getStepsPackage() {
    return this.stepsPackage;
  }
  
  @Pure
  public EPackage getStatesPackage() {
    return this.statesPackage;
  }
}
