/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.gemoc_studio.branding.handlers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.amalgam.discovery.DiscoveryDefinition;
import org.eclipse.amalgam.discovery.core.CancellableXMIResourceImpl;
import org.eclipse.amalgam.discovery.ui.viewer.DiscoveryContentProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.gemoc_studio.branding.Activator;
import org.eclipse.gemoc.gemoc_studio.branding.discovery.wizards.DiscoveryWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class GemocPackageDiscovery
extends DiscoveryContentProvider {
    private static final String CATALOG_URI = "http://gemoc.org/discovery/gemoc_3.1.x/catalog.xmi";

    public DiscoveryDefinition load(IProgressMonitor monitor) throws InterruptedException {
        DiscoveryDefinition result;
        URI catalogURI = URI.createURI((String)CATALOG_URI);
        Activator.getDefault().prepareProxySettings(CATALOG_URI);
        CancellableXMIResourceImpl res = new CancellableXMIResourceImpl(catalogURI, monitor);
        try {
            res.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            this.errorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), e);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        this.disco = result = (DiscoveryDefinition)res.getContents().get(0);
        return result;
    }

    private void errorDialog(Shell shell, Exception e) {
        String message = "We can't connect to the discovery source: \nhttp://gemoc.org/discovery/gemoc_3.1.x/catalog.xmi\n Make sure you're connected to internet and try again.";
        MessageDialog.openError((Shell)shell, (String)"Can't connect to discovery source", (String)message);
        throw new RuntimeException(e);
    }

    public String getDescription() {
        return "Pick a GEMOC component to install it.";
    }

    public String getTitle() {
        return "GEMOC Components Discovery";
    }

    public static void openModelingDiscoveryWizard(IWorkbenchWindow window) {
        final GemocPackageDiscovery provider = new GemocPackageDiscovery();
        IWorkbench wb = PlatformUI.getWorkbench();
        IProgressService ps = wb.getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) {
                    try {
                        provider.load(pm);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            if (provider.getDiscovery() != null) {
                DiscoveryWizard wizard = new DiscoveryWizard(provider);
                WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                dialog.setMinimumPageSize(600, 400);
                dialog.open();
            }
        }
        catch (InvocationTargetException e1) {
            if (!(e1.getCause() instanceof OperationCanceledException)) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gemoc.gemoc_studio.branding", e1.getMessage(), (Throwable)e1));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

