/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.profiler;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.gemoc.executionframework.engine.profiler.Unit;

public class Profiler {
    private List<Unit> _units = new ArrayList<Unit>();
    private Hashtable<Unit, List<Date>> _startTimes = new Hashtable();
    private Hashtable<Unit, List<Date>> _endTimes = new Hashtable();

    public void start(String unitName) {
        Unit unit = this.getOrCreateUnit(unitName);
        List<Date> startTimes = this.getOrCreateStartTimes(unit);
        startTimes.add(new Date());
    }

    public void end(String unitName) {
        Unit unit = this.getOrCreateUnit(unitName);
        List<Date> endTimes = this.getOrCreateEndTimes(unit);
        endTimes.add(new Date());
    }

    private Unit getOrCreateUnit(String unitName) {
        Unit unit = this.getUnit(unitName);
        if (unit == null) {
            unit = new Unit(unitName);
            this._units.add(unit);
        }
        return unit;
    }

    private Unit getUnit(String unitName) {
        for (Unit u : this._units) {
            if (!u.getName().equals(unitName)) continue;
            return u;
        }
        return null;
    }

    private List<Date> getOrCreateStartTimes(Unit unit) {
        List<Date> l = this._startTimes.get(unit);
        if (l == null) {
            l = new ArrayList<Date>();
            this._startTimes.put(unit, l);
        }
        return l;
    }

    private List<Date> getOrCreateEndTimes(Unit unit) {
        List<Date> l = this._endTimes.get(unit);
        if (l == null) {
            l = new ArrayList<Date>();
            this._endTimes.put(unit, l);
        }
        return l;
    }

    public void printReport() {
        for (Unit u : this._units) {
            System.out.printf(String.valueOf(u.getName()) + ": ", new Object[0]);
            int i = 0;
            while (i != this._startTimes.get(u).size() || i != this._endTimes.get(u).size()) {
                Date start = this._startTimes.get(u).get(i);
                Date end = this._endTimes.get(u).get(i);
                System.out.printf(String.valueOf(end.getTime() - start.getTime()) + "ms, ", new Object[0]);
                ++i;
            }
            System.out.printf("\r\n", new Object[0]);
        }
    }
}

